/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import com.intellij.openapi.project.Project;
import cottons.utils.MimeTypes;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.RESTNotificationActionRenderer;
import io.intino.konos.builder.codegeneration.action.RESTResourceActionRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RestResourceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Redirect;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.rest.RESTService;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class RESTResourceRenderer {
    private static final String RESOURCES_PACKAGE = "rest/resources";
    private static final String NOTIFICATIONS_PACKAGE = "rest/notifications";
    private final Project project;
    private final List<RESTService> services;
    private File gen;
    private File src;
    private String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public RESTResourceRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.project = project;
        this.services = graph.rESTServiceList();
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(RESTService service) {
        service.core$().findNode(RESTService.Resource.class).forEach(this::processResource);
        service.core$().findNode(RESTService.Notification.class).forEach(this::processNotification);
    }

    private void processResource(RESTService.Resource resource) {
        for (RESTService.Resource.Operation operation : resource.operationList()) {
            Frame frame = this.frameOf(resource, operation);
            String className = StringHelper.snakeCaseToCamelCase((String)(((Object)((Object)operation)).getClass().getSimpleName() + "_" + resource.name$())) + "Resource";
            Commons.writeFrame(new File(this.gen, RESOURCES_PACKAGE), className, this.template().format((Object)frame));
            this.createCorrespondingAction(operation);
        }
    }

    private void processNotification(RESTService.Notification notification) {
        String className = StringHelper.snakeCaseToCamelCase((String)notification.name$()) + "Notification";
        RESTService service = (RESTService)notification.core$().ownerAs(RESTService.class);
        Frame frame = new Frame(new String[]{"notification"}).addSlot("path", new String[]{notification.path()});
        this.addCommonSlots(notification.name$(), frame);
        frame.addSlot("parameter", (AbstractFrame[])this.notificationParameters(notification.parameterList()));
        frame.addSlot("returnType", new AbstractFrame[]{this.notificationResponse()});
        this.authenticated(service, frame);
        if (service.authenticatedWithToken() != null) {
            frame.addSlot("throws", new String[]{"Unauthorized"});
        }
        Commons.writeFrame(new File(this.gen, NOTIFICATIONS_PACKAGE), className, this.template().format((Object)frame));
        this.createCorrespondingAction(notification);
    }

    private void createCorrespondingAction(RESTService.Resource.Operation operation) {
        new RESTResourceActionRenderer(this.project, operation, this.src, this.packageName, this.boxName, this.classes).execute();
    }

    private void createCorrespondingAction(RESTService.Notification notification) {
        new RESTNotificationActionRenderer(this.project, notification, this.src, this.packageName, this.boxName, this.classes).execute();
    }

    private Frame frameOf(RESTService.Resource resource, RESTService.Resource.Operation operation) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"resource"});
        this.addCommonSlots(resource.name$(), frame);
        frame.addSlot("operation", new String[]{((Object)((Object)operation)).getClass().getSimpleName()});
        frame.addSlot("throws", this.throwCodes(operation));
        frame.addSlot("parameter", (AbstractFrame[])this.parameters(operation.parameterList()));
        if (this.hasResponse(operation)) {
            frame.addSlot("returnType", new AbstractFrame[]{this.frameOf(operation.response())});
        }
        if (!resource.graph().schemaList().isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        this.authenticated((RESTService)resource.core$().ownerAs(RESTService.class), frame);
        return frame;
    }

    private void authenticated(RESTService service, Frame frame) {
        RESTService.AuthenticatedWithToken authenticated = service.authenticatedWithToken();
        if (authenticated != null) {
            frame.addSlot("authenticationValidator", new AbstractFrame[]{new Frame(new String[]{"authenticationValidator"}).addSlot("type", new String[]{"Basic"})});
        }
    }

    private void addCommonSlots(String name, Frame frame) {
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{name});
        frame.addSlot("box", new String[]{this.boxName});
    }

    private boolean hasResponse(RESTService.Resource.Operation operation) {
        return operation.response() != null && (operation.response().isType() || operation.response().i$(Redirect.class));
    }

    private Frame frameOf(Response response) {
        Frame frame = new Frame(new String[]{((Object)((Object)response)).getClass().getSimpleName()}).addSlot("value", new String[]{Commons.returnType(response, this.packageName)});
        if (response.isText() && response.dataFormat() != Response.DataFormat.html) {
            frame.addSlot("format", new String[]{MimeTypes.get((String)response.dataFormat().toString())});
        }
        return frame;
    }

    private Frame notificationResponse() {
        return new Frame(new String[]{"Response"}).addSlot("value", new String[]{String.class.getSimpleName()}).addSlot("format", new String[]{MimeTypes.get((String)"text")});
    }

    private String[] throwCodes(RESTService.Resource.Operation resource) {
        String[] stringArray;
        RESTService.AuthenticatedWithToken authenticated = ((RESTService)resource.core$().ownerAs(RESTService.class)).authenticatedWithToken();
        List<String> throwCodes = resource.exceptionList().stream().map(r -> r.code().toString()).collect(Collectors.toList());
        if (authenticated != null) {
            throwCodes.add("Unauthorized");
        }
        if (throwCodes.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Unknown";
        } else {
            stringArray = throwCodes.toArray(new String[0]);
        }
        return stringArray;
    }

    private Frame[] parameters(List<? extends RESTService.Resource.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame[] notificationParameters(List<RESTService.Notification.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(RESTService.Resource.Parameter parameter) {
        Frame parameterFrame = new Frame(new String[0]).addTypes(new String[]{"parameter", parameter.in().toString(), ((Object)((Object)parameter.asType())).getClass().getSimpleName(), parameter.isRequired() ? "required" : "optional"});
        if (parameter.isList()) {
            parameterFrame.addTypes(new String[]{"List"});
        }
        parameterFrame.addSlot("name", new String[]{parameter.name$()}).addSlot("parameterType", new AbstractFrame[]{this.parameterType(parameter)}).addSlot("in", new String[]{parameter.in().name()});
        if (parameter.isRequired()) {
            return parameterFrame;
        }
        if (parameter.isBool()) {
            parameterFrame.addTypes(new String[]{"defaultValue"}).addSlot("defaultValue", new Boolean[]{parameter.asBool().defaultValue()});
        } else if (parameter.isText()) {
            parameterFrame.addTypes(new String[]{"defaultValue"}).addSlot("defaultValue", new String[]{parameter.asText().defaultValue()});
        } else if (parameter.isReal()) {
            parameterFrame.addTypes(new String[]{"defaultValue"}).addSlot("defaultValue", new Double[]{parameter.asReal().defaultValue()});
        } else if (parameter.isInteger()) {
            parameterFrame.addTypes(new String[]{"defaultValue"}).addSlot("defaultValue", new Integer[]{parameter.asInteger().defaultValue()});
        } else if (parameter.isLongInteger()) {
            parameterFrame.addTypes(new String[]{"defaultValue"}).addSlot("defaultValue", new Integer[]{parameter.asLongInteger().defaultValue()});
        }
        return parameterFrame;
    }

    private Frame parameter(RESTService.Notification.Parameter parameter) {
        Frame parameterFrame = new Frame(new String[0]).addTypes(new String[]{"parameter", parameter.in().toString(), ((Object)((Object)parameter.asType())).getClass().getSimpleName(), parameter.isRequired() ? "required" : "optional"});
        if (parameter.isList()) {
            parameterFrame.addTypes(new String[]{"List"});
        }
        return parameterFrame.addSlot("name", new String[]{parameter.name$()}).addSlot("parameterType", new AbstractFrame[]{this.parameterType(parameter)}).addSlot("in", new String[]{parameter.in().name()});
    }

    private Frame parameterType(Parameter parameter) {
        String innerPackage = parameter.isObject() && parameter.asObject().isComponent() ? String.join((CharSequence)".", this.packageName, "schemas.") : "";
        Frame frame = new Frame(new String[0]).addSlot("value", new String[]{innerPackage + parameter.asType().type()});
        if (parameter.i$(ListData.class)) {
            frame.addTypes(new String[]{"list"});
        }
        return frame;
    }

    private Template template() {
        return Formatters.customize(RestResourceTemplate.create());
    }
}

