/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.type.TypeData;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class ActionUpdater {
    private final Project project;
    private final String packageName;
    private final List<? extends Parameter> parameters;
    private final List<Exception> exceptions;
    private final Response response;
    private final PsiFile file;

    ActionUpdater(Project project, File destiny, String packageName, List<? extends Parameter> parameters, List<Exception> exceptions, Response response) {
        this.project = project;
        this.packageName = packageName;
        this.parameters = parameters;
        this.exceptions = exceptions;
        this.response = response;
        this.file = PsiManager.getInstance((Project)project).findFile(Objects.requireNonNull(VfsUtil.findFileByIoFile((File)destiny, (boolean)true)));
    }

    void update() {
        if (!(this.file instanceof PsiJavaFile) || ((PsiJavaFile)this.file).getClasses()[0] == null) {
            return;
        }
        PsiClass psiClass = ((PsiJavaFile)this.file).getClasses()[0];
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> this.update(psiClass));
        } else {
            this.update(psiClass);
        }
    }

    private void update(PsiClass psiClass) {
        this.updateFields(psiClass);
        if (psiClass.getMethods().length > 0) {
            PsiMethod method = this.findExecuteMethod(psiClass);
            if (method == null) {
                return;
            }
            this.updateExceptions(method);
            this.updateReturnType(method);
        }
    }

    private PsiMethod findExecuteMethod(PsiClass psiClass) {
        for (PsiMethod method : psiClass.findMethodsByName("execute", false)) {
            if (method.hasTypeParameters()) continue;
            return method;
        }
        return null;
    }

    private void updateFields(PsiClass psiClass) {
        if (DumbService.isDumb((Project)this.project)) {
            DumbService.getInstance((Project)this.project).smartInvokeLater(() -> this.doUpdateFields(psiClass));
        } else {
            this.doUpdateFields(psiClass);
        }
    }

    private void doUpdateFields(PsiClass psiClass) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.project);
        this.parameters.stream().filter(parameter -> Arrays.stream(psiClass.getAllFields()).noneMatch(f -> this.nameOf((Parameter)((Object)parameter)).equalsIgnoreCase(f.getName()))).forEach(parameter -> psiClass.addAfter((PsiElement)this.createField(psiClass, elementFactory, (Parameter)((Object)parameter)), psiClass.getLBrace().getNextSibling()));
        if (Arrays.stream(psiClass.getAllFields()).noneMatch(f -> "box".equalsIgnoreCase(f.getName()))) {
            psiClass.addAfter((PsiElement)this.createGraphField(psiClass, elementFactory), psiClass.getLBrace().getNextSibling());
        }
    }

    private void updateExceptions(PsiMethod psiMethod) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.project);
        for (Exception exception : this.exceptions) {
            if (this.hasException(psiMethod.getThrowsList().getReferenceElements(), exception)) continue;
            psiMethod.getThrowsList().add((PsiElement)elementFactory.createReferenceFromText(exception.core$().owner().owner() == null ? this.exceptionReference(exception) : exception.code().name(), (PsiElement)psiMethod));
        }
    }

    private boolean hasException(PsiJavaCodeReferenceElement[] referenceElements, Exception exception) {
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
            if (!exception.code().name().equals(referenceElement.getReferenceName())) continue;
            return true;
        }
        return false;
    }

    private String exceptionReference(Exception exception) {
        return this.packageName + ".exceptions." + Commons.firstUpperCase(exception.name$());
    }

    private void updateReturnType(PsiMethod psiMethod) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.project);
        psiMethod.getReturnTypeElement().replace((PsiElement)elementFactory.createTypeElement(elementFactory.createTypeFromText(this.response == null ? "void" : Commons.returnType(this.response, this.packageName), (PsiElement)psiMethod)));
    }

    private PsiField createField(PsiClass psiClass, PsiElementFactory elementFactory, Parameter parameter) {
        PsiField field = elementFactory.createField(this.nameOf(parameter), elementFactory.createTypeFromText(this.formatType(parameter.asType(), parameter.isList()), (PsiElement)psiClass));
        if (field.getModifierList() == null) {
            return field;
        }
        field.getModifierList().setModifierProperty("public", true);
        field.getModifierList().setModifierProperty("private", false);
        return field;
    }

    @NotNull
    private String nameOf(Parameter parameter) {
        String string = Formatters.firstLowerCase(Formatters.snakeCaseToCamelCase().format((Object)parameter.name$()).toString());
        if (string == null) {
            ActionUpdater.$$$reportNull$$$0(0);
        }
        return string;
    }

    private PsiField createGraphField(PsiClass psiClass, PsiElementFactory elementFactory) {
        PsiField field = elementFactory.createField("box", elementFactory.createTypeFromText("io.intino.konos.Box", (PsiElement)psiClass));
        if (field.getModifierList() == null) {
            return field;
        }
        field.getModifierList().setModifierProperty("public", true);
        field.getModifierList().setModifierProperty("private", false);
        return field;
    }

    private String formatType(TypeData typeData, boolean list) {
        if (typeData == null || typeData.type() == null) {
            return "void";
        }
        String type = (typeData.i$(ObjectData.class) ? this.packageName + ".schemas." : "") + typeData.type();
        return list ? "List<" + type + ">" : type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/action/ActionUpdater", "nameOf"));
    }
}

