/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.jmx;

import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Redirect;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class JMXService
extends Layer
implements Terminal {
    protected String path;
    protected List<Operation> operationList = new ArrayList<Operation>();
    protected List<Notification> notificationList = new ArrayList<Notification>();
    protected Service _service;

    public JMXService(Node node) {
        super(node);
    }

    public String path() {
        return this.path;
    }

    public JMXService path(String value) {
        this.path = value;
        return this;
    }

    public List<Operation> operationList() {
        return Collections.unmodifiableList(this.operationList);
    }

    public Operation operation(int index) {
        return this.operationList.get(index);
    }

    public List<Operation> operationList(Predicate<Operation> predicate) {
        return this.operationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Notification> notificationList() {
        return Collections.unmodifiableList(this.notificationList);
    }

    public Notification notification(int index) {
        return this.notificationList.get(index);
    }

    public List<Notification> notificationList(Predicate<Notification> predicate) {
        return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return this._service.schemaList();
    }

    public Schema schemaList(int index) {
        return this._service.schemaList().get(index);
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
        new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("JMX#Service$Operation")) {
            this.operationList.add((Operation)node.as(Operation.class));
        }
        if (node.is("JMX#Service$Notification")) {
            this.notificationList.add((Notification)node.as(Notification.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("JMX#Service$Operation")) {
            this.operationList.remove(node.as(Operation.class));
        }
        if (node.is("JMX#Service$Notification")) {
            this.notificationList.remove(node.as(Notification.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("path")) {
            this.path = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("path")) {
            this.path = (String)values.get(0);
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Notification
    extends Layer
    implements Terminal {
        public Notification(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Operation
    extends Layer
    implements Terminal {
        protected String description;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected List<Exception> exceptionList = new ArrayList<Exception>();
        protected Response response;

        public Operation(Node node) {
            super(node);
        }

        public String description() {
            return this.description;
        }

        public Operation description(String value) {
            this.description = value;
            return this;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Exception> exceptionList() {
            return Collections.unmodifiableList(this.exceptionList);
        }

        public Exception exception(int index) {
            return this.exceptionList.get(index);
        }

        public List<Exception> exceptionList(Predicate<Exception> predicate) {
            return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Response response() {
            return this.response;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
            if (this.response != null) {
                components.add(this.response.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
            if (node.is("Exception")) {
                this.exceptionList.add((Exception)node.as(Exception.class));
            }
            if (node.is("Response")) {
                this.response = (Response)node.as(Response.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
            if (node.is("Exception")) {
                this.exceptionList.remove(node.as(Exception.class));
            }
            if (node.is("Response")) {
                this.response = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void parameter(Predicate<Parameter> filter) {
                new ArrayList<Parameter>(Operation.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Operation.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter() {
                Parameter newElement = (Parameter)Operation.this.core$().graph().concept(Parameter.class).createNode(this.name, Operation.this.core$()).as(Parameter.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Operation.this.core$().graph().concept(Exception.class).createNode(this.name, Operation.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }

            public Response response() {
                Response newElement = (Response)Operation.this.core$().graph().concept(Response.class).createNode(this.name, Operation.this.core$()).as(Response.class);
                return newElement;
            }

            public RESTService.Notification.Parameter parameter(RESTService.Notification.Parameter.In in) {
                RESTService.Notification.Parameter newElement = (RESTService.Notification.Parameter)Operation.this.core$().graph().concept(RESTService.Notification.Parameter.class).createNode(this.name, Operation.this.core$()).as(RESTService.Notification.Parameter.class);
                newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                return newElement;
            }

            public RESTService.Resource.Parameter parameter(RESTService.Resource.Parameter.In in) {
                RESTService.Resource.Parameter newElement = (RESTService.Resource.Parameter)Operation.this.core$().graph().concept(RESTService.Resource.Parameter.class).createNode(this.name, Operation.this.core$()).as(RESTService.Resource.Parameter.class);
                newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                return newElement;
            }

            public Redirect redirect() {
                Redirect newElement = (Redirect)Operation.this.core$().graph().concept(Redirect.class).createNode(this.name, Operation.this.core$()).as(Redirect.class);
                return newElement;
            }
        }
    }

    public class Clear {
        public void operation(Predicate<Operation> filter) {
            new ArrayList<Operation>(JMXService.this.operationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<Notification> filter) {
            new ArrayList<Notification>(JMXService.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(JMXService.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exception(Predicate<Exception> filter) {
            new ArrayList<Exception>(JMXService.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Operation operation(String description) {
            Operation newElement = (Operation)JMXService.this.core$().graph().concept(Operation.class).createNode(this.name, JMXService.this.core$()).as(Operation.class);
            newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
            return newElement;
        }

        public Notification notification() {
            Notification newElement = (Notification)JMXService.this.core$().graph().concept(Notification.class).createNode(this.name, JMXService.this.core$()).as(Notification.class);
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)JMXService.this.core$().graph().concept(Schema.class).createNode(this.name, JMXService.this.core$()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)JMXService.this.core$().graph().concept(Exception.class).createNode(this.name, JMXService.this.core$()).as(Exception.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }
}

