/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.resource;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class ResourceTemplate
extends Template {
    protected ResourceTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new ResourceTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "resource & accessibleDisplay")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".resources;\n\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".")).add((Token.Body)this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box;\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("ProxyAction;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.exceptions.Unauthorized;\nimport io.intino.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;\nimport io.intino.alexandria.ui.displays.Soul;\nimport io.intino.alexandria.ui.services.auth.exceptions.CouldNotObtainInfo;\nimport io.intino.alexandria.ui.services.push.UIClient;\nimport io.intino.alexandria.ui.services.push.UISession;\n\nimport java.util.function.Function;\n\npublic class ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("ProxyResource extends io.intino.alexandria.ui.spark.resources.ProxyResource {\n\tprivate final ")).add((Token.Body)this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box box;\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("ProxyResource(")).add((Token.Body)this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box box, io.intino.alexandria.ui.spark.UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tfillBrowser(manager, session());\n\t\tfillDeviceParameter();\n\t\ttry {\n\t\t\tif (!isLogged(accessToken()))\n\t\t\t\tthrow new Unauthorized(\"user is not logged\");\n\n\t\t\tauthenticate(session(), accessToken());\n\t\t\trender();\n\t\t} catch (CouldNotObtainInfo couldNotObtainInfo) {\n\t\t\tthrow new Unauthorized(\"user is not logged\");\n\t\t} catch (Throwable error) {\n\t\t\tthrow new Unauthorized(\"could not render component\");\n\t\t}\n\t}\n\n\tprivate void render() {\n\t\tUIClient client = client();\n\n\t\t")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("ProxyAction action = new ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("ProxyAction();\n\t\taction.session = session();\n\t\taction.session.whenLogin(new Function<String, String>() {\n\t\t\t@Override\n\t\t\tpublic String apply(String baseUrl) {\n\t\t\t\treturn ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("ProxyResource.this.authenticate(baseUrl);\n\t\t\t}\n\t\t});\n\t\taction.session.whenLogout(b -> logout());\n\t\taction.box = box;\n\t\taction.clientId = client.id();\n\t\taction.googleApiKey = \"\";\n\t\taction.device = parameterValue(\"device\");\n\t\t")).add((Token.Body)this.mark("parameter", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n\n\t\tSoul soul = soul();\n\t\tif (soul != null) {\n\t\t\taction.soul = soul;\n\t\t\taction.execute();\n\t\t\treturn;\n\t\t}\n\n\t\tsoul = new Soul(action.session) {\n\t\t\t@Override\n\t\t\tpublic void personify() {\n\t\t\t\tSoul soul = this;\n\t\t\t\taddRegisterDisplayListener(display -> {\n\t\t\t\t\tdisplay.inject(notifier(action.session, client, display));\n\t\t\t\t\tdisplay.inject(action.session);\n\t\t\t\t\tdisplay.inject(soul);\n\t\t\t\t\tdisplay.inject(() -> soul);\n\t\t\t\t});\n\t\t\t}\n\t\t};\n\t\tclient.soul(soul);\n\t\taction.soul = soul;\n\t\taction.execute();\n\t\tbox.registerSoul(client.id(), soul);\n\n\t\tmanager.write(\"OK\");\n\t}\n}")), this.rule().add(new Condition[]{this.condition("type", "resource")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".resources;\n\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".")).add((Token.Body)this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box;\nimport ")).add((Token.Body)this.mark("package", new String[]{"validPackage"})).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action;\nimport io.intino.alexandria.exceptions.AlexandriaException;\nimport io.intino.alexandria.ui.displays.AlexandriaDisplayNotifierProvider;\n\nimport java.util.Base64;\nimport java.util.UUID;\nimport java.util.function.Consumer;\nimport java.util.function.Function;\n\npublic class ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Resource extends io.intino.alexandria.ui.spark.resources.")).add((Token.Body)this.expression().add((Token.Body)this.mark("editor", new String[0]))).add((Token.Body)this.literal("Resource {\n\tprivate final ")).add((Token.Body)this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box box;\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Resource(")).add((Token.Body)this.mark("box", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box box, io.intino.alexandria.ui.spark.UISparkManager manager, AlexandriaDisplayNotifierProvider notifierProvider) {\n\t\tsuper(manager, notifierProvider);\n\t\tthis.box = box;\n\t}\n\n\t@Override\n\tpublic void execute() throws AlexandriaException {\n\t\tsuper.execute();\n\t\tfillDeviceParameter();\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("confidential", new String[0])).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\tif (isLogged()) render();")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\telse authenticate();")).or(this.expression().add((Token.Body)this.literal("render();")))).add((Token.Body)this.literal("\n\t}\n\n\tprivate void render() {\n\t\tString clientId = UUID.randomUUID().toString();\n\t\t")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action action = new ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Action();\n\t\taction.session = manager.currentSession();\n\t\taction.session.whenLogin(new Function<String, String>() {\n\t\t\t@Override\n\t\t\tpublic String apply(String baseUrl) {\n\t\t\t\treturn ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase"})).add((Token.Body)this.literal("Resource.this.authenticate(baseUrl);\n\t\t\t}\n\t\t});\n\t\taction.session.whenLogout(b -> logout());\n\t\taction.box = box;\n\t\taction.clientId = clientId;\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("action.googleApiKey = ")).add((Token.Body)this.mark("googleApiKey", new String[]{"format"})).add((Token.Body)this.literal(";"))).add((Token.Body)this.literal("\n\t\taction.device = parameterValue(\"device\");\n\t\taction.token = parameterValue(\"token\");")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t")).add((Token.Body)this.mark("editor", new String[]{"parameters"}))).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.mark("parameter", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n\t\tmanager.pushService().onOpen(client -> {\n\t\t\tif (!client.id().equals(action.clientId))\n\t\t\t\treturn false;\n\n\t\t\tif (client.soul() != null)\n\t\t\t\treturn false;\n\n\t\t\tio.intino.alexandria.ui.displays.Soul soul = action.prepareSoul(client);\n\t\t\tsoul.onRedirect((location) -> manager.redirect(location));\n\t\t\tsoul.addRegisterDisplayListener(display -> {\n\t\t\t\tdisplay.inject(notifier(action.session, client, display));\n\t\t\t\tdisplay.inject(action.session);\n\t\t\t\tdisplay.inject(soul);\n\t\t\t\tdisplay.inject(() -> soul);\n\t\t\t});\n\t\t\tclient.soul(soul);\n\n\t\t\tbox.registerSoul(clientId, soul);\n\n\t\t\treturn true;\n\t\t});\n\n\t\tmanager.pushService().onClose(clientId).execute(new Consumer<io.intino.alexandria.ui.services.push.UIClient>() {\n\t\t\t@Override\n\t\t\tpublic void accept(io.intino.alexandria.ui.services.push.UIClient client) {\n\t\t\t\tbox.soul(client.id()).ifPresent(s -> s.destroy());\n\t\t\t\tbox.unRegisterSoul(client.id());\n\t\t\t\tmanager.unRegister(client);\n\t\t\t}\n\t\t});\n\n\t\tmanager.write(action.execute());\n\t}\n\n}")), this.rule().add(new Condition[]{this.condition("trigger", "parameters")}).add((Token.Body)this.literal("action.document = loadDocument();\naction.permission = loadPermission();")), this.rule().add(new Condition[]{this.condition("type", "parameter")}).add((Token.Body)this.literal("action.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = parameterValue(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\");")), this.rule().add(new Condition[]{this.condition("type", "googleApiKey"), this.condition("trigger", "format")}).add((Token.Body)this.literal("\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\"")).add((Token.Body)this.expression().add((Token.Body)this.mark("custom", new String[0]).multiple(""))), this.rule().add(new Condition[]{this.condition("trigger", "custom")}).add((Token.Body)this.literal(".replace(\"{")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("}\", box.configuration().get(\"")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("\"))"))});
        return this;
    }
}

