/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.task;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class SchedulerTemplate
extends Template {
    protected SchedulerTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new SchedulerTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "scheduler")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[]{"ValidPackage"})).add((Token.Body)this.literal(";\n\nimport ")).add((Token.Body)this.mark("package", new String[]{"ValidPackage"})).add((Token.Body)this.literal(".")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box;\nimport io.intino.alexandria.scheduler.AlexandriaScheduler;\nimport ")).add((Token.Body)this.mark("package", new String[]{"ValidPackage"})).add((Token.Body)this.literal(".scheduling.*;\nimport org.quartz.*;\nimport java.util.LinkedHashSet;\nimport java.util.Map;\nimport java.util.Set;\nimport java.time.ZoneId;\nimport java.util.TimeZone;\nimport java.util.logging.Logger;\n\nimport static org.quartz.JobBuilder.newJob;\nimport static org.quartz.CronScheduleBuilder.*;\nimport static org.quartz.TriggerBuilder.newTrigger;\n\npublic class ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase", "SnakeCaseToCamelCase"})).add((Token.Body)this.literal("Tasks {\n\tprivate static final Logger logger = Logger.getGlobal();\n\n\tprivate ")).add((Token.Body)this.mark("name", new String[]{"firstUpperCase", "SnakeCaseToCamelCase"})).add((Token.Body)this.literal("Tasks() {\n\n\t}\n\n\tpublic static void init(AlexandriaScheduler tasker, ")).add((Token.Body)this.mark("box", new String[]{"FirstUpperCase"})).add((Token.Body)this.literal("Box box) {\n\t\tJobDetail job;\n\t\ttry {\n\t\t\t")).add((Token.Body)this.mark("task", new String[]{"init"}).multiple("\n")).add((Token.Body)this.literal("\n\t\t\ttasker.startSchedules();\n\t\t} catch (Exception e) {\n\t\t\tlogger.severe(e.getMessage());\n\t\t}\n\t}\n\n\tprivate static Set<Trigger> newSet(Trigger... triggers) {\n\t\tLinkedHashSet<Trigger> set = new LinkedHashSet<>();\n\t\tjava.util.Collections.addAll(set, triggers);\n\t\treturn set;\n\t}\n}")), this.rule().add(new Condition[]{this.condition("type", "task"), this.condition("type", "DirectorySentinelTask"), this.condition("trigger", "init")}).add((Token.Body)this.literal("tasker.watchDirectory(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\", new java.io.File(\"")).add((Token.Body)this.mark("file", new String[0])).add((Token.Body)this.literal("\"), (f, e) -> { try {\n\t\t")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase"})).add((Token.Body)this.literal("Action action = new ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".actions.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase"})).add((Token.Body)this.literal("Action();\n\t\taction.box = box;\n\t\taction.directory = f.toURI().toURL();\n\t\taction.event = e;\n\t\taction.execute();\n\t} catch(java.io.IOException ignored) {}\n\t}, ")).add((Token.Body)this.mark("event", new String[]{"fullPath"}).multiple(", ")).add((Token.Body)this.literal(");")), this.rule().add(new Condition[]{this.condition("trigger", "fullPath")}).add((Token.Body)this.literal("io.intino.alexandria.scheduler.directory.KonosDirectorySentinel.Event.")).add((Token.Body)this.mark("value", new String[0])), this.rule().add(new Condition[]{this.condition("type", "task"), this.condition("trigger", "init")}).add((Token.Body)this.literal("job = newJob(")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase"})).add((Token.Body)this.literal("Task.class).withIdentity(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\").build();\njob.getJobDataMap().put(\"box\", box);\ntasker.scheduleJob(job, newSet(")).add((Token.Body)this.mark("job", new String[0]).multiple(", ")).add((Token.Body)this.literal("), true);\n")), this.rule().add(new Condition[]{this.condition("type", "cronTrigger"), this.condition("trigger", "job")}).add((Token.Body)this.literal("newTrigger().withIdentity(\"")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal("\").withSchedule(cronSchedule(\"")).add((Token.Body)this.mark("pattern", new String[0])).add((Token.Body)this.literal("\")")).add((Token.Body)this.expression().add((Token.Body)this.literal(".inTimeZone(TimeZone.getTimeZone(ZoneId.of(\"")).add((Token.Body)this.mark("timeZone", new String[0])).add((Token.Body)this.literal("\")))"))).add((Token.Body)this.literal(").build()")), this.rule().add(new Condition[]{this.condition("type", "onBootTrigger"), this.condition("trigger", "job")}).add((Token.Body)this.literal("newTrigger().startNow().build()"))});
        return this;
    }
}

