/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.DatalakeTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.EventSource;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mounter;
import io.intino.konos.model.graph.Procedure;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.ness.NessClient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class DatalakeRenderer {
    private final NessClient datalake;
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final KonosGraph graph;
    private final Set<EventSource> eventSources;
    private final Set<FeederEventSource> eventFeederSources;

    public DatalakeRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.graph = graph;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.datalake = graph.nessClient(0);
        this.eventSources = this.collectEventSources(graph);
        this.eventFeederSources = this.collectNewFeederSources(graph.nessClientList().stream().map(NessClient::feederList).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    public void execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tanks"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.datalake.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("tank", (AbstractFrame[])this.tanks());
        frame.addSlot("clientId", new AbstractFrame[]{new Frame(new String[]{this.isCustom(this.datalake.clientID()) ? "custom" : "standard"}).addSlot("value", new String[]{this.datalake.clientID()})});
        if (this.eventSources.stream().anyMatch(h -> h.i$(Mounter.class))) {
            frame.addSlot("tankImport", new String[]{this.packageName});
        }
        if (!this.datalake.graph().schemaList().isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        Commons.writeFrame(new File(this.gen, "datalake"), "Datalake", this.template().format((Object)frame));
    }

    private Frame[] tanks() {
        ArrayList frames = new ArrayList();
        frames.addAll(this.eventFeederSources.stream().map(this::frameOf).collect(Collectors.toList()));
        frames.addAll(this.eventSources.stream().map(this::frameOf).collect(Collectors.toList()));
        return frames.toArray(new Frame[0]);
    }

    private Frame frameOf(EventSource source) {
        String messageType = this.composedName(source);
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tank", ((Object)((Object)source)).getClass().getSimpleName().toLowerCase()}).addSlot("messageType", new String[]{messageType}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{this.fullName(source)});
        if (source.i$(Procedure.Process.Input.class)) {
            frame.addSlot("handler", (AbstractFrame[])this.handlers(messageType));
        }
        this.type(source, frame);
        return frame;
    }

    private Frame[] handlers(String name) {
        List inputs = this.graph.core$().find(Procedure.Process.Input.class).stream().filter(s -> this.composedName((EventSource)((Object)s)).equals(name)).collect(Collectors.toList());
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (Procedure.Process.Input input : inputs) {
            Frame frame = new Frame(new String[]{"handler"}).addSlot("box", new String[]{this.boxName}).addSlot("processPackage", new String[]{input.i$(Procedure.Process.Input.class) ? this.packageName + ".procedures." + ((Procedure)input.core$().ownerAs(Procedure.class)).name$() : ""}).addSlot("output", (String[])((Procedure.Process)input.core$().ownerAs(Procedure.Process.class)).outputList().stream().map(this::fullName).toArray(String[]::new)).addSlot("processName", new String[]{input.i$(Procedure.Process.Input.class) ? ((Procedure.Process)input.core$().ownerAs(Procedure.Process.class)).name$() : ""});
            this.type(input, frame);
            frames.add(frame);
        }
        return frames.toArray(new Frame[0]);
    }

    private void type(EventSource source, Frame frame) {
        if (source.schema() != null) {
            frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{source.schema().name$()})});
        } else {
            frame.addSlot("type", new String[]{"message"});
        }
    }

    private Frame frameOf(FeederEventSource source) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tank"}).addSlot("messageType", new String[]{source.composedName()}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{source.fullName()});
        frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{source.name})});
        return frame;
    }

    private String fullName(EventSource source) {
        return this.domain() + this.subdomain(source) + source.name();
    }

    private String domain() {
        return this.datalake.domain().isEmpty() ? "" : this.datalake.domain() + ".";
    }

    private String composedName(EventSource source) {
        return Commons.firstUpperCase((source.subdomain().isEmpty() ? "" : Formatters.snakeCaseToCamelCase().format((Object)source.subdomain().replace(".", "_"))) + Commons.firstUpperCase(source.name()));
    }

    private String subdomain(EventSource source) {
        return source.subdomain().isEmpty() ? "" : source.subdomain() + ".";
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private Template template() {
        return Formatters.customize(DatalakeTemplate.create()).add("shortPath", value -> {
            String[] names = value.toString().split("\\.");
            return names[names.length - 1];
        });
    }

    private String fullName(Procedure.Process.Output output) {
        String domain = ((Procedure)output.core$().ownerAs(Procedure.class)).ness().domain();
        String subdomain = output.subdomain();
        return (domain.isEmpty() ? "" : domain + ".") + (subdomain.isEmpty() ? "" : subdomain + ".") + output.name();
    }

    private Set<FeederEventSource> collectNewFeederSources(List<Feeder> feeders) {
        TreeSet<FeederEventSource> sources = new TreeSet<FeederEventSource>((o1, o2) -> this.compare((FeederEventSource)o1, (FeederEventSource)o2));
        feeders.forEach(feeder -> {
            String domain = ((NessClient)feeder.core$().ownerAs(NessClient.class)).domain();
            for (Schema schema : feeder.eventTypes()) {
                FeederEventSource e = new FeederEventSource(domain, feeder.subdomain(), schema.name$());
                if (this.isInEventSources(e)) continue;
                sources.add(e);
            }
        });
        return sources;
    }

    private boolean isInEventSources(FeederEventSource source) {
        return this.eventSources.stream().anyMatch(eventSource -> this.fullName((EventSource)((Object)eventSource)).equals(source.fullName()));
    }

    private int compare(EventSource o1, EventSource o2) {
        return this.fullName(o1).toLowerCase().compareTo(this.fullName(o2).toLowerCase());
    }

    private int compare(FeederEventSource o1, FeederEventSource o2) {
        return o1.fullName().toLowerCase().compareTo(o2.fullName().toLowerCase());
    }

    private Set<EventSource> collectEventSources(KonosGraph graph) {
        TreeSet<EventSource> events = new TreeSet<EventSource>((o1, o2) -> this.compare((EventSource)((Object)o1), (EventSource)((Object)o2)));
        List c = graph.core$().find(EventSource.class);
        c.sort(this.inputFirst());
        events.addAll(c);
        return events;
    }

    private Comparator<? super EventSource> inputFirst() {
        return (o1, o2) -> {
            if (o1.i$(Procedure.Process.Input.class) && !o2.i$(Procedure.Process.Input.class)) {
                return -1;
            }
            if (o2.i$(Procedure.Process.Input.class) && !o1.i$(Procedure.Process.Input.class)) {
                return 1;
            }
            return 0;
        };
    }

    private static class FeederEventSource {
        String domain;
        String subdomain;
        String name;

        public FeederEventSource(String domain, String subdomain, String name) {
            this.domain = domain;
            this.subdomain = subdomain;
            this.name = name;
        }

        private String fullName() {
            return (this.domain.isEmpty() ? "" : this.domain + ".") + (this.subdomain.isEmpty() ? "" : this.subdomain + ".") + this.name;
        }

        private String composedName() {
            return Commons.firstUpperCase((this.subdomain.isEmpty() ? "" : Formatters.snakeCaseToCamelCase().format((Object)this.subdomain.replace(".", "_"))) + Commons.firstUpperCase(this.name));
        }
    }
}

