/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.BoxConfigurationTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.Frame;

public class BoxConfigurationRenderer {
    private final KonosGraph graph;
    private final File gen;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;
    private String parent;
    private boolean isTara;

    public BoxConfigurationRenderer(KonosGraph graph, File gen, String packageName, Module module, String parent, boolean isTara) {
        this.graph = graph;
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.isTara = isTara;
    }

    public Frame execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"boxconfiguration"});
        String boxName = this.fillFrame(frame);
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)boxName) + "Configuration", this.template().format((Object)frame));
        return frame;
    }

    private String fillFrame(Frame frame) {
        String boxName = this.name();
        frame.addSlot("name", new String[]{boxName});
        frame.addSlot("package", new String[]{this.packageName});
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            frame.addSlot("parent", new String[]{this.parent});
        }
        if (this.isTara) {
            frame.addSlot("tara", new String[]{""});
        }
        return boxName;
    }

    private String name() {
        if (this.module != null) {
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            String dsl = configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private Template template() {
        return Formatters.customize(BoxConfigurationTemplate.create());
    }
}

