/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Sensor;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Feeder
extends Layer
implements Component,
Terminal {
    protected List<Schema> eventTypes = new ArrayList<Schema>();
    protected String subdomain;
    protected List<Sensor> sensorList = new ArrayList<Sensor>();

    public Feeder(Node node) {
        super(node);
    }

    public List<Schema> eventTypes() {
        return this.eventTypes;
    }

    public Schema eventTypes(int index) {
        return this.eventTypes.get(index);
    }

    public List<Schema> eventTypes(Predicate<Schema> predicate) {
        return this.eventTypes().stream().filter(predicate).collect(Collectors.toList());
    }

    public String subdomain() {
        return this.subdomain;
    }

    public Feeder subdomain(String value) {
        this.subdomain = value;
        return this;
    }

    public List<Sensor> sensorList() {
        return Collections.unmodifiableList(this.sensorList);
    }

    public Sensor sensor(int index) {
        return this.sensorList.get(index);
    }

    public List<Sensor> sensorList(Predicate<Sensor> predicate) {
        return this.sensorList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Sensor>(this.sensorList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("eventTypes", this.eventTypes);
        map.put("subdomain", new ArrayList<String>(Collections.singletonList(this.subdomain)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Sensor")) {
            this.sensorList.add((Sensor)node.as(Sensor.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Sensor")) {
            this.sensorList.remove(node.as(Sensor.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("eventTypes")) {
            this.eventTypes = NodeLoader.load(values, Schema.class, (Layer)this);
        } else if (name.equalsIgnoreCase("subdomain")) {
            this.subdomain = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("eventTypes")) {
            this.eventTypes = values.stream().map(s -> (Schema)this.graph().core$().load(((Layer)s).core$().id()).as(Schema.class)).collect(Collectors.toList());
        } else if (name.equalsIgnoreCase("subdomain")) {
            this.subdomain = (String)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear {
        public void sensor(Predicate<Sensor> filter) {
            new ArrayList<Sensor>(Feeder.this.sensorList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Sensor sensor() {
            Sensor newElement = (Sensor)Feeder.this.core$().graph().concept(Sensor.class).createNode(this.name, Feeder.this.core$()).as(Sensor.class);
            return newElement;
        }
    }
}

