/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake.mounter;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.mounter.MounterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mounter;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class MounterRenderer {
    private final List<Mounter> mounters;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public MounterRenderer(KonosGraph graph, File src, String packageName, String boxName, Map<String, String> classes) {
        this.mounters = graph.nessClient(0).mounterList();
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        for (Mounter mounter : this.mounters) {
            String name = this.composedName(mounter);
            Frame frame = new Frame(new String[0]).addTypes(new String[]{"mounter"}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name});
            if (mounter.schema() != null) {
                frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
                frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{mounter.schema().name$()})});
            } else {
                frame.addSlot("type", new String[]{"message"});
            }
            File destination = new File(this.src, "datalake/mounters");
            String handlerName = name + "Mounter";
            this.classes.put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "datalake.mounters." + handlerName);
            if (this.alreadyRendered(destination, handlerName)) continue;
            Commons.writeFrame(destination, handlerName, Formatters.customize(MounterTemplate.create()).format((Object)frame));
        }
    }

    private String composedName(Mounter mounter) {
        return Commons.firstUpperCase((mounter.subdomain().isEmpty() ? "" : Formatters.snakeCaseToCamelCase().format((Object)mounter.subdomain().replace(".", "_"))) + Commons.firstUpperCase(mounter.name()));
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

