/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui.mold;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.ui.UIService;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class MoldFrameBuilder
extends Frame {
    private final UIService service;
    private final Mold mold;
    private final Frame moldFrame;

    public MoldFrameBuilder(UIService service, Mold mold) {
        super(new String[0]);
        this.service = service;
        this.mold = mold;
        this.moldFrame = new Frame(new String[0]).addTypes(new String[]{"mold"}).addSlot("name", new String[]{mold.name$()});
    }

    public Frame build() {
        this.moldFrame.addSlot("block", (AbstractFrame[])this.mold.blockList().stream().filter(b -> !b.mode().equals((Object)Mold.Block.Mode.Expanded)).map(this::frameOf).toArray(Frame[]::new));
        List expandedBlocks = this.mold.blockList().stream().filter(b -> b.mode().equals((Object)Mold.Block.Mode.Expanded)).collect(Collectors.toList());
        if (!expandedBlocks.isEmpty()) {
            Frame expanded = new Frame(new String[0]).addTypes(new String[]{"expandedBlocks"});
            expanded.addSlot("block", (AbstractFrame[])expandedBlocks.stream().map(this::frameOf).toArray(Frame[]::new));
            this.moldFrame.addSlot("expandedBlocks", new AbstractFrame[]{expanded});
        }
        return this.moldFrame;
    }

    private Frame frameOf(Mold.Block block) {
        Frame frame = new Frame(new String[]{"block"}).addSlot("name", new Object[]{Formatters.validMoldName().format((Object)block.name$())}).addSlot("layout", (String[])block.layout().stream().map(Enum::name).toArray(String[]::new));
        if (block.hasCustomClass()) {
            frame.addTypes(new String[]{"hasCustomClass"});
        }
        if (this.isExpanded(block)) {
            frame.addSlot("expanded", new Boolean[]{true});
        }
        if (block.hiddenIfMobile()) {
            frame.addSlot("hiddenIfMobile", new Boolean[]{block.hiddenIfMobile()});
        }
        if (!block.style().isEmpty()) {
            frame.addSlot("style", new String[]{block.style()});
        }
        if (block.height() >= 0) {
            frame.addSlot("height", new Integer[]{block.height()});
        }
        if (block.width() >= 0) {
            frame.addSlot("width", new Integer[]{block.width()});
        }
        for (Mold.Block.Stamp stamp : block.stampList()) {
            frame.addSlot("stamp", new AbstractFrame[]{this.baseFrameOf(stamp)});
            this.moldFrame.addSlot("stamp", new AbstractFrame[]{this.frameOf(stamp, this.isExpanded(block))});
        }
        for (Mold.Block inner : block.blockList()) {
            frame.addSlot("block", new AbstractFrame[]{this.frameOf(inner)});
        }
        return frame;
    }

    private boolean isExpanded(Mold.Block block) {
        Mold.Block currentBlock = block;
        while (currentBlock != null && !currentBlock.mode().equals((Object)Mold.Block.Mode.Expanded)) {
            currentBlock = currentBlock.core$().owner().is(Mold.Block.class) ? (Mold.Block)currentBlock.core$().ownerAs(Mold.Block.class) : null;
        }
        return currentBlock != null;
    }

    private Frame frameOf(Mold.Block.Stamp stamp, boolean expanded) {
        Frame frame = this.baseFrameOf(stamp);
        ArrayList<Frame> attributeList = new ArrayList<Frame>();
        ArrayList<Frame> propertyList = new ArrayList<Frame>();
        this.addAttributes(attributeList, stamp, expanded);
        this.addCommonProperties(propertyList, stamp);
        this.addCustomProperties(propertyList, stamp);
        frame.addSlot("attribute", (AbstractFrame[])attributeList.toArray(new Frame[0]));
        frame.addSlot("property", (AbstractFrame[])propertyList.toArray(new Frame[0]));
        return frame;
    }

    private void addAttributes(List<Frame> attributeList, Mold.Block.Stamp stamp, boolean expanded) {
        if (!stamp.label().isEmpty()) {
            attributeList.add(this.frameOf("label", stamp.label()));
        }
        if (stamp.editable()) {
            attributeList.add(this.frameOf("editable", stamp.editable(), "boolean"));
        }
        if (stamp.layout() != null) {
            attributeList.add(this.frameOf("layout", stamp.layout().toString()));
        }
        if (stamp.height() != -1) {
            attributeList.add(this.frameOf("height", stamp.height(), "number"));
        }
        if (stamp.i$(Mold.Block.OpenCatalogOperation.class)) {
            attributeList.add(this.frameOf("width", ((Mold.Block.OpenCatalogOperation)stamp.a$(Mold.Block.OpenCatalogOperation.class)).width(), "number"));
        }
        if (stamp.i$(Mold.Block.OpenDialogOperation.class)) {
            attributeList.add(this.frameOf("width", ((Mold.Block.OpenDialogOperation)stamp.a$(Mold.Block.OpenDialogOperation.class)).width(), "number"));
        }
        if (stamp.i$(Mold.Block.OpenExternalDialogOperation.class)) {
            attributeList.add(this.frameOf("width", ((Mold.Block.OpenExternalDialogOperation)stamp.a$(Mold.Block.OpenExternalDialogOperation.class)).width(), "number"));
        }
        if (expanded) {
            attributeList.add(this.frameOf("expanded", true, "boolean"));
        }
    }

    private void addCommonProperties(List<Frame> propertyList, Mold.Block.Stamp stamp) {
        if (stamp.suffix() != null && !stamp.suffix().isEmpty()) {
            propertyList.add(this.frameOf("suffix", stamp.suffix()));
        }
        if (stamp.defaultStyle() != null && !stamp.defaultStyle().isEmpty()) {
            propertyList.add(this.frameOf("defaultStyle", stamp.defaultStyle()));
        }
    }

    private void addCustomProperties(List<Frame> propertyList, Mold.Block.Stamp stamp) {
        String confirmText;
        Mold.Block.Operation operation;
        if (stamp.i$(Mold.Block.Icon.class)) {
            propertyList.add(this.frameOf("iconType", ((Mold.Block.Icon)stamp.a$(Mold.Block.Icon.class)).source() == Mold.Block.Icon.Source.Polymer ? "alexandria" : ""));
        }
        if (stamp.i$(Mold.Block.Rating.class)) {
            Mold.Block.Rating rating = (Mold.Block.Rating)stamp.a$(Mold.Block.Rating.class);
            propertyList.add(this.frameOf("icon", rating.polymerIcon()));
            propertyList.add(this.frameOf("max", rating.max(), "number"));
        }
        if (stamp.i$(Mold.Block.EmbeddedDisplay.class)) {
            propertyList.add(this.frameOf("displayType", ((Mold.Block.EmbeddedDisplay)stamp.a$(Mold.Block.EmbeddedDisplay.class)).display().name$()));
        }
        if (stamp.i$(Mold.Block.EmbeddedDialog.class)) {
            propertyList.add(this.frameOf("dialogType", ((Mold.Block.EmbeddedDialog)stamp.a$(Mold.Block.EmbeddedDialog.class)).dialog().name$()));
        }
        if (stamp.i$(Mold.Block.EmbeddedCatalog.class)) {
            propertyList.add(this.frameOf("catalog", ((Mold.Block.EmbeddedCatalog)stamp.a$(Mold.Block.EmbeddedCatalog.class)).catalog().name$()));
        }
        if (stamp.i$(Mold.Block.Operation.class)) {
            operation = (Mold.Block.Operation)stamp.a$(Mold.Block.Operation.class);
            if (operation.alexandriaIcon() != null) {
                propertyList.add(this.frameOf("alexandriaIcon", operation.alexandriaIcon()));
            }
            propertyList.add(this.frameOf("mode", operation.mode().toString()));
        }
        if (stamp.i$(Mold.Block.OpenCatalogOperation.class)) {
            operation = (Mold.Block.OpenCatalogOperation)stamp.a$(Mold.Block.OpenCatalogOperation.class);
            if (((Mold.Block.OpenCatalogOperation)operation).position() != null) {
                propertyList.add(this.frameOf("position", ((Mold.Block.OpenCatalogOperation)operation).position().toString()));
            }
            if (((Mold.Block.OpenCatalogOperation)operation).selection() != null) {
                propertyList.add(this.frameOf("selection", ((Mold.Block.OpenCatalogOperation)operation).selection().toString()));
            }
            if (((Mold.Block.OpenCatalogOperation)operation).catalog() != null) {
                propertyList.add(this.frameOf("catalog", ((Mold.Block.OpenCatalogOperation)operation).catalog().name$()));
            }
        }
        if (stamp.i$(Mold.Block.DownloadOperation.class)) {
            propertyList.add(this.frameOf("options", String.join((CharSequence)",", ((Mold.Block.DownloadOperation)stamp.a$(Mold.Block.DownloadOperation.class)).options())));
        }
        if (stamp.i$(Mold.Block.ExportOperation.class)) {
            Mold.Block.ExportOperation exportOperation = (Mold.Block.ExportOperation)stamp.a$(Mold.Block.ExportOperation.class);
            Instant defaultTo = Instant.now(Clock.systemUTC()).plus(1L, ChronoUnit.DAYS);
            propertyList.add(this.frameOf("options", String.join((CharSequence)",", exportOperation.options())));
            propertyList.add(this.frameOf("from", exportOperation.from() != null ? exportOperation.from().toEpochMilli() : Instant.now().toEpochMilli(), "number"));
            propertyList.add(this.frameOf("to", exportOperation.to() != null ? exportOperation.to().toEpochMilli() : defaultTo.toEpochMilli(), "number"));
        }
        if (stamp.i$(Mold.Block.TaskOperation.class) && (confirmText = ((Mold.Block.TaskOperation)stamp.a$(Mold.Block.TaskOperation.class)).confirmText()) != null && !confirmText.isEmpty()) {
            propertyList.add(this.frameOf("confirm", ((Mold.Block.TaskOperation)stamp.a$(Mold.Block.TaskOperation.class)).confirmText()));
        }
        if (stamp.i$(Mold.Block.Map.class)) {
            propertyList.add(this.frameOf("zoom", ((Mold.Block.Map)stamp.a$(Mold.Block.Map.class)).zoom(), "number"));
            propertyList.add(this.frameOf("latitude", ((Mold.Block.Map)stamp.a$(Mold.Block.Map.class)).latitude(), "number"));
            propertyList.add(this.frameOf("longitude", ((Mold.Block.Map)stamp.a$(Mold.Block.Map.class)).longitude(), "number"));
        }
    }

    private Frame frameOf(String name, Object value) {
        return this.frameOf(name, value, "string");
    }

    private Frame frameOf(String name, Object value, String type) {
        return new Frame(new String[0]).addTypes(new String[]{type}).addSlot("name", new String[]{name}).addSlot("value", new Object[]{value});
    }

    private Frame baseFrameOf(Mold.Block.Stamp stamp) {
        Frame result = new Frame(new String[0]).addTypes(new String[]{"stamp"});
        if (stamp.hasCustomClass()) {
            result.addTypes(new String[]{"hasCustomClass"});
        }
        result.addSlot("name", new Object[]{Formatters.validMoldName().format((Object)stamp.name$())}).addSlot("type", new Object[]{Formatters.camelCaseToSnakeCase().format((Object)((Object)((Object)stamp)).getClass().getSimpleName())});
        return result;
    }
}

