/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.desktop;

import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.Toolbar;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class DesktopPanel
extends Layer
implements Terminal {
    protected Layout layout;
    protected String title;
    protected String subTitle;
    protected String logoPath;
    protected String faviconPath;
    protected boolean hasCustomColor;
    protected Panel _panel;

    public DesktopPanel(Node node) {
        super(node);
    }

    public Layout layout() {
        return this.layout;
    }

    public String title() {
        return this.title;
    }

    public String subTitle() {
        return this.subTitle;
    }

    public String logoPath() {
        return this.logoPath;
    }

    public String faviconPath() {
        return this.faviconPath;
    }

    public boolean hasCustomColor() {
        return this.hasCustomColor;
    }

    public DesktopPanel layout(Layout value) {
        this.layout = value;
        return this;
    }

    public DesktopPanel title(String value) {
        this.title = value;
        return this;
    }

    public DesktopPanel subTitle(String value) {
        this.subTitle = value;
        return this;
    }

    public DesktopPanel logoPath(String value) {
        this.logoPath = value;
        return this;
    }

    public DesktopPanel faviconPath(String value) {
        this.faviconPath = value;
        return this;
    }

    public DesktopPanel hasCustomColor(boolean value) {
        this.hasCustomColor = value;
        return this;
    }

    public Toolbar toolbar() {
        return this._panel.toolbar();
    }

    public Panel.Views views() {
        return this._panel.views();
    }

    public List<Display.Request> requestList() {
        return this._panel.requestList();
    }

    public Display.Request requestList(int index) {
        return this._panel.requestList().get(index);
    }

    public List<Display.Notification> notificationList() {
        return this._panel.notificationList();
    }

    public Display.Notification notificationList(int index) {
        return this._panel.notificationList().get(index);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("layout", new ArrayList<Layout>(Collections.singletonList(this.layout)));
        map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
        map.put("subTitle", new ArrayList<String>(Collections.singletonList(this.subTitle)));
        map.put("logoPath", new ArrayList<String>(Collections.singletonList(this.logoPath)));
        map.put("faviconPath", new ArrayList<String>(Collections.singletonList(this.faviconPath)));
        map.put("hasCustomColor", new ArrayList<Boolean>(Collections.singletonList(this.hasCustomColor)));
        return map;
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("layout")) {
            this.layout = (Layout)((Object)WordLoader.load(values, Layout.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("title")) {
            this.title = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("subTitle")) {
            this.subTitle = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("logoPath")) {
            this.logoPath = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("faviconPath")) {
            this.faviconPath = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("hasCustomColor")) {
            this.hasCustomColor = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("layout")) {
            this.layout = (Layout)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("title")) {
            this.title = (String)values.get(0);
        } else if (name.equalsIgnoreCase("subTitle")) {
            this.subTitle = (String)values.get(0);
        } else if (name.equalsIgnoreCase("logoPath")) {
            this.logoPath = (String)values.get(0);
        } else if (name.equalsIgnoreCase("faviconPath")) {
            this.faviconPath = (String)values.get(0);
        } else if (name.equalsIgnoreCase("hasCustomColor")) {
            this.hasCustomColor = (Boolean)values.get(0);
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Panel) {
            this._panel = (Panel)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear {
        public void request(Predicate<Display.Request> filter) {
            new ArrayList<Display.Request>(DesktopPanel.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void notification(Predicate<Display.Notification> filter) {
            new ArrayList<Display.Notification>(DesktopPanel.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Toolbar toolbar() {
            Toolbar newElement = (Toolbar)DesktopPanel.this.core$().graph().concept(Toolbar.class).createNode(this.name, DesktopPanel.this.core$()).as(Toolbar.class);
            return newElement;
        }

        public Panel.Views views() {
            Panel.Views newElement = (Panel.Views)DesktopPanel.this.core$().graph().concept(Panel.Views.class).createNode(this.name, DesktopPanel.this.core$()).as(Panel.Views.class);
            return newElement;
        }

        public Display.Request request() {
            Display.Request newElement = (Display.Request)DesktopPanel.this.core$().graph().concept(Display.Request.class).createNode(this.name, DesktopPanel.this.core$()).as(Display.Request.class);
            return newElement;
        }

        public Display.Notification notification() {
            Display.Notification newElement = (Display.Notification)DesktopPanel.this.core$().graph().concept(Display.Notification.class).createNode(this.name, DesktopPanel.this.core$()).as(Display.Notification.class);
            return newElement;
        }
    }

    public static enum Layout {
        Menu,
        Tab;

    }
}

