/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.task;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.task.TaskerTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Task;
import io.intino.konos.model.graph.boottrigger.BootTriggerTask;
import io.intino.konos.model.graph.crontrigger.CronTriggerTask;
import io.intino.konos.model.graph.directorysentinel.DirectorySentinelTask;
import io.intino.konos.model.graph.scheduled.ScheduledTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class TaskerRenderer {
    private final List<Task> tasks;
    private final File gen;
    private final String packageName;
    private final String boxName;

    public TaskerRenderer(KonosGraph graph, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.tasks = graph.taskList();
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        if (this.tasks.isEmpty()) {
            return;
        }
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tasker"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("task", (AbstractFrame[])this.processTasks(this.tasks));
        Commons.writeFrame(this.gen, "Tasks", this.template().format((Object)frame));
    }

    private Frame[] processTasks(List<Task> tasks) {
        ArrayList list = new ArrayList();
        list.addAll(tasks.stream().filter(t -> t.i$(ScheduledTask.class)).map(t -> (ScheduledTask)t.a$(ScheduledTask.class)).map(this::processTask).collect(Collectors.toList()));
        list.addAll(tasks.stream().filter(t -> t.i$(DirectorySentinelTask.class)).map(t -> (DirectorySentinelTask)t.a$(DirectorySentinelTask.class)).map(this::processDirectorySentinel).collect(Collectors.toList()));
        return list.toArray(new Frame[0]);
    }

    private Frame processTask(ScheduledTask task) {
        Frame jobFrame;
        Frame schedule = new Frame(new String[0]).addTypes(new String[]{"task"}).addTypes(new String[]{((Object)((Object)task)).getClass().getSimpleName()}).addSlot("name", new String[]{task.name$()});
        ArrayList<Frame> jobFrames = new ArrayList<Frame>();
        if (task.i$(CronTriggerTask.class)) {
            jobFrame = new Frame(new String[0]).addTypes(new String[]{"job"}).addTypes(new String[]{"Cron" + ((Object)((Object)task)).getClass().getSimpleName()}).addSlot("name", new String[]{task.core$().id()});
            CronTriggerTask cron = (CronTriggerTask)task.a$(CronTriggerTask.class);
            jobFrame.addTypes(new String[]{"cronTrigger"}).addSlot("pattern", new String[]{cron.pattern()}).addSlot("mean", new String[]{cron.mean()});
            if (cron.timeZone() != null) {
                jobFrame.addSlot("timeZone", new String[]{cron.timeZone()});
            }
            jobFrames.add(jobFrame);
        }
        if (task.i$(BootTriggerTask.class)) {
            jobFrame = new Frame(new String[0]).addTypes(new String[]{"job"}).addTypes(new String[]{"Boot" + ((Object)((Object)task)).getClass().getSimpleName()}).addSlot("name", new String[]{task.core$().id()});
            jobFrame.addTypes(new String[]{"onBootTrigger"});
            jobFrames.add(jobFrame);
        }
        schedule.addSlot("job", (AbstractFrame[])jobFrames.toArray(new Frame[0]));
        return schedule;
    }

    private Frame processDirectorySentinel(DirectorySentinelTask task) {
        Frame sentinel = new Frame(new String[0]).addTypes(new String[]{"task"}).addTypes(new String[]{((Object)((Object)task)).getClass().getSimpleName()});
        sentinel.addSlot("event", (String[])task.events().stream().map(Enum::name).toArray(String[]::new));
        sentinel.addSlot("file", new String[]{task.directory() == null ? "" : task.directory()});
        sentinel.addSlot("name", new String[]{task.name$()});
        sentinel.addSlot("package", new String[]{this.packageName});
        return sentinel;
    }

    private Template template() {
        return Formatters.customize(TaskerTemplate.create());
    }
}

