/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplaysTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class DisplaysRenderer
extends UIRenderer {
    private final File gen;
    private final List<Display> displays;

    public DisplaysRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        super(boxName, packageName);
        this.gen = gen;
        this.displays = graph.displayList().stream().filter(d -> !((Object)d).getClass().equals(Display.class)).collect(Collectors.toList());
    }

    public void execute() {
        if (this.displays.isEmpty()) {
            return;
        }
        Frame frame = this.buildFrame();
        for (Display display : this.displays) {
            frame.addSlot("display", new AbstractFrame[]{this.displayFrame(display)});
        }
        this.write(frame);
    }

    private Frame displayFrame(Display display) {
        return new Frame(new String[]{"display"}).addSlot("name", new String[]{display.name$()}).addSlot("type", new String[]{((Object)((Object)display)).getClass().getSimpleName()});
    }

    private void write(Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)"Displays");
        Commons.writeFrame(new File(this.gen, "displays"), newDisplay, this.template().format((Object)frame));
    }

    private Template template() {
        return Formatters.customize(DisplaysTemplate.create());
    }

    @Override
    protected Frame buildFrame() {
        return super.buildFrame().addTypes(new String[]{"displays"});
    }
}

