/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.EventSource;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.ness.NessClient;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Procedure
extends Layer
implements Terminal {
    protected NessClient ness;
    protected List<Process> processList = new ArrayList<Process>();

    public Procedure(Node node) {
        super(node);
    }

    public NessClient ness() {
        return this.ness;
    }

    public Procedure ness(NessClient value) {
        this.ness = value;
        return this;
    }

    public List<Process> processList() {
        return Collections.unmodifiableList(this.processList);
    }

    public Process process(int index) {
        return this.processList.get(index);
    }

    public List<Process> processList(Predicate<Process> predicate) {
        return this.processList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Process>(this.processList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("ness", this.ness != null ? new ArrayList<NessClient>(Collections.singletonList(this.ness)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Procedure$Process")) {
            this.processList.add((Process)node.as(Process.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Procedure$Process")) {
            this.processList.remove(node.as(Process.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("ness")) {
            this.ness = (NessClient)((Object)NodeLoader.load(values, NessClient.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("ness")) {
            this.ness = values.get(0) != null ? (NessClient)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(NessClient.class) : null;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Process
    extends Layer
    implements Component,
    Terminal {
        protected Input input;
        protected List<Output> outputList = new ArrayList<Output>();

        public Process(Node node) {
            super(node);
        }

        public Input input() {
            return this.input;
        }

        public List<Output> outputList() {
            return Collections.unmodifiableList(this.outputList);
        }

        public Output output(int index) {
            return this.outputList.get(index);
        }

        public List<Output> outputList(Predicate<Output> predicate) {
            return this.outputList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Process input(Input value) {
            this.input = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.input != null) {
                components.add(this.input.core$());
            }
            new ArrayList<Output>(this.outputList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Procedure$Process$Input")) {
                this.input = (Input)node.as(Input.class);
            }
            if (node.is("Procedure$Process$Output")) {
                this.outputList.add((Output)node.as(Output.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Procedure$Process$Input")) {
                this.input = null;
            }
            if (node.is("Procedure$Process$Output")) {
                this.outputList.remove(node.as(Output.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Output
        extends EventSource
        implements Terminal {
            public Output(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Input
        extends EventSource
        implements Terminal {
            public Input(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
            public void output(Predicate<Output> filter) {
                new ArrayList<Output>(Process.this.outputList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Input input(Schema schema) {
                Input newElement = (Input)Process.this.core$().graph().concept(Input.class).createNode(this.name, Process.this.core$()).as(Input.class);
                newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
                return newElement;
            }

            public Output output(Schema schema) {
                Output newElement = (Output)Process.this.core$().graph().concept(Output.class).createNode(this.name, Process.this.core$()).as(Output.class);
                newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
                return newElement;
            }
        }
    }

    public class Clear {
        public void process(Predicate<Process> filter) {
            new ArrayList<Process>(Procedure.this.processList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Process process() {
            Process newElement = (Process)Procedure.this.core$().graph().concept(Process.class).createNode(this.name, Procedure.this.core$()).as(Process.class);
            return newElement;
        }
    }
}

