/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.github.ZipUtil;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.rest.ApiPortalConfigurationTemplate;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceTemplate;
import io.intino.konos.builder.codegeneration.swagger.SwaggerProfileGenerator;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServiceRenderer {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private final List<RESTService> services;
    @NotNull
    private final KonosGraph graph;
    private final File gen;
    private final File res;
    private String packageName;
    private final String boxName;
    private final Module module;
    private final Map<String, String> classes;

    public RESTServiceRenderer(KonosGraph graph, File gen, File res, String packageName, String boxName, Module module, Map<String, String> classes) {
        this.services = graph.rESTServiceList();
        this.graph = graph;
        this.gen = gen;
        this.res = res;
        this.packageName = packageName;
        this.boxName = boxName;
        this.module = module;
        this.classes = classes;
    }

    public void execute() {
        this.services.forEach(service -> this.processService((RESTService)service.a$(RESTService.class), this.gen));
        if (!this.services.isEmpty()) {
            this.generateApiPortal();
        }
    }

    private void generateApiPortal() {
        File api = new File(this.res, "www" + File.separator + "api");
        this.copyAssets(api);
        File data = new File(api, "data");
        data.mkdirs();
        new SwaggerProfileGenerator(this.services, data).execute();
        this.createConfigFile(api);
    }

    private void copyAssets(File www) {
        try {
            ZipUtil.unzip(null, (File)www, (ZipInputStream)new ZipInputStream(this.getClass().getResourceAsStream("/swagger/assets.zip")), null, null, (boolean)false);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void createConfigFile(File api) {
        Template template = Formatters.customize(ApiPortalConfigurationTemplate.create());
        Frame frame = new Frame(new String[]{"api"}).addSlot("url", (String[])this.services.stream().map(Layer::name$).toArray(String[]::new));
        RESTService service = this.services.get(0);
        if (service.color() != null) {
            frame.addSlot("color", new String[]{service.color()});
        }
        if (service.backgroundColor() != null) {
            frame.addSlot("background", new String[]{service.backgroundColor()});
        }
        if (service.title() != null) {
            frame.addSlot("title", new String[]{service.title()});
        }
        if (service.subtitle() != null) {
            frame.addSlot("subtitle", new String[]{service.subtitle()});
        } else {
            frame.addSlot("title", new String[]{"API Portal"});
        }
        if (service.logo() != null) {
            this.copyLogoToImages(new File(api, "images"), service.logo());
        }
        if (service.favicon() != null) {
            this.copyFaviconToImages(new File(api, "images"), service.favicon());
        }
        try {
            Files.write(new File(api, "config.json").toPath(), template.format((Object)frame).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void copyFaviconToImages(File images, String logo) {
        File resource = this.findResource(logo);
        if (resource == null) {
            return;
        }
        try {
            Files.copy(resource.toPath(), new File(images, "favicon.png").toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void copyLogoToImages(File images, String logo) {
        File resource = this.findResource(logo);
        if (resource == null) {
            return;
        }
        try {
            Files.copy(resource.toPath(), new File(images, "logo.png").toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private File findResource(String logo) {
        VirtualFile resRoot = this.getResRoot(this.module);
        if (resRoot == null) {
            return null;
        }
        File file = new File(resRoot.getPath(), logo);
        return file.exists() ? file : null;
    }

    private VirtualFile getResRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"res".equals(file.getName())) continue;
            return file;
        }
        return null;
    }

    private void processService(RESTService service, File gen) {
        RESTService.AuthenticatedWithCertificate secure;
        if (service.resourceList().isEmpty()) {
            return;
        }
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"server"}).addSlot("name", new String[]{service.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("resource", (AbstractFrame[])this.framesOf(service.resourceList()));
        if (!service.notificationList().isEmpty()) {
            frame.addSlot("notification", (AbstractFrame[])this.notificationsFrame(service.notificationList()));
            if (this.graph.uIServiceList().isEmpty()) {
                frame.addSlot("hasNotifications", (AbstractFrame[])this.notificationsFrame(service.notificationList()));
            }
        }
        if ((secure = service.authenticatedWithCertificate()) != null && secure.store() != null) {
            frame.addSlot("secure", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"secure"}).addSlot("file", new String[]{secure.store()}).addSlot("password", new String[]{secure.storePassword()})});
        }
        String className = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Resources";
        this.classes.put(((Object)((Object)service)).getClass().getSimpleName() + "#" + service.name$(), className);
        Commons.writeFrame(gen, className, this.template().format((Object)frame));
    }

    private Frame[] notificationsFrame(List<RESTService.Notification> list) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (RESTService.Notification notification : list) {
            frames.add(new Frame(new String[]{"notification"}).addSlot("path", new String[]{notification.path()}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{notification.name$()}));
        }
        return frames.toArray(new Frame[0]);
    }

    private Frame[] framesOf(List<RESTService.Resource> resources) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        for (RESTService.Resource resource : resources) {
            list.addAll(this.processResource(resource, resource.operationList()));
        }
        return list.toArray(new Frame[0]);
    }

    private List<Frame> processResource(RESTService.Resource resource, List<RESTService.Resource.Operation> operations) {
        return operations.stream().map(operation -> new Frame(new String[0]).addTypes(new String[]{"resource", ((Object)operation).getClass().getSimpleName()}).addSlot("name", new String[]{resource.name$()}).addSlot("operation", new String[]{((Object)operation).getClass().getSimpleName()}).addSlot("path", new AbstractFrame[]{Formatters.customize("path", Commons.path(resource))}).addSlot("method", new String[]{((Object)operation).getClass().getSimpleName()})).collect(Collectors.toList());
    }

    private Template template() {
        return Formatters.customize(RESTServiceTemplate.create());
    }
}

