/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jms;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.jms.JMSServiceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.jms.JMSService;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.siani.itrules.Formatter;
import org.siani.itrules.Template;
import org.siani.itrules.engine.formatters.StringFormatter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class JMSServiceRenderer {
    private final List<JMSService> services;
    private File gen;
    private String packageName;
    private final String boxName;

    public JMSServiceRenderer(KonosGraph graph, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.services = graph.jMSServiceList();
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(JMSService service) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"jms"}).addSlot("name", new String[]{service.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("model", new String[]{service.subscriptionModel().name()}).addSlot("request", (AbstractFrame[])this.processRequests(service.requestList(), service.subscriptionModel().name())).addSlot("notification", (AbstractFrame[])this.processNotifications(service.notificationList(), service.subscriptionModel().name()));
        Commons.writeFrame(this.gen, ((Formatter)StringFormatter.get().get("firstuppercase")).format((Object)service.name$()).toString() + "Service", this.template().format((Object)frame));
    }

    private Frame[] processRequests(List<JMSService.Request> requests, String subscriptionModel) {
        return (Frame[])requests.stream().map(request -> this.processRequest((JMSService.Request)((Object)request), subscriptionModel)).toArray(Frame[]::new);
    }

    private Frame processRequest(JMSService.Request request, String subscriptionModel) {
        return new Frame(new String[0]).addTypes(new String[]{"request"}).addSlot("name", new String[]{request.name$()}).addSlot("model", new String[]{subscriptionModel}).addSlot("queue", new AbstractFrame[]{Formatters.customize("queue", request.path())});
    }

    private Frame[] processNotifications(List<JMSService.Notification> notifications, String subscriptionModel) {
        return (Frame[])notifications.stream().map(notification -> this.processNotification((JMSService.Notification)((Object)notification), subscriptionModel)).toArray(Frame[]::new);
    }

    private Frame processNotification(JMSService.Notification notification, String subscriptionModel) {
        return new Frame(new String[0]).addTypes(new String[]{"notification"}).addSlot("name", new String[]{notification.name$()}).addSlot("package", new String[]{this.packageName}).addSlot("queue", new AbstractFrame[]{Formatters.customize("queue", notification.path())}).addSlot("model", new String[]{subscriptionModel}).addSlot("parameter", (AbstractFrame[])this.parameters(notification.parameterList())).addSlot("returnMessageType", new String[]{this.messageType(notification.parameterList())});
    }

    private Template template() {
        return Formatters.customize(JMSServiceTemplate.create());
    }

    private String messageType(List<Parameter> parameters) {
        return parameters.stream().filter(Parameter::isFile).count() > 0L ? "Bytes" : "Text";
    }

    private Frame[] parameters(List<Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Parameter parameter) {
        return new Frame(new String[0]).addTypes(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).addSlot("name", new String[]{parameter.name$()}).addSlot("type", new String[]{parameter.asType().type()});
    }
}

