/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import io.intino.konos.model.graph.Service;
import io.intino.plugin.IntinoIcons;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import org.jetbrains.annotations.NotNull;

public class SelectServicesDialog {
    private static final Object[] FIELDS = new Object[]{"Name", "Select"};
    private JPanel servicesPanel;
    private JBTable table;
    private Window parent;
    private final List<Service> services;

    public SelectServicesDialog(Window parent, List<Service> services) {
        this.parent = parent;
        this.services = services;
        this.createUIComponents();
    }

    List<Service> showAndGet() {
        List[] services = new List[]{new ArrayList()};
        Application application = ApplicationManager.getApplication();
        application.invokeAndWait(() -> {
            Object[] options = new String[]{"Cancel", "Accept"};
            int option = JOptionPane.showOptionDialog(this.parent, this.servicesPanel, "Select services to distribute", 1, 3, IntinoIcons.INTINO_80, options, options[1]);
            services[0] = option == 1 ? this.selectedServices() : Collections.emptyList();
        }, ModalityState.any());
        return services[0];
    }

    private List<Service> selectedServices() {
        ArrayList<Service> list = new ArrayList<Service>();
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            if (!((Boolean)this.table.getModel().getValueAt(i, 1)).booleanValue()) continue;
            list.add(this.findService(this.table.getModel().getValueAt(i, 0).toString()));
        }
        return list;
    }

    private Service findService(String value) {
        return this.services.stream().filter(service -> service.name$().equalsIgnoreCase(value)).findFirst().orElse(null);
    }

    private void createUIComponents() {
        this.servicesPanel = new JPanel();
        DefaultTableModel tableModel = new DefaultTableModel(this.servicesData(), FIELDS){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column != 0 && SelectServicesDialog.this.checkExist(this.getValueAt(row, 0).toString());
            }
        };
        tableModel.setColumnIdentifiers(FIELDS);
        this.table = this.newTable(tableModel);
        this.table.setEnableAntialiasing(true);
        this.table.getEmptyText().setText("No Services");
        this.table.setAutoResizeMode(3);
        this.table.getColumn(FIELDS[0]).setPreferredWidth(150);
        this.table.getColumn(FIELDS[1]);
        this.servicesPanel = ToolbarDecorator.createDecorator((JTable)this.table).disableUpAction().disableDownAction().createPanel();
        this.servicesPanel.setMaximumSize(new Dimension(400, 200));
        this.servicesPanel.setMinimumSize(new Dimension(400, 200));
        this.table.setMaximumSize(new Dimension(400, 200));
        this.table.setMinimumSize(new Dimension(400, 200));
        this.table.setPreferredSize(new Dimension(400, 200));
        this.servicesPanel.setPreferredSize(new Dimension(400, 200));
    }

    private boolean checkExist(String value) {
        return this.services.stream().anyMatch(service -> service.name$().equalsIgnoreCase(value));
    }

    @NotNull
    private StripeTable newTable(DefaultTableModel tableModel) {
        StripeTable stripeTable = new StripeTable(tableModel){
            private static final long serialVersionUID = 1L;

            public Class getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return String.class;
                    }
                }
                return Boolean.class;
            }
        };
        if (stripeTable == null) {
            SelectServicesDialog.$$$reportNull$$$0(0);
        }
        return stripeTable;
    }

    private Object[][] servicesData() {
        Object[][] objects = new Object[this.services.size()][3];
        for (int i = 0; i < this.services.size(); ++i) {
            objects[i] = new Object[]{this.services.get(i).name$(), false};
        }
        return objects;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/actions/SelectServicesDialog", "newTable"));
    }
}

