/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import com.intellij.platform.templates.github.ZipUtil;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.rest.RESTServiceTemplate;
import io.intino.konos.builder.codegeneration.swagger.IndexTemplate;
import io.intino.konos.builder.codegeneration.swagger.SwaggerGenerator;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.rest.RESTService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTServiceRenderer {
    private static Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private final List<RESTService> services;
    @NotNull
    private final KonosGraph graph;
    private final File gen;
    private final File res;
    private String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public RESTServiceRenderer(KonosGraph graph, File gen, File res, String packageName, String boxName, Map<String, String> classes) {
        this.services = graph.rESTServiceList();
        this.graph = graph;
        this.gen = gen;
        this.res = res;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        this.services.forEach(service -> this.processService((RESTService)service.a$(RESTService.class), this.gen));
        if (!this.services.isEmpty()) {
            this.generateDoc();
        }
    }

    private void generateDoc() {
        File www = new File(this.res, "www" + File.separator + "developer");
        new SwaggerGenerator(this.services, www).execute();
        this.createIndex(www);
        this.copyAssets(www);
    }

    private void createIndex(File www) {
        Frame doc = new Frame(new String[0]).addTypes(new String[]{"index"});
        for (RESTService service : this.services) {
            doc.addSlot("service", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"service"}).addSlot("name", new String[]{service.name$()}).addSlot("description", new String[]{service.description()})});
        }
        this.writeIndex(www, doc);
    }

    private void writeIndex(File www, Frame doc) {
        Commons.write(new File(www, "index.html").toPath(), IndexTemplate.create().format((Object)doc));
    }

    private void copyAssets(File www) {
        try {
            ZipUtil.unzip(null, (File)www, (ZipInputStream)new ZipInputStream(this.getClass().getResourceAsStream("/swagger/assets.zip")), null, null, (boolean)false);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void processService(RESTService service, File gen) {
        RESTService.AuthenticatedWithCertificate secure;
        if (service.resourceList().isEmpty()) {
            return;
        }
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"server"}).addSlot("name", new String[]{service.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("resource", (AbstractFrame[])this.framesOf(service.resourceList()));
        if (!service.notificationList().isEmpty()) {
            frame.addSlot("notification", (AbstractFrame[])this.notificationsFrame(service.notificationList()));
            if (this.graph.uIServiceList().isEmpty()) {
                frame.addSlot("hasNotifications", (AbstractFrame[])this.notificationsFrame(service.notificationList()));
            }
        }
        if ((secure = service.authenticatedWithCertificate()) != null && secure.store() != null) {
            frame.addSlot("secure", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"secure"}).addSlot("file", new String[]{secure.store()}).addSlot("password", new String[]{secure.storePassword()})});
        }
        String className = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Resources";
        this.classes.put(((Object)((Object)service)).getClass().getSimpleName() + "#" + service.name$(), className);
        Commons.writeFrame(gen, className, this.template().format((Object)frame));
    }

    private Frame[] notificationsFrame(List<RESTService.Notification> list) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (RESTService.Notification notification : list) {
            frames.add(new Frame(new String[]{"notification"}).addSlot("path", new String[]{notification.path()}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{notification.name$()}));
        }
        return frames.toArray(new Frame[0]);
    }

    private Frame[] framesOf(List<RESTService.Resource> resources) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        for (RESTService.Resource resource : resources) {
            list.addAll(this.processResource(resource, resource.operationList()));
        }
        return list.toArray(new Frame[0]);
    }

    private List<Frame> processResource(RESTService.Resource resource, List<RESTService.Resource.Operation> operations) {
        return operations.stream().map(operation -> new Frame(new String[0]).addTypes(new String[]{"resource", ((Object)operation).getClass().getSimpleName()}).addSlot("name", new String[]{resource.name$()}).addSlot("operation", new String[]{((Object)operation).getClass().getSimpleName()}).addSlot("path", new AbstractFrame[]{Formatters.customize("path", Commons.path(resource))}).addSlot("method", new String[]{((Object)operation).getClass().getSimpleName()})).collect(Collectors.toList());
    }

    private Template template() {
        return Formatters.customize(RESTServiceTemplate.create());
    }
}

