/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.slack;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.slack.BotActionsUpdater;
import io.intino.konos.builder.codegeneration.services.slack.SlackTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class SlackRenderer {
    private final Project project;
    private final List<SlackBotService> services;
    private final File src;
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public SlackRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.project = project;
        this.services = graph.slackBotServiceList();
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(SlackBotService service) {
        String srcName = StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack";
        Frame frame = this.createFrame(service.name$(), service.requestList(), true);
        for (String level : this.collectLevels(service).keySet()) {
            frame.addSlot("level", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"level"}).addSlot("name", new String[]{level})});
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "SlackBot", this.template().format((Object)frame));
        if (this.alreadyRendered(new File(this.src, "slack"), srcName)) {
            this.updateBot(service, srcName);
        } else {
            this.newBotActions(service);
        }
    }

    private void updateBot(SlackBotService service, String name) {
        new BotActionsUpdater(this.project, Commons.javaFile(new File(this.src, "slack"), name), service.requestList(), this.boxName).update();
        VirtualFileManager.getInstance().asyncRefresh(null);
    }

    private void newBotActions(SlackBotService service) {
        File directory = new File(this.src, "slack");
        if (!this.alreadyRendered(directory, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack")) {
            Commons.writeFrame(directory, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Slack", this.template().format((Object)this.createFrame(service.name$(), service.requestList(), false)));
        }
        Map<String, List<SlackBotService.Request>> groups = this.collectLevels(service);
        for (String requestContainer : groups.keySet()) {
            this.classes.put("Service#" + service.name$(), "slack." + requestContainer + "Slack");
            if (this.alreadyRendered(directory, requestContainer + "Slack")) continue;
            Commons.writeFrame(directory, requestContainer + "Slack", this.template().format((Object)this.createFrame(requestContainer, groups.get(requestContainer), false)));
        }
    }

    private Map<String, List<SlackBotService.Request>> collectLevels(SlackBotService service) {
        return this.collect(service.requestList());
    }

    private LinkedHashMap<String, List<SlackBotService.Request>> collect(List<SlackBotService.Request> requests) {
        LinkedHashMap map = requests.stream().filter(request -> !request.requestList().isEmpty()).collect(Collectors.toMap(this::name, SlackBotService.Request::requestList, (a, b) -> b, LinkedHashMap::new));
        for (SlackBotService.Request request2 : requests) {
            map.putAll(this.collect(request2.requestList()));
        }
        return map;
    }

    private String name(SlackBotService.Request request) {
        String s;
        StringBuilder name = new StringBuilder();
        SlackBotService.Request r = request;
        while (r.i$(SlackBotService.Request.class)) {
            name.insert(0, Commons.firstUpperCase(r.name$()) + "|");
            if (!r.core$().owner().is(SlackBotService.Request.class)) break;
            r = (SlackBotService.Request)r.core$().ownerAs(SlackBotService.Request.class);
        }
        return (s = name.toString()).endsWith("|") ? s.substring(0, s.length() - 1) : s;
    }

    @NotNull
    private Frame createFrame(String name, List<SlackBotService.Request> requests, boolean gen) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"slack", gen ? "gen" : "actions"});
        frame.addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name}).addSlot("box", new String[]{this.boxName});
        if (gen) {
            this.allRequests(requests, frame);
        } else {
            this.createRequests(requests, frame);
        }
        Frame frame2 = frame;
        if (frame2 == null) {
            SlackRenderer.$$$reportNull$$$0(0);
        }
        return frame2;
    }

    private void allRequests(List<SlackBotService.Request> requests, Frame frame) {
        for (SlackBotService.Request request : requests) {
            frame.addSlot("request", new AbstractFrame[]{this.createRequestFrame(request)});
            this.allRequests(request.requestList(), frame);
        }
    }

    private void createRequests(List<SlackBotService.Request> requests, Frame frame) {
        for (SlackBotService.Request request : requests) {
            frame.addSlot("request", new AbstractFrame[]{this.createRequestFrame(request)});
        }
    }

    private Frame createRequestFrame(SlackBotService.Request request) {
        Frame requestFrame = new Frame(new String[0]).addTypes(new String[]{"request"}).addSlot("type", new String[]{request.core$().owner().is(SlackBotService.Request.class) ? this.name((SlackBotService.Request)request.core$().ownerAs(SlackBotService.Request.class)) : request.core$().owner().name()}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{request.name$()}).addSlot("description", new String[]{request.description()});
        if (request.core$().owner().is(SlackBotService.Request.class)) {
            requestFrame.addSlot("context", new String[]{this.name((SlackBotService.Request)request.core$().ownerAs(SlackBotService.Request.class))});
        }
        requestFrame.addSlot("responseType", new String[]{request.responseType().equals((Object)SlackBotService.Request.ResponseType.Text) ? "String" : "SlackAttachment"});
        List<SlackBotService.Request.Parameter> parameters = request.parameterList();
        for (int i = 0; i < parameters.size(); ++i) {
            requestFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"parameter", parameters.get(i).type().name(), parameters.get(i).multiple() ? "multiple" : "single"}).addSlot("type", new String[]{parameters.get(i).type().name()}).addSlot("name", new String[]{parameters.get(i).name$()}).addSlot("pos", new Integer[]{i})});
        }
        for (SlackBotService.Request component : request.requestList()) {
            requestFrame.addSlot("component", new String[]{component.name$()});
        }
        return requestFrame;
    }

    private Template template() {
        return Formatters.customize(SlackTemplate.create()).add("slashToCamelCase", o -> StringHelper.snakeCaseToCamelCase((String)o.toString().replace("|", "_")));
    }

    private boolean alreadyRendered(File destiny, String name) {
        return Commons.javaFile(destiny, name).exists();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/slack/SlackRenderer", "createFrame"));
    }
}

