/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake.process;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.process.ProcessTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Procedure;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ProcessRenderer {
    private final List<Procedure.Process> processes;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public ProcessRenderer(KonosGraph graph, File src, String packageName, String boxName, Map<String, String> classes) {
        this.processes = this.processes(graph);
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        for (Procedure.Process process : this.processes) {
            String procedure = ((Procedure)process.core$().ownerAs(Procedure.class)).name$();
            String name = this.composedName(process);
            Frame frame = new Frame(new String[0]).addTypes(new String[]{"process"}).addSlot("box", new String[]{this.boxName}).addSlot("procedure", new String[]{procedure}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name});
            if (process.input().schema() != null) {
                frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
                frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{process.input().schema().name$()})});
            } else {
                frame.addSlot("type", new String[]{"message"});
            }
            File destination = new File(this.src, "procedures" + File.separator + procedure.toLowerCase());
            String handlerName = Commons.firstUpperCase(name) + "Process";
            this.classes.put(((Object)((Object)process)).getClass().getSimpleName() + "#" + process.name$(), "ness.procedures." + procedure.toLowerCase() + "." + handlerName);
            if (this.alreadyRendered(destination, handlerName)) continue;
            Commons.writeFrame(destination, handlerName, Formatters.customize(ProcessTemplate.create()).format((Object)frame));
        }
    }

    private String composedName(Procedure.Process process) {
        return Commons.firstUpperCase((process.input().subdomain().isEmpty() ? "" : Formatters.snakeCaseToCamelCase().format((Object)process.input().subdomain().replace(".", "_"))) + Commons.firstUpperCase(process.name$()));
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }

    private List<Procedure.Process> processes(KonosGraph graph) {
        if (graph == null) {
            return Collections.emptyList();
        }
        return graph.procedureList().stream().map(Procedure::processList).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

