/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.ui.UIResourcesTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class UIResourcesRenderer {
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final List<UIService> uiServiceList;

    public UIResourcesRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.uiServiceList = graph.uIServiceList();
    }

    public void execute() {
        this.uiServiceList.forEach(this::processUIService);
    }

    private void processUIService(UIService service) {
        List<Dialog> dialogs = KonosGraph.dialogsOf(service);
        List<Display> displays = KonosGraph.displaysOf(service);
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"ui"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{service.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("resource", (AbstractFrame[])this.resourcesFrame(service.resourceList()));
        if (service.userHome() != null) {
            frame.addSlot("userHome", new String[]{service.userHome().name$()});
        }
        if (!dialogs.isEmpty()) {
            frame.addSlot("dialog", (AbstractFrame[])this.dialogsFrame(dialogs)).addSlot("dialogsImport", new String[]{this.packageName});
        }
        if (!displays.isEmpty()) {
            frame.addSlot("display", (AbstractFrame[])this.displaysFrame(displays)).addSlot("displaysImport", new String[]{this.packageName});
        }
        if (service.authentication() != null) {
            frame.addSlot("auth", new String[]{service.authentication().by()});
        }
        Commons.writeFrame(this.gen, StringHelper.snakeCaseToCamelCase((String)service.name$()), this.template().format((Object)frame));
    }

    private Frame[] resourcesFrame(List<AbstractUIService.Resource> resourceList) {
        return (Frame[])resourceList.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame[] displaysFrame(List<Display> displays) {
        return (Frame[])displays.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame[] dialogsFrame(List<Dialog> dialogs) {
        return (Frame[])dialogs.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(AbstractUIService.Resource resource) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"resource", "abstractResource"});
        frame.addSlot("name", new String[]{resource.name$()});
        UIService service = (UIService)resource.core$().ownerAs(UIService.class);
        String path = resource.path();
        Set<String> custom = Commons.extractParameters(path);
        Frame pathFrame = new Frame(new String[]{"path"}).addSlot("value", new String[]{path}).addSlot("name", new String[]{resource.name$()});
        if (resource.isEditorPage()) {
            pathFrame.addTypes(new String[]{"editor"});
        }
        if (service.userHome() != null) {
            pathFrame.addSlot("userHome", new String[]{service.userHome().name$()});
        }
        if (!custom.isEmpty()) {
            pathFrame.addSlot("custom", custom.toArray(new String[0]));
        }
        frame.addSlot("path", new AbstractFrame[]{pathFrame});
        return frame;
    }

    private Frame frameOf(Display display) {
        Frame frame = this.newDisplayFrame(display, new Frame(new String[]{"display"}));
        if (display.isAccessible()) {
            frame.addTypes(new String[]{"accessible"}).addSlot("display", new AbstractFrame[]{this.newDisplayFrame(display, new Frame(new String[]{"display", "proxy"}))});
        }
        return frame;
    }

    private Frame newDisplayFrame(Display display, Frame frame) {
        frame.addSlot("name", new String[]{display.name$()}).addSlot("package", new String[]{this.packageName});
        if (display.requestList().stream().anyMatch(r -> r.responseType().equals((Object)Display.Request.ResponseType.Asset))) {
            frame.addSlot("asset", new String[]{display.name$()});
        }
        return frame;
    }

    private Frame frameOf(Dialog dialog) {
        return new Frame(new String[0]).addTypes(new String[]{"dialog"}).addSlot("name", new String[]{dialog.name$()}).addSlot("package", new String[]{this.packageName});
    }

    private Template template() {
        Template template = UIResourcesTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }
}

