/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.ActionTemplate;
import io.intino.konos.builder.codegeneration.action.ActionUpdater;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.type.TypeData;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

abstract class ActionRenderer {
    protected final Project project;
    protected final File destiny;
    protected String packageName;
    protected final String boxName;

    ActionRenderer(Project project, File destiny, String packageName, String boxName) {
        this.project = project;
        this.destiny = destiny;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    boolean alreadyRendered(File destiny, String action) {
        return Commons.javaFile(this.destinyPackage(destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)action)) + "Action").exists();
    }

    File destinyPackage(File destiny) {
        return new File(destiny, "actions");
    }

    protected void execute(String name, Response response, List<? extends Parameter> parameters, List<Exception> exceptions, List<Schema> schemas) {
        if (!this.alreadyRendered(this.destiny, name)) {
            this.createNewClass(name, response, parameters, exceptions, schemas);
        } else {
            File destiny = Commons.javaFile(this.destinyPackage(this.destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)name)) + "Action");
            new ActionUpdater(this.project, destiny, this.packageName, parameters, exceptions, response).update();
        }
    }

    private void createNewClass(String name, Response response, List<? extends Parameter> parameters, List<Exception> exceptions, List<Schema> schemas) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"action"});
        frame.addSlot("name", new String[]{name});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("box", new String[]{this.boxName});
        this.setupParameters(parameters, frame);
        frame.addSlot("returnType", new String[]{Commons.returnType(response, this.packageName)});
        if (!exceptions.isEmpty()) {
            frame.addSlot("throws", (String[])exceptions.stream().map(e -> e.code().name()).toArray(String[]::new));
        }
        if (!schemas.isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        Commons.writeFrame(this.destinyPackage(this.destiny), this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)name)) + "Action", this.template().format((Object)frame));
    }

    private void setupParameters(List<? extends Parameter> parameters, Frame frame) {
        for (Parameter parameter : parameters) {
            Frame parameterFrame = new Frame(new String[0]).addTypes(new String[]{"parameter", ((Object)((Object)parameter.asType())).getClass().getSimpleName()});
            if (parameter.isList()) {
                parameterFrame.addTypes(new String[]{"list"});
            }
            frame.addSlot("parameter", new AbstractFrame[]{parameterFrame.addSlot("name", new Object[]{Formatters.snakeCaseToCamelCase().format((Object)parameter.name$())}).addSlot("type", new String[]{this.formatType(parameter.asType())})});
        }
    }

    private String formatType(TypeData typeData) {
        return (typeData.i$(ObjectData.class) ? this.packageName + ".schemas." : "") + typeData.type();
    }

    protected String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    protected Template template() {
        return Formatters.customize(ActionTemplate.create());
    }
}

