/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.task;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.ActionTemplate;
import io.intino.konos.builder.codegeneration.task.TaskTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Task;
import io.intino.konos.model.graph.directorysentinel.DirectorySentinelTask;
import io.intino.konos.model.graph.scheduled.ScheduledTask;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class TaskRenderer {
    private final List<ScheduledTask> scheduledTasks;
    private final List<Task> tasks;
    private File srcDestination;
    private File genDestination;
    private String packageName;
    private final String boxName;

    public TaskRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.scheduledTasks = graph.scheduledTaskList();
        this.tasks = graph.taskList().stream().filter(t -> !t.isScheduled()).collect(Collectors.toList());
        this.srcDestination = src;
        this.genDestination = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        this.scheduledTasks.forEach(this::processTrigger);
        this.tasks.stream().filter(Task::isDirectorySentinel).forEach(this::processDirectorySentinel);
    }

    private void processDirectorySentinel(Task task) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"action"});
        frame.addSlot("name", new String[]{task.name$()});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("parameter", (AbstractFrame[])this.parameters(task.asDirectorySentinel()));
        if (!this.alreadyRendered(this.srcDestination, task)) {
            Commons.writeFrame(this.actionsPackage(this.srcDestination), task.name$() + "Action", this.actionTemplate().format((Object)frame));
        }
    }

    private Frame[] parameters(DirectorySentinelTask task) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        list.add(new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("type", new String[]{URL.class.getCanonicalName()}).addSlot("name", new String[]{"directory"}));
        list.add(new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("type", new String[]{"io.intino.konos.scheduling.directory.KonosDirectorySentinel.Event"}).addSlot("name", new String[]{"event"}));
        return list.toArray(new Frame[list.size()]);
    }

    private List<DirectorySentinelTask.Events> directoryEvents(DirectorySentinelTask task) {
        return task.events();
    }

    private void processTrigger(ScheduledTask task) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"scheduled"});
        frame.addSlot("name", new String[]{task.name$()});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("package", new String[]{this.packageName});
        Commons.writeFrame(this.destinyPackage(), task.name$() + "Task", this.template().format((Object)frame));
        this.createCorrespondingAction(task);
    }

    private void createCorrespondingAction(ScheduledTask task) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"action"});
        frame.addSlot("name", new String[]{task.name$()});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("package", new String[]{this.packageName});
        if (!this.alreadyRendered(this.srcDestination, (Task)task.a$(Task.class))) {
            Commons.writeFrame(this.actionsPackage(this.srcDestination), task.name$() + "Action", this.actionTemplate().format((Object)frame));
        }
    }

    private Template actionTemplate() {
        return Formatters.customize(ActionTemplate.create());
    }

    private Template template() {
        return Formatters.customize(TaskTemplate.create());
    }

    private boolean alreadyRendered(File destiny, Task task) {
        return Commons.javaFile(this.actionsPackage(destiny), task.name$() + "Action").exists();
    }

    private File actionsPackage(File destiny) {
        return new File(destiny, "actions");
    }

    private File destinyPackage() {
        return new File(this.genDestination, "scheduling");
    }
}

