/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.action;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.action.ActionRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class UIActionRenderer
extends ActionRenderer {
    private final AbstractUIService.Resource resource;
    private final File gen;
    private final UIService service;
    private final Map<String, String> classes;

    public UIActionRenderer(Project project, AbstractUIService.Resource resource, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        super(project, src, packageName, boxName);
        this.gen = gen;
        this.resource = resource;
        this.service = (UIService)resource.core$().ownerAs(UIService.class);
        this.classes = classes;
    }

    public void execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"action", "ui"});
        frame.addSlot("name", new String[]{this.resource.name$()});
        frame.addSlot("uiService", new String[]{((UIService)this.resource.core$().ownerAs(UIService.class)).name$()});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("type", new String[]{this.resource.isEditorPage() ? "Editor" : "Resource"});
        frame.addSlot("importDialogs", new String[]{this.packageName});
        frame.addSlot("importDisplays", new String[]{this.packageName});
        if (this.resource.isEditorPage()) {
            frame.addSlot("editor", new AbstractFrame[]{new Frame(new String[]{"editor"})});
        }
        frame.addSlot("component", new AbstractFrame[]{this.componentFrame()});
        frame.addSlot("parameter", (AbstractFrame[])this.parameters());
        this.service.useList().stream().map(use -> frame.addSlot("usedAppUrl", new AbstractFrame[]{new Frame(new String[]{"usedAppUrl", this.isCustom(use.url()) ? "custom" : "standard"}).addSlot("value", new String[]{this.isCustom(use.url()) ? this.customValue(use.url()) : use.url()})})).collect(Collectors.toList());
        if (this.service.favicon() != null) {
            frame.addSlot("favicon", new String[]{this.service.favicon()});
        } else if (this.service.title() != null) {
            frame.addSlot("title", new String[]{this.service.title()});
        }
        this.classes.put(((Object)((Object)this.resource)).getClass().getSimpleName() + "#" + this.firstUpperCase(this.resource.core$().name()), "actions." + this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)this.resource.name$())) + "Action");
        if (!this.alreadyRendered(this.destiny, this.resource.name$())) {
            Commons.writeFrame(this.destinyPackage(this.destiny), this.resource.name$() + "Action", this.template().format((Object)frame));
        }
        Commons.writeFrame(this.destinyPackage(this.gen), "Abstract" + this.firstUpperCase(this.resource.name$()) + "Action", this.template().format((Object)frame.addTypes(new String[]{"gen"})));
    }

    private Frame componentFrame() {
        Frame result = new Frame(new String[]{"component"}).addSlot("value", new String[]{KonosGraph.componentFor(this.resource).name$()});
        if (this.resource.isEditorPage()) {
            Component display = this.resource.asEditorPage().editor().display();
            result.addSlot("editor", new AbstractFrame[]{new Frame(new String[]{"editor"}).addSlot("display", new String[]{display.name$()})});
        }
        return result;
    }

    private Frame[] parameters() {
        List<String> parameters = Commons.extractUrlPathParameters(this.resource.path());
        return (Frame[])parameters.stream().map(parameter -> new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("type", new String[]{"String"}).addSlot("name", new String[]{parameter})).toArray(Frame[]::new);
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private String customValue(String value) {
        return value != null ? value.substring(1, value.length() - 1) : "";
    }
}

