/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.rest;

import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.bool.BoolData;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.datetime.DateTimeData;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.integer.IntegerData;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.longinteger.LongIntegerData;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.real.RealData;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.konos.model.graph.text.TextData;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.konos.model.graph.word.WordData;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class RESTService
extends Layer
implements Terminal {
    protected String swagger;
    protected String host;
    protected String port;
    protected String description;
    protected String basePath;
    protected String logo;
    protected List<Protocols> protocols = new ArrayList<Protocols>();
    protected Authenticated authenticated;
    protected AuthenticatedWithCertificate authenticatedWithCertificate;
    protected AuthenticatedWithToken authenticatedWithToken;
    protected Info info;
    protected List<Tag> tagList = new ArrayList<Tag>();
    protected List<Resource> resourceList = new ArrayList<Resource>();
    protected Service _service;

    public RESTService(Node node) {
        super(node);
    }

    public String swagger() {
        return this.swagger;
    }

    public String host() {
        return this.host;
    }

    public String port() {
        return this.port;
    }

    public String description() {
        return this.description;
    }

    public String basePath() {
        return this.basePath;
    }

    public String logo() {
        return this.logo;
    }

    public List<Protocols> protocols() {
        return this.protocols;
    }

    public RESTService swagger(String value) {
        this.swagger = value;
        return this;
    }

    public RESTService host(String value) {
        this.host = value;
        return this;
    }

    public RESTService port(String value) {
        this.port = value;
        return this;
    }

    public RESTService description(String value) {
        this.description = value;
        return this;
    }

    public RESTService basePath(String value) {
        this.basePath = value;
        return this;
    }

    public RESTService logo(String value) {
        this.logo = value;
        return this;
    }

    public Authenticated authenticated() {
        return this.authenticated;
    }

    public AuthenticatedWithCertificate authenticatedWithCertificate() {
        return this.authenticatedWithCertificate;
    }

    public AuthenticatedWithToken authenticatedWithToken() {
        return this.authenticatedWithToken;
    }

    public Info info() {
        return this.info;
    }

    public List<Tag> tagList() {
        return Collections.unmodifiableList(this.tagList);
    }

    public Tag tag(int index) {
        return this.tagList.get(index);
    }

    public List<Tag> tagList(Predicate<Tag> predicate) {
        return this.tagList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Resource> resourceList() {
        return Collections.unmodifiableList(this.resourceList);
    }

    public Resource resource(int index) {
        return this.resourceList.get(index);
    }

    public List<Resource> resourceList(Predicate<Resource> predicate) {
        return this.resourceList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return this._service.schemaList();
    }

    public Schema schemaList(int index) {
        return this._service.schemaList().get(index);
    }

    public List<Exception> exceptionList() {
        return this._service.exceptionList();
    }

    public Exception exceptionList(int index) {
        return this._service.exceptionList().get(index);
    }

    public RESTService authenticated(Authenticated value) {
        this.authenticated = value;
        return this;
    }

    public RESTService authenticatedWithCertificate(AuthenticatedWithCertificate value) {
        this.authenticatedWithCertificate = value;
        return this;
    }

    public RESTService authenticatedWithToken(AuthenticatedWithToken value) {
        this.authenticatedWithToken = value;
        return this;
    }

    public RESTService info(Info value) {
        this.info = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.authenticated != null) {
            components.add(this.authenticated.core$());
        }
        if (this.authenticatedWithCertificate != null) {
            components.add(this.authenticatedWithCertificate.core$());
        }
        if (this.authenticatedWithToken != null) {
            components.add(this.authenticatedWithToken.core$());
        }
        if (this.info != null) {
            components.add(this.info.core$());
        }
        new ArrayList<Tag>(this.tagList).forEach(c -> components.add(c.core$()));
        new ArrayList<Resource>(this.resourceList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("swagger", new ArrayList<String>(Collections.singletonList(this.swagger)));
        map.put("host", new ArrayList<String>(Collections.singletonList(this.host)));
        map.put("port", new ArrayList<String>(Collections.singletonList(this.port)));
        map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
        map.put("basePath", new ArrayList<String>(Collections.singletonList(this.basePath)));
        map.put("logo", new ArrayList<String>(Collections.singletonList(this.logo)));
        map.put("protocols", this.protocols);
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("REST#Service$Authenticated")) {
            this.authenticated = (Authenticated)node.as(Authenticated.class);
        }
        if (node.is("REST#Service$AuthenticatedWithCertificate")) {
            this.authenticatedWithCertificate = (AuthenticatedWithCertificate)node.as(AuthenticatedWithCertificate.class);
        }
        if (node.is("REST#Service$AuthenticatedWithToken")) {
            this.authenticatedWithToken = (AuthenticatedWithToken)node.as(AuthenticatedWithToken.class);
        }
        if (node.is("REST#Service$Info")) {
            this.info = (Info)node.as(Info.class);
        }
        if (node.is("REST#Service$Tag")) {
            this.tagList.add((Tag)node.as(Tag.class));
        }
        if (node.is("REST#Service$Resource")) {
            this.resourceList.add((Resource)node.as(Resource.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("REST#Service$Authenticated")) {
            this.authenticated = null;
        }
        if (node.is("REST#Service$AuthenticatedWithCertificate")) {
            this.authenticatedWithCertificate = null;
        }
        if (node.is("REST#Service$AuthenticatedWithToken")) {
            this.authenticatedWithToken = null;
        }
        if (node.is("REST#Service$Info")) {
            this.info = null;
        }
        if (node.is("REST#Service$Tag")) {
            this.tagList.remove(node.as(Tag.class));
        }
        if (node.is("REST#Service$Resource")) {
            this.resourceList.remove(node.as(Resource.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("swagger")) {
            this.swagger = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("host")) {
            this.host = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("port")) {
            this.port = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("basePath")) {
            this.basePath = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("logo")) {
            this.logo = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("protocols")) {
            this.protocols = WordLoader.load(values, Protocols.class, (Layer)this);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("swagger")) {
            this.swagger = (String)values.get(0);
        } else if (name.equalsIgnoreCase("host")) {
            this.host = (String)values.get(0);
        } else if (name.equalsIgnoreCase("port")) {
            this.port = (String)values.get(0);
        } else if (name.equalsIgnoreCase("description")) {
            this.description = (String)values.get(0);
        } else if (name.equalsIgnoreCase("basePath")) {
            this.basePath = (String)values.get(0);
        } else if (name.equalsIgnoreCase("logo")) {
            this.logo = (String)values.get(0);
        } else if (name.equalsIgnoreCase("protocols")) {
            this.protocols = new ArrayList(values);
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Service) {
            this._service = (Service)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Resource
    extends Layer
    implements Terminal {
        protected String path;
        protected List<Parameter> parameterList = new ArrayList<Parameter>();
        protected List<Operation> operationList = new ArrayList<Operation>();
        protected List<Get> getList = new ArrayList<Get>();
        protected List<Post> postList = new ArrayList<Post>();
        protected List<Put> putList = new ArrayList<Put>();
        protected List<Delete> deleteList = new ArrayList<Delete>();
        protected List<Head> headList = new ArrayList<Head>();
        protected List<Options> optionsList = new ArrayList<Options>();
        protected List<Patch> patchList = new ArrayList<Patch>();

        public Resource(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public Resource path(String value) {
            this.path = value;
            return this;
        }

        public List<Parameter> parameterList() {
            return Collections.unmodifiableList(this.parameterList);
        }

        public Parameter parameter(int index) {
            return this.parameterList.get(index);
        }

        public List<Parameter> parameterList(Predicate<Parameter> predicate) {
            return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Get> getList() {
            return Collections.unmodifiableList(this.getList);
        }

        public Get get(int index) {
            return this.getList.get(index);
        }

        public List<Get> getList(Predicate<Get> predicate) {
            return this.getList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Post> postList() {
            return Collections.unmodifiableList(this.postList);
        }

        public Post post(int index) {
            return this.postList.get(index);
        }

        public List<Post> postList(Predicate<Post> predicate) {
            return this.postList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Put> putList() {
            return Collections.unmodifiableList(this.putList);
        }

        public Put put(int index) {
            return this.putList.get(index);
        }

        public List<Put> putList(Predicate<Put> predicate) {
            return this.putList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Delete> deleteList() {
            return Collections.unmodifiableList(this.deleteList);
        }

        public Delete delete(int index) {
            return this.deleteList.get(index);
        }

        public List<Delete> deleteList(Predicate<Delete> predicate) {
            return this.deleteList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Head> headList() {
            return Collections.unmodifiableList(this.headList);
        }

        public Head head(int index) {
            return this.headList.get(index);
        }

        public List<Head> headList(Predicate<Head> predicate) {
            return this.headList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Options> optionsList() {
            return Collections.unmodifiableList(this.optionsList);
        }

        public Options options(int index) {
            return this.optionsList.get(index);
        }

        public List<Options> optionsList(Predicate<Options> predicate) {
            return this.optionsList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Patch> patchList() {
            return Collections.unmodifiableList(this.patchList);
        }

        public Patch patch(int index) {
            return this.patchList.get(index);
        }

        public List<Patch> patchList(Predicate<Patch> predicate) {
            return this.patchList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
            new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
            new ArrayList<Get>(this.getList).forEach(c -> components.add(c.core$()));
            new ArrayList<Post>(this.postList).forEach(c -> components.add(c.core$()));
            new ArrayList<Put>(this.putList).forEach(c -> components.add(c.core$()));
            new ArrayList<Delete>(this.deleteList).forEach(c -> components.add(c.core$()));
            new ArrayList<Head>(this.headList).forEach(c -> components.add(c.core$()));
            new ArrayList<Options>(this.optionsList).forEach(c -> components.add(c.core$()));
            new ArrayList<Patch>(this.patchList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("REST#Service$Resource$Parameter")) {
                this.parameterList.add((Parameter)node.as(Parameter.class));
            }
            if (node.is("REST#Service$Resource$Operation")) {
                this.operationList.add((Operation)node.as(Operation.class));
            }
            if (node.is("REST#Service$Resource$Get")) {
                this.getList.add((Get)node.as(Get.class));
            }
            if (node.is("REST#Service$Resource$Post")) {
                this.postList.add((Post)node.as(Post.class));
            }
            if (node.is("REST#Service$Resource$Put")) {
                this.putList.add((Put)node.as(Put.class));
            }
            if (node.is("REST#Service$Resource$Delete")) {
                this.deleteList.add((Delete)node.as(Delete.class));
            }
            if (node.is("REST#Service$Resource$Head")) {
                this.headList.add((Head)node.as(Head.class));
            }
            if (node.is("REST#Service$Resource$Options")) {
                this.optionsList.add((Options)node.as(Options.class));
            }
            if (node.is("REST#Service$Resource$Patch")) {
                this.patchList.add((Patch)node.as(Patch.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("REST#Service$Resource$Parameter")) {
                this.parameterList.remove(node.as(Parameter.class));
            }
            if (node.is("REST#Service$Resource$Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
            if (node.is("REST#Service$Resource$Get")) {
                this.getList.remove(node.as(Get.class));
            }
            if (node.is("REST#Service$Resource$Post")) {
                this.postList.remove(node.as(Post.class));
            }
            if (node.is("REST#Service$Resource$Put")) {
                this.putList.remove(node.as(Put.class));
            }
            if (node.is("REST#Service$Resource$Delete")) {
                this.deleteList.remove(node.as(Delete.class));
            }
            if (node.is("REST#Service$Resource$Head")) {
                this.headList.remove(node.as(Head.class));
            }
            if (node.is("REST#Service$Resource$Options")) {
                this.optionsList.remove(node.as(Options.class));
            }
            if (node.is("REST#Service$Resource$Patch")) {
                this.patchList.remove(node.as(Patch.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Patch
        extends Operation
        implements Terminal {
            public Patch(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Options
        extends Operation
        implements Terminal {
            public Options(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Head
        extends Operation
        implements Terminal {
            public Head(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Delete
        extends Operation
        implements Terminal {
            public Delete(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Put
        extends Operation
        implements Terminal {
            public Put(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Post
        extends Operation
        implements Terminal {
            public Post(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Get
        extends Operation
        implements Terminal {
            public Get(Node node) {
                super(node);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static abstract class Operation
        extends Layer
        implements Terminal {
            protected List<String> tags = new ArrayList<String>();
            protected String summary;
            protected String description;
            protected String externalDocumentationPath;
            protected boolean deprecated;
            protected List<Exception> exceptionRefs = new ArrayList<Exception>();
            protected List<Parameter> parameterList = new ArrayList<Parameter>();
            protected Response response;
            protected List<Exception> exceptionList = new ArrayList<Exception>();

            public Operation(Node node) {
                super(node);
            }

            public List<String> tags() {
                return this.tags;
            }

            public String tags(int index) {
                return this.tags.get(index);
            }

            public List<String> tags(Predicate<String> predicate) {
                return this.tags().stream().filter(predicate).collect(Collectors.toList());
            }

            public String summary() {
                return this.summary;
            }

            public String description() {
                return this.description;
            }

            public String externalDocumentationPath() {
                return this.externalDocumentationPath;
            }

            public boolean deprecated() {
                return this.deprecated;
            }

            public List<Exception> exceptionRefs() {
                return this.exceptionRefs;
            }

            public Exception exceptionRefs(int index) {
                return this.exceptionRefs.get(index);
            }

            public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
                return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
            }

            public Operation summary(String value) {
                this.summary = value;
                return this;
            }

            public Operation description(String value) {
                this.description = value;
                return this;
            }

            public Operation externalDocumentationPath(String value) {
                this.externalDocumentationPath = value;
                return this;
            }

            public Operation deprecated(boolean value) {
                this.deprecated = value;
                return this;
            }

            public List<Parameter> parameterList() {
                return Collections.unmodifiableList(this.parameterList);
            }

            public Parameter parameter(int index) {
                return this.parameterList.get(index);
            }

            public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Response response() {
                return this.response;
            }

            public List<Exception> exceptionList() {
                return Collections.unmodifiableList(this.exceptionList);
            }

            public Exception exception(int index) {
                return this.exceptionList.get(index);
            }

            public List<Exception> exceptionList(Predicate<Exception> predicate) {
                return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Operation response(Response value) {
                this.response = value;
                return this;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                if (this.response != null) {
                    components.add(this.response.core$());
                }
                new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("tags", this.tags);
                map.put("summary", new ArrayList<String>(Collections.singletonList(this.summary)));
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                map.put("externalDocumentationPath", new ArrayList<String>(Collections.singletonList(this.externalDocumentationPath)));
                map.put("deprecated", new ArrayList<Boolean>(Collections.singletonList(this.deprecated)));
                map.put("exceptionRefs", this.exceptionRefs);
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("REST#Service$Resource$Parameter")) {
                    this.parameterList.add((Parameter)node.as(Parameter.class));
                }
                if (node.is("Response")) {
                    this.response = (Response)node.as(Response.class);
                }
                if (node.is("Exception")) {
                    this.exceptionList.add((Exception)node.as(Exception.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("REST#Service$Resource$Parameter")) {
                    this.parameterList.remove(node.as(Parameter.class));
                }
                if (node.is("Response")) {
                    this.response = null;
                }
                if (node.is("Exception")) {
                    this.exceptionList.remove(node.as(Exception.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("tags")) {
                    this.tags = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("summary")) {
                    this.summary = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("externalDocumentationPath")) {
                    this.externalDocumentationPath = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("deprecated")) {
                    this.deprecated = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("exceptionRefs")) {
                    this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("tags")) {
                    this.tags = new ArrayList(values);
                } else if (name.equalsIgnoreCase("summary")) {
                    this.summary = (String)values.get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                } else if (name.equalsIgnoreCase("externalDocumentationPath")) {
                    this.externalDocumentationPath = (String)values.get(0);
                } else if (name.equalsIgnoreCase("deprecated")) {
                    this.deprecated = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("exceptionRefs")) {
                    this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void parameter(Predicate<Parameter> filter) {
                    new ArrayList<Parameter>(Operation.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void exception(Predicate<Exception> filter) {
                    new ArrayList<Exception>(Operation.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter(Parameter.In in) {
                    Parameter newElement = (Parameter)Operation.this.core$().graph().concept(Parameter.class).createNode(this.name, Operation.this.core$()).as(Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Response response() {
                    Response newElement = (Response)Operation.this.core$().graph().concept(Response.class).createNode(this.name, Operation.this.core$()).as(Response.class);
                    return newElement;
                }

                public Exception exception(ExceptionCodes code) {
                    Exception newElement = (Exception)Operation.this.core$().graph().concept(Exception.class).createNode(this.name, Operation.this.core$()).as(Exception.class);
                    newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                    return newElement;
                }
            }
        }

        public static class Parameter
        extends io.intino.konos.model.graph.Parameter
        implements Component,
        Terminal {
            protected String description;
            protected In in;

            public Parameter(Node node) {
                super(node);
            }

            public String description() {
                return this.description;
            }

            public In in() {
                return this.in;
            }

            public Parameter description(String value) {
                this.description = value;
                return this;
            }

            public Parameter in(In value) {
                this.in = value;
                return this;
            }

            @Override
            public IntegerData asInteger() {
                Layer as = this.a$(IntegerData.class);
                return as != null ? (IntegerData)as : (IntegerData)this.core$().addFacet(IntegerData.class);
            }

            @Override
            public boolean isInteger() {
                return this.core$().is(IntegerData.class);
            }

            @Override
            public TypeData asType() {
                return (TypeData)this.a$(TypeData.class);
            }

            @Override
            public TypeData asType(Expression<String> type) {
                TypeData newElement = (TypeData)this.core$().addFacet(TypeData.class);
                newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
                return newElement;
            }

            @Override
            public boolean isType() {
                return this.core$().is(TypeData.class);
            }

            @Override
            public void removeType() {
                this.core$().removeFacet(TypeData.class);
            }

            @Override
            public WordData asWord() {
                return (WordData)this.a$(WordData.class);
            }

            @Override
            public WordData asWord(List<String> values) {
                WordData newElement = (WordData)this.core$().addFacet(WordData.class);
                newElement.core$().set((Layer)newElement, "values", values);
                return newElement;
            }

            @Override
            public boolean isWord() {
                return this.core$().is(WordData.class);
            }

            @Override
            public void removeWord() {
                this.core$().removeFacet(WordData.class);
            }

            @Override
            public BoolData asBool() {
                Layer as = this.a$(BoolData.class);
                return as != null ? (BoolData)as : (BoolData)this.core$().addFacet(BoolData.class);
            }

            @Override
            public boolean isBool() {
                return this.core$().is(BoolData.class);
            }

            @Override
            public RealData asReal() {
                Layer as = this.a$(RealData.class);
                return as != null ? (RealData)as : (RealData)this.core$().addFacet(RealData.class);
            }

            @Override
            public boolean isReal() {
                return this.core$().is(RealData.class);
            }

            @Override
            public LongIntegerData asLongInteger() {
                Layer as = this.a$(LongIntegerData.class);
                return as != null ? (LongIntegerData)as : (LongIntegerData)this.core$().addFacet(LongIntegerData.class);
            }

            @Override
            public boolean isLongInteger() {
                return this.core$().is(LongIntegerData.class);
            }

            @Override
            public TextData asText() {
                Layer as = this.a$(TextData.class);
                return as != null ? (TextData)as : (TextData)this.core$().addFacet(TextData.class);
            }

            @Override
            public boolean isText() {
                return this.core$().is(TextData.class);
            }

            @Override
            public ObjectData asObject() {
                return (ObjectData)this.a$(ObjectData.class);
            }

            @Override
            public ObjectData asObject(Schema schema) {
                ObjectData newElement = (ObjectData)this.core$().addFacet(ObjectData.class);
                newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
                return newElement;
            }

            @Override
            public boolean isObject() {
                return this.core$().is(ObjectData.class);
            }

            @Override
            public void removeObject() {
                this.core$().removeFacet(ObjectData.class);
            }

            @Override
            public ListData asList() {
                Layer as = this.a$(ListData.class);
                return as != null ? (ListData)as : (ListData)this.core$().addFacet(ListData.class);
            }

            @Override
            public boolean isList() {
                return this.core$().is(ListData.class);
            }

            @Override
            public FileData asFile() {
                Layer as = this.a$(FileData.class);
                return as != null ? (FileData)as : (FileData)this.core$().addFacet(FileData.class);
            }

            @Override
            public boolean isFile() {
                return this.core$().is(FileData.class);
            }

            @Override
            public DateData asDate() {
                Layer as = this.a$(DateData.class);
                return as != null ? (DateData)as : (DateData)this.core$().addFacet(DateData.class);
            }

            @Override
            public boolean isDate() {
                return this.core$().is(DateData.class);
            }

            @Override
            public DateTimeData asDateTime() {
                Layer as = this.a$(DateTimeData.class);
                return as != null ? (DateTimeData)as : (DateTimeData)this.core$().addFacet(DateTimeData.class);
            }

            @Override
            public boolean isDateTime() {
                return this.core$().is(DateTimeData.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                map.put("in", new ArrayList<In>(Collections.singletonList(this.in)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("in")) {
                    this.in = (In)((Object)WordLoader.load(values, In.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                } else if (name.equalsIgnoreCase("in")) {
                    this.in = (In)((Object)values.get(0));
                }
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static enum In {
                body,
                path,
                form,
                header,
                query;

            }
        }

        public class Clear {
            public void parameter(Predicate<Parameter> filter) {
                new ArrayList<Parameter>(Resource.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void get(Predicate<Get> filter) {
                new ArrayList<Get>(Resource.this.getList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void post(Predicate<Post> filter) {
                new ArrayList<Post>(Resource.this.postList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void put(Predicate<Put> filter) {
                new ArrayList<Put>(Resource.this.putList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void delete(Predicate<Delete> filter) {
                new ArrayList<Delete>(Resource.this.deleteList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void head(Predicate<Head> filter) {
                new ArrayList<Head>(Resource.this.headList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void options(Predicate<Options> filter) {
                new ArrayList<Options>(Resource.this.optionsList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void patch(Predicate<Patch> filter) {
                new ArrayList<Patch>(Resource.this.patchList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Parameter parameter(Parameter.In in) {
                Parameter newElement = (Parameter)Resource.this.core$().graph().concept(Parameter.class).createNode(this.name, Resource.this.core$()).as(Parameter.class);
                newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                return newElement;
            }

            public Get get() {
                Get newElement = (Get)Resource.this.core$().graph().concept(Get.class).createNode(this.name, Resource.this.core$()).as(Get.class);
                return newElement;
            }

            public Post post() {
                Post newElement = (Post)Resource.this.core$().graph().concept(Post.class).createNode(this.name, Resource.this.core$()).as(Post.class);
                return newElement;
            }

            public Put put() {
                Put newElement = (Put)Resource.this.core$().graph().concept(Put.class).createNode(this.name, Resource.this.core$()).as(Put.class);
                return newElement;
            }

            public Delete delete() {
                Delete newElement = (Delete)Resource.this.core$().graph().concept(Delete.class).createNode(this.name, Resource.this.core$()).as(Delete.class);
                return newElement;
            }

            public Head head() {
                Head newElement = (Head)Resource.this.core$().graph().concept(Head.class).createNode(this.name, Resource.this.core$()).as(Head.class);
                return newElement;
            }

            public Options options() {
                Options newElement = (Options)Resource.this.core$().graph().concept(Options.class).createNode(this.name, Resource.this.core$()).as(Options.class);
                return newElement;
            }

            public Patch patch() {
                Patch newElement = (Patch)Resource.this.core$().graph().concept(Patch.class).createNode(this.name, Resource.this.core$()).as(Patch.class);
                return newElement;
            }
        }
    }

    public static class Tag
    extends Layer
    implements Terminal {
        protected String description;
        protected List<Document> documentList = new ArrayList<Document>();

        public Tag(Node node) {
            super(node);
        }

        public String description() {
            return this.description;
        }

        public Tag description(String value) {
            this.description = value;
            return this;
        }

        public List<Document> documentList() {
            return Collections.unmodifiableList(this.documentList);
        }

        public Document document(int index) {
            return this.documentList.get(index);
        }

        public List<Document> documentList(Predicate<Document> predicate) {
            return this.documentList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Document>(this.documentList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("REST#Service$Tag$Document")) {
                this.documentList.add((Document)node.as(Document.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("REST#Service$Tag$Document")) {
                this.documentList.remove(node.as(Document.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("description")) {
                this.description = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Document
        extends Layer
        implements Terminal {
            protected String description;
            protected String url;

            public Document(Node node) {
                super(node);
            }

            public String description() {
                return this.description;
            }

            public String url() {
                return this.url;
            }

            public Document description(String value) {
                this.description = value;
                return this;
            }

            public Document url(String value) {
                this.url = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                } else if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
            public void document(Predicate<Document> filter) {
                new ArrayList<Document>(Tag.this.documentList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Document document(String url) {
                Document newElement = (Document)Tag.this.core$().graph().concept(Document.class).createNode(this.name, Tag.this.core$()).as(Document.class);
                newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
                return newElement;
            }
        }
    }

    public static class Info
    extends Layer
    implements Terminal {
        protected String title;
        protected String version;
        protected String description;
        protected String termsOfService;
        protected Contact contact;
        protected License license;

        public Info(Node node) {
            super(node);
        }

        public String title() {
            return this.title;
        }

        public String version() {
            return this.version;
        }

        public String description() {
            return this.description;
        }

        public String termsOfService() {
            return this.termsOfService;
        }

        public Info title(String value) {
            this.title = value;
            return this;
        }

        public Info version(String value) {
            this.version = value;
            return this;
        }

        public Info description(String value) {
            this.description = value;
            return this;
        }

        public Info termsOfService(String value) {
            this.termsOfService = value;
            return this;
        }

        public Contact contact() {
            return this.contact;
        }

        public License license() {
            return this.license;
        }

        public Info contact(Contact value) {
            this.contact = value;
            return this;
        }

        public Info license(License value) {
            this.license = value;
            return this;
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.contact != null) {
                components.add(this.contact.core$());
            }
            if (this.license != null) {
                components.add(this.license.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
            map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
            map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
            map.put("termsOfService", new ArrayList<String>(Collections.singletonList(this.termsOfService)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("REST#Service$Info$Contact")) {
                this.contact = (Contact)node.as(Contact.class);
            }
            if (node.is("REST#Service$Info$License")) {
                this.license = (License)node.as(License.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("REST#Service$Info$Contact")) {
                this.contact = null;
            }
            if (node.is("REST#Service$Info$License")) {
                this.license = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("version")) {
                this.version = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("description")) {
                this.description = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("termsOfService")) {
                this.termsOfService = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)values.get(0);
            } else if (name.equalsIgnoreCase("version")) {
                this.version = (String)values.get(0);
            } else if (name.equalsIgnoreCase("description")) {
                this.description = (String)values.get(0);
            } else if (name.equalsIgnoreCase("termsOfService")) {
                this.termsOfService = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class License
        extends Layer
        implements Terminal {
            protected String url;

            public License(Node node) {
                super(node);
            }

            public String url() {
                return this.url;
            }

            public License url(String value) {
                this.url = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Contact
        extends Layer
        implements Terminal {
            protected String url;
            protected String email;

            public Contact(Node node) {
                super(node);
            }

            public String url() {
                return this.url;
            }

            public String email() {
                return this.email;
            }

            public Contact url(String value) {
                this.url = value;
                return this;
            }

            public Contact email(String value) {
                this.email = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                map.put("email", new ArrayList<String>(Collections.singletonList(this.email)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("email")) {
                    this.email = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                } else if (name.equalsIgnoreCase("email")) {
                    this.email = (String)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Contact contact() {
                Contact newElement = (Contact)Info.this.core$().graph().concept(Contact.class).createNode(this.name, Info.this.core$()).as(Contact.class);
                return newElement;
            }

            public License license() {
                License newElement = (License)Info.this.core$().graph().concept(License.class).createNode(this.name, Info.this.core$()).as(License.class);
                return newElement;
            }
        }
    }

    public static class AuthenticatedWithToken
    extends Authenticated
    implements Terminal {
        public AuthenticatedWithToken(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class AuthenticatedWithCertificate
    extends Authenticated
    implements Terminal {
        protected String store;
        protected String storePassword;
        protected List<AllowedUsers> allowedUsersList = new ArrayList<AllowedUsers>();

        public AuthenticatedWithCertificate(Node node) {
            super(node);
        }

        public String store() {
            return this.store;
        }

        public String storePassword() {
            return this.storePassword;
        }

        public AuthenticatedWithCertificate store(String value) {
            this.store = value;
            return this;
        }

        public AuthenticatedWithCertificate storePassword(String value) {
            this.storePassword = value;
            return this;
        }

        public List<AllowedUsers> allowedUsersList() {
            return Collections.unmodifiableList(this.allowedUsersList);
        }

        public AllowedUsers allowedUsers(int index) {
            return this.allowedUsersList.get(index);
        }

        public List<AllowedUsers> allowedUsersList(Predicate<AllowedUsers> predicate) {
            return this.allowedUsersList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<AllowedUsers>(this.allowedUsersList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("store", new ArrayList<String>(Collections.singletonList(this.store)));
            map.put("storePassword", new ArrayList<String>(Collections.singletonList(this.storePassword)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("REST#Service$AuthenticatedWithCertificate$AllowedUsers")) {
                this.allowedUsersList.add((AllowedUsers)node.as(AllowedUsers.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("REST#Service$AuthenticatedWithCertificate$AllowedUsers")) {
                this.allowedUsersList.remove(node.as(AllowedUsers.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("store")) {
                this.store = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("storePassword")) {
                this.storePassword = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("store")) {
                this.store = (String)values.get(0);
            } else if (name.equalsIgnoreCase("storePassword")) {
                this.storePassword = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class AllowedUsers
        extends Layer
        implements Terminal {
            protected List<String> certificate = new ArrayList<String>();

            public AllowedUsers(Node node) {
                super(node);
            }

            public List<String> certificate() {
                return this.certificate;
            }

            public String certificate(int index) {
                return this.certificate.get(index);
            }

            public List<String> certificate(Predicate<String> predicate) {
                return this.certificate().stream().filter(predicate).collect(Collectors.toList());
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("certificate", this.certificate);
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("certificate")) {
                    this.certificate = StringLoader.load(values, (Layer)this);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("certificate")) {
                    this.certificate = new ArrayList(values);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
            public void allowedUsers(Predicate<AllowedUsers> filter) {
                new ArrayList<AllowedUsers>(AuthenticatedWithCertificate.this.allowedUsersList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Authenticated.Create {
            public Create(String name) {
                super(name);
            }

            public AllowedUsers allowedUsers(List<String> certificate) {
                AllowedUsers newElement = (AllowedUsers)AuthenticatedWithCertificate.this.core$().graph().concept(AllowedUsers.class).createNode(this.name, AuthenticatedWithCertificate.this.core$()).as(AllowedUsers.class);
                newElement.core$().set((Layer)newElement, "certificate", certificate);
                return newElement;
            }
        }
    }

    public static abstract class Authenticated
    extends Layer
    implements Terminal {
        public Authenticated(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void tag(Predicate<Tag> filter) {
            new ArrayList<Tag>(RESTService.this.tagList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void resource(Predicate<Resource> filter) {
            new ArrayList<Resource>(RESTService.this.resourceList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(RESTService.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exception(Predicate<Exception> filter) {
            new ArrayList<Exception>(RESTService.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public AuthenticatedWithCertificate authenticatedWithCertificate(String store, String storePassword) {
            AuthenticatedWithCertificate newElement = (AuthenticatedWithCertificate)RESTService.this.core$().graph().concept(AuthenticatedWithCertificate.class).createNode(this.name, RESTService.this.core$()).as(AuthenticatedWithCertificate.class);
            newElement.core$().set((Layer)newElement, "store", Collections.singletonList(store));
            newElement.core$().set((Layer)newElement, "storePassword", Collections.singletonList(storePassword));
            return newElement;
        }

        public AuthenticatedWithToken authenticatedWithToken() {
            AuthenticatedWithToken newElement = (AuthenticatedWithToken)RESTService.this.core$().graph().concept(AuthenticatedWithToken.class).createNode(this.name, RESTService.this.core$()).as(AuthenticatedWithToken.class);
            return newElement;
        }

        public Info info(String title, String version) {
            Info newElement = (Info)RESTService.this.core$().graph().concept(Info.class).createNode(this.name, RESTService.this.core$()).as(Info.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
            return newElement;
        }

        public Tag tag() {
            Tag newElement = (Tag)RESTService.this.core$().graph().concept(Tag.class).createNode(this.name, RESTService.this.core$()).as(Tag.class);
            return newElement;
        }

        public Resource resource(String path) {
            Resource newElement = (Resource)RESTService.this.core$().graph().concept(Resource.class).createNode(this.name, RESTService.this.core$()).as(Resource.class);
            newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)RESTService.this.core$().graph().concept(Schema.class).createNode(this.name, RESTService.this.core$()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)RESTService.this.core$().graph().concept(Exception.class).createNode(this.name, RESTService.this.core$()).as(Exception.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }

    public static enum Protocols {
        http,
        https,
        ws,
        wss;

    }
}

