/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.dialog;

import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.dialog.AbstractDialogTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.multiple.dialog.tab.MultipleInput;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class AbstractDialogRenderer {
    private static final String DIALOGS = "dialogs";
    private final File gen;
    private final String packageName;
    private final List<Dialog> dialogs;
    private final String boxName;

    public AbstractDialogRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.gen = gen;
        this.packageName = packageName;
        this.dialogs = graph.dialogList();
        this.boxName = boxName;
    }

    public void execute() {
        this.dialogs.forEach(this::processDialog);
    }

    private void processDialog(Dialog dialog) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"dialogDisplay"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{dialog.name$()});
        frame.addSlot("box", new String[]{this.boxName});
        Frame dialogFrame = new Frame(new String[0]).addTypes(new String[]{"dialog"});
        if (!dialog.label().isEmpty()) {
            dialogFrame.addSlot("label", new String[]{dialog.label()});
        }
        if (!dialog.description().isEmpty()) {
            dialogFrame.addSlot("description", new String[]{dialog.description()});
        }
        frame.addSlot("dialog", new AbstractFrame[]{dialogFrame});
        this.createToolbar(dialogFrame, dialog.name$(), dialog.toolbar());
        for (Dialog.Tab tab : dialog.tabList()) {
            dialogFrame.addSlot("tab", new AbstractFrame[]{this.frameOf(tab)});
        }
        Commons.writeFrame(new File(this.gen, DIALOGS), "Abstract" + StringHelper.snakeCaseToCamelCase((String)dialog.name$()), this.template().format((Object)frame));
    }

    private void createToolbar(Frame frame, String dialog, Dialog.Toolbar toolbar) {
        if (toolbar == null) {
            return;
        }
        for (Dialog.Toolbar.Operation operation : toolbar.operationList()) {
            frame.addSlot("operation", new AbstractFrame[]{this.frameOf(dialog, operation.name$(), operation.label(), operation.closeAfterExecution())});
        }
    }

    private Frame frameOf(String dialog, String operation, String operationLabel, boolean closeAfterExecution) {
        Frame operationFrame = new Frame(new String[0]).addTypes(new String[]{"operation"}).addSlot("dialog", new String[]{dialog}).addSlot("execution", new String[]{operation});
        if (!operation.isEmpty()) {
            operationFrame.addSlot("name", new String[]{operation}).addSlot("label", new String[]{operationLabel});
        }
        operationFrame.addSlot("closeAfterExecution", new Boolean[]{closeAfterExecution});
        return operationFrame;
    }

    private Frame frameOf(Dialog.Tab tab) {
        Frame tabFrame = new Frame(new String[0]).addTypes(new String[]{"tab"});
        if (!tab.name$().isEmpty()) {
            tabFrame.addSlot("name", new String[]{tab.name$()});
        }
        if (!tab.label().isEmpty()) {
            tabFrame.addSlot("label", new String[]{tab.label()});
        }
        for (Dialog.Tab.Input input : tab.inputList()) {
            this.processInput(tabFrame, input);
        }
        return tabFrame;
    }

    private Frame frameOf(Dialog.Tab.Text text) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"text"});
        if (text.edition() != null) {
            frame.addSlot("edition", new Object[]{text.edition()});
        }
        if (text.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(text.validation())});
        }
        this.addCommon(frame, text);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Text.Validation validation) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"text", "validation"});
        if (!validation.allowedValues().isEmpty()) {
            frame.addSlot("allowedValues", validation.allowedValues().toArray(new String[0]));
        }
        if (!validation.disallowedValues().isEmpty()) {
            frame.addSlot("disallowedValues", validation.disallowedValues().toArray(new String[0]));
        }
        frame.addSlot("disallowEmptySpaces", new Boolean[]{validation.disallowEmptySpaces()});
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Section section) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"section"});
        List<Dialog.Tab.Input> inputs = section.inputList();
        for (Dialog.Tab.Input input : inputs) {
            this.processInput(frame, input);
        }
        this.addCommon(frame, section);
        return frame;
    }

    private void processInput(Frame sectionFrame, Dialog.Tab.Input input) {
        if (input.i$(Dialog.Tab.Text.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Text)input)});
        } else if (input.i$(Dialog.Tab.Section.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Section)input)});
        } else if (input.i$(Dialog.Tab.Memo.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Memo)input)});
        } else if (input.i$(Dialog.Tab.RadioBox.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.RadioBox)input)});
        } else if (input.i$(Dialog.Tab.CheckBox.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.CheckBox)input)});
        } else if (input.i$(Dialog.Tab.ComboBox.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.ComboBox)input)});
        } else if (input.i$(Dialog.Tab.Password.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Password)input)});
        } else if (input.i$(Dialog.Tab.File.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.File)input)});
        } else if (input.i$(Dialog.Tab.Picture.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Picture)input)});
        } else if (input.i$(Dialog.Tab.Date.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.Date)input)});
        } else if (input.i$(Dialog.Tab.DateTime.class)) {
            sectionFrame.addSlot("input", new AbstractFrame[]{this.frameOf((Dialog.Tab.DateTime)input)});
        }
    }

    private Frame frameOf(Dialog.Tab.Memo memo) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"memo"});
        frame.addSlot("mode", new String[]{memo.mode().name()});
        frame.addSlot("height", new Integer[]{memo.height()});
        this.addCommon(frame, memo);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Password password) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"password"});
        if (password.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(password.validation())});
        }
        this.addCommon(frame, password);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Password.Validation validation) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"password", "validation"});
        frame.addSlot("required", (String[])validation.isRequired().stream().map(Enum::name).toArray(String[]::new));
        if (validation.length() != null) {
            frame.addSlot("min", new Integer[]{validation.length().min()}).addSlot("max", new Integer[]{validation.length().max()});
        }
        return frame;
    }

    private Frame frameOf(Dialog.Tab.ComboBox combo) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"combo"});
        this.addSources(combo, frame);
        this.addCommon(frame, combo);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.CheckBox check) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"check"});
        this.addSources(check, frame);
        this.addCommon(frame, check);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.RadioBox radio) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"radio"});
        this.addSources(radio, frame);
        this.addCommon(frame, radio);
        return frame;
    }

    private void addSources(Dialog.Tab.OptionBox comboBox, Frame frame) {
        if (comboBox.source() != null && !comboBox.source().isEmpty()) {
            frame.addSlot("source", new AbstractFrame[]{this.sourceOf(comboBox)});
        } else if (comboBox.options() != null && !comboBox.options().isEmpty()) {
            frame.addSlot("options", comboBox.options().toArray(new String[0]));
        }
    }

    private Frame sourceOf(Dialog.Tab.OptionBox optionBox) {
        return new Frame(new String[0]).addSlot("dialog", new String[]{((Dialog)optionBox.core$().ownerAs(Dialog.class)).name$()}).addSlot("name", new String[]{optionBox.source()}).addSlot("type", new String[]{((Object)((Object)optionBox)).getClass().getSimpleName()});
    }

    private Frame frameOf(Dialog.Tab.File file) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"file"});
        if (file.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(file.validation())});
        }
        this.addCommon(frame, file);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Picture picture) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"picture"});
        if (picture.validation() != null) {
            frame.addSlot("validation", new AbstractFrame[]{this.frameOf(picture.validation())});
        }
        this.addCommon(frame, picture);
        return frame;
    }

    private AbstractFrame frameOf(Dialog.Tab.Resource.Validation validation) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"resource", "validation"});
        if (validation.maxSize() > 0.0) {
            frame.addSlot("maxSize", new Double[]{validation.maxSize()});
        }
        if (!validation.allowedExtensions().isEmpty()) {
            frame.addSlot("allowedExtensions", new Object[]{validation.allowedExtensions()});
        }
        return frame;
    }

    private Frame frameOf(Dialog.Tab.Date date) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"date"});
        frame.addSlot("format", new String[]{date.format()});
        this.addCommon(frame, date);
        return frame;
    }

    private Frame frameOf(Dialog.Tab.DateTime dateTime) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"dateTime"});
        frame.addSlot("format", new String[]{dateTime.format()});
        this.addCommon(frame, dateTime);
        return frame;
    }

    private void addCommon(Frame frame, Dialog.Tab.Input input) {
        frame.addSlot("owner", new String[]{input.core$().owner().name()});
        if (input.name$() != null && !input.name$().isEmpty()) {
            frame.addSlot("name", new String[]{input.name$()});
        }
        frame.addSlot("label", new String[]{input.label()});
        frame.addSlot("readonly", new Boolean[]{input.isReadonly()});
        frame.addSlot("required", new Boolean[]{input.isRequired()});
        frame.addSlot("placeholder", new String[]{input.placeHolder()});
        frame.addSlot("defaultValue", new String[]{input.defaultValue()});
        if (input.i$(MultipleInput.class)) {
            MultipleInput multiple = input.asMultiple();
            frame.addSlot("multiple", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"multiple"}).addSlot("min", new Integer[]{multiple.min()}).addSlot("max", new Integer[]{multiple.max()})});
        }
        if (input.validator() != null && !input.validator().isEmpty()) {
            frame.addSlot("validator", new AbstractFrame[]{this.validator(input)});
        }
    }

    private Frame validator(Dialog.Tab.Input input) {
        return new Frame(new String[0]).addTypes(new String[]{"validator"}).addSlot("dialog", new String[]{((Dialog)input.core$().ownerAs(Dialog.class)).name$()}).addSlot("name", new String[]{input.validator()}).addSlot("type", new String[]{((Object)((Object)input)).getClass().getSimpleName()});
    }

    private Template template() {
        Template template = AbstractDialogTemplate.create();
        Formatters.customize(template);
        return template;
    }
}

