/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.schema;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.schema.SchemaTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.bool.BoolData;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.datetime.DateTimeData;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.integer.IntegerData;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.longinteger.LongIntegerData;
import io.intino.konos.model.graph.real.RealData;
import io.intino.konos.model.graph.text.TextData;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.konos.model.graph.word.WordData;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class SchemaRenderer {
    private final List<Schema> schemas;
    private File gen;
    private String rootPackage;
    private final Map<String, String> classes;

    public SchemaRenderer(KonosGraph graph, File gen, String rootPackage, Map<String, String> classes) {
        this.schemas = graph.core$().find(Schema.class).stream().filter(s -> !s.core$().owner().is(Schema.class)).collect(Collectors.toList());
        this.gen = gen;
        this.rootPackage = rootPackage;
        this.classes = classes;
    }

    public void execute() {
        this.schemas.forEach(this::processSchema);
    }

    private void processSchema(Schema schema) {
        Service service = (Service)schema.core$().ownerAs(Service.class);
        String subPackage = "schemas" + (service != null ? File.separator + service.name$().toLowerCase() : "");
        File packageFolder = new File(this.gen, subPackage);
        String packageName = subPackage.isEmpty() ? this.rootPackage : this.rootPackage + "." + subPackage.replace(File.separator, ".");
        Frame frame = this.createSchemaFrame(schema, packageName);
        this.classes.put(Schema.class.getSimpleName() + "#" + schema.name$(), subPackage.replace(File.separator, ".") + "." + schema.name$());
        Commons.writeFrame(packageFolder, schema.name$(), this.template().format((Object)new Frame(new String[]{"root"}).addSlot("root", new String[]{this.rootPackage}).addSlot("package", new String[]{packageName}).addSlot("schema", new AbstractFrame[]{frame})));
    }

    public Frame createSchemaFrame(Schema schema, String packageName) {
        return this.createSchemaFrame(schema, packageName, new HashSet<Schema>());
    }

    private Frame createSchemaFrame(Schema schema, String packageName, Set<Schema> processed) {
        Frame frame = new Frame(new String[]{"schema"}).addSlot("name", new String[]{schema.name$()}).addSlot("package", new String[]{packageName});
        if (schema.core$().owner().is(Schema.class)) {
            frame.addSlot("inner", new String[]{"static"});
        }
        frame.addSlot("attribute", (AbstractFrame[])this.processAttributes(schema.attributeList()));
        frame.addSlot("attribute", (AbstractFrame[])this.processSchemasAsAttribute(schema.schemaList()));
        if (schema.isExtensionOf()) {
            frame.addSlot("parent", new String[]{schema.asExtensionOf().parent().name$()});
        }
        if (schema.attributeMap() != null) {
            frame.addSlot("attribute", new AbstractFrame[]{SchemaRenderer.render(schema.attributeMap())});
        }
        SchemaRenderer.addReturningValueToAttributes(schema.name$(), frame.frames("attribute"));
        Frame[] innerSchemas = (Frame[])schema.schemaList().stream().filter(processed::add).map(s -> this.createSchemaFrame((Schema)((Object)s), packageName, processed)).toArray(Frame[]::new);
        if (innerSchemas.length > 0) {
            frame.addSlot("schema", (AbstractFrame[])innerSchemas);
        }
        return frame;
    }

    private Frame[] processAttributes(List<Schema.Attribute> attributes) {
        return (Frame[])attributes.stream().map(this::processAttribute).toArray(value -> new Frame[attributes.size()]);
    }

    private Frame[] processSchemasAsAttribute(List<Schema> schemas) {
        return (Frame[])schemas.stream().map(schema -> this.processSchemaAsAttribute((Schema)((Object)schema), schema.name$() + (schema.multiple() ? "List" : ""), schema.multiple())).toArray(value -> new Frame[schemas.size()]);
    }

    private Frame processAttribute(Schema.Attribute attribute) {
        if (attribute.isReal()) {
            return SchemaRenderer.processAttribute(attribute.asReal());
        }
        if (attribute.isInteger()) {
            return SchemaRenderer.processAttribute(attribute.asInteger());
        }
        if (attribute.isBool()) {
            return this.processAttribute(attribute.asBool());
        }
        if (attribute.isText()) {
            return this.processAttribute(attribute.asText());
        }
        if (attribute.isDateTime()) {
            return this.processAttribute(attribute.asDateTime());
        }
        if (attribute.isDate()) {
            return this.processAttribute(attribute.asDate());
        }
        if (attribute.isFile()) {
            return SchemaRenderer.processAttribute(attribute.asFile());
        }
        if (attribute.isLongInteger()) {
            return SchemaRenderer.processAttribute(attribute.asLongInteger());
        }
        if (attribute.isWord()) {
            return this.processAttribute(attribute.asWord());
        }
        if (attribute.isObject()) {
            return this.processSchemaAsAttribute(attribute.asObject().schema(), attribute.name$(), attribute.isList());
        }
        return null;
    }

    private static Frame processAttribute(RealData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", "double"}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{!SchemaRenderer.multiple(attribute) ? "double" : "java.lang.Double"}).addSlot("defaultValue", new Double[]{attribute.defaultValue()});
    }

    private static Frame processAttribute(IntegerData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()}).addSlot("defaultValue", new Integer[]{attribute.defaultValue()});
    }

    private static Frame processAttribute(LongIntegerData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()}).addSlot("defaultValue", new String[]{attribute.defaultValue() + "L"});
    }

    private static Frame processAttribute(FileData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()});
    }

    private Frame processAttribute(BoolData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()}).addSlot("defaultValue", new Boolean[]{attribute.defaultValue()});
    }

    private Frame processAttribute(TextData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()}).addSlot("defaultValue", new String[]{"\"" + attribute.defaultValue() + "\""});
    }

    private Frame processAttribute(DateTimeData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()});
    }

    private Frame processAttribute(DateData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()});
    }

    private Frame processAttribute(WordData attribute) {
        return new Frame(new String[0]).addTypes(new String[]{"primitive", SchemaRenderer.multiple(attribute) ? "multiple" : "single", attribute.type()}).addSlot("name", new String[]{((Schema.Attribute)attribute.a$(Schema.Attribute.class)).name$()}).addSlot("type", new String[]{attribute.type()});
    }

    private Frame processSchemaAsAttribute(Schema schema, String name, boolean multiple) {
        return new Frame(new String[0]).addTypes(new String[]{multiple ? "multiple" : "single", "member", schema.name$()}).addSlot("name", new String[]{name}).addSlot("type", new String[]{schema.name$()}).addSlot("package", new String[]{this.packageOf(schema)});
    }

    private String packageOf(Schema schema) {
        Service service = (Service)schema.core$().ownerAs(Service.class);
        String subPackage = "schemas" + (service != null ? File.separator + service.name$().toLowerCase() : "");
        return subPackage.isEmpty() ? this.rootPackage : this.rootPackage + "." + subPackage.replace(File.separator, ".");
    }

    private static Frame render(Schema.AttributeMap map) {
        return new Frame(new String[0]).addTypes(new String[]{"attributeMap"}).addSlot("name", new String[]{map.name$()});
    }

    private static void addReturningValueToAttributes(String elementName, Iterator<AbstractFrame> attributes) {
        while (attributes.hasNext()) {
            Frame next = (Frame)attributes.next();
            next.addSlot("element", new String[]{elementName});
        }
    }

    private static boolean multiple(TypeData attribute) {
        return attribute.i$(ListData.class);
    }

    private Template template() {
        Template template = Formatters.customize(SchemaTemplate.create());
        template.add("typeFormat", value -> {
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        });
        return template;
    }
}

