/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake.feeder;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.feeder.AbstractFeederTemplate;
import io.intino.konos.builder.codegeneration.datalake.feeder.FeederTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Sensor;
import io.intino.konos.model.graph.documentedition.DocumentEditionSensor;
import io.intino.konos.model.graph.documentsignature.DocumentSignatureSensor;
import io.intino.konos.model.graph.formedition.FormEditionSensor;
import io.intino.konos.model.graph.ness.NessClient;
import io.intino.konos.model.graph.poll.PollSensor;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class FeederRenderer {
    private final List<Feeder> feeders;
    private final File src;
    private final String packageName;
    private final String boxName;
    private final Map<String, String> classes;
    private final NessClient nessClient;
    private final File gen;
    private final String domain;

    public FeederRenderer(KonosGraph graph, File gen, File src, String packageName, String boxName, Map<String, String> classes) {
        this.nessClient = graph.nessClient(0);
        this.gen = gen;
        this.domain = this.nessClient.domain();
        this.feeders = this.nessClient.feederList();
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        for (Feeder feeder : this.feeders) {
            Frame frame = new Frame(new String[0]).addTypes(new String[]{"feeder"}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{feeder.name$()});
            for (Sensor sensor : feeder.sensorList()) {
                frame.addSlot("sensor", new AbstractFrame[]{this.frameOf(sensor, feeder.name$())});
            }
            frame.addSlot("eventType", (String[])feeder.eventTypes().stream().map(s -> this.composedType((Schema)((Object)s), feeder.subdomain())).toArray(String[]::new));
            frame.addSlot("domain", new String[]{this.fullDomain(feeder.subdomain())});
            String feederClassName = Commons.firstUpperCase(feeder.name$()) + "Feeder";
            this.classes.put(((Object)((Object)feeder)).getClass().getSimpleName() + "#" + feeder.name$(), "ness.feeders." + feederClassName);
            Commons.writeFrame(new File(this.gen, "ness/feeders"), "Abstract" + feederClassName, Formatters.customize(AbstractFeederTemplate.create()).format((Object)frame));
            if (this.alreadyRendered(new File(this.src, "ness/feeders"), feederClassName)) continue;
            Commons.writeFrame(new File(this.src, "ness/feeders"), feederClassName, Formatters.customize(FeederTemplate.create()).format((Object)frame));
        }
    }

    private Frame frameOf(Sensor sensor, String feeder) {
        return new Frame(new String[]{"sensor"}).addSlot("name", new String[]{sensor.name$()}).addSlot("feeder", new String[]{feeder}).addSlot("type", (String[])sensor.core$().conceptList().stream().map(c -> c.id().replaceAll("#.*", "")).toArray(String[]::new)).addSlot("parent", new AbstractFrame[]{this.parent(sensor)});
    }

    private Frame parent(Sensor sensor) {
        if (sensor.isPoll()) {
            return this.poll(sensor.asPoll());
        }
        if (sensor.isFormEdition()) {
            return this.formEdition(sensor.asFormEdition());
        }
        if (sensor.isDocumentEdition()) {
            return this.documentEdition(sensor.asDocumentEdition());
        }
        if (sensor.isDocumentSignature()) {
            return this.documentSignature(sensor.asDocumentSignature());
        }
        return new Frame(new String[0]);
    }

    private Frame poll(PollSensor sensor) {
        return new Frame(new String[]{"poll"}).addSlot("defaultOption", new String[]{sensor.defaultOption() == null ? "" : sensor.defaultOption()}).addSlot("eventMethod", (String[])((Feeder)sensor.core$().ownerAs(Feeder.class)).eventTypes().stream().map(Layer::name$).toArray(String[]::new)).addSlot("option", (AbstractFrame[])this.frameOf(sensor.optionList()));
    }

    private Frame[] frameOf(List<PollSensor.Option> options) {
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (PollSensor.Option option : options) {
            Frame frame = new Frame(new String[]{"option"}).addSlot("value", new String[]{option.value()}).addSlot("event", new String[]{option.event().name$()});
            if (!option.optionList().isEmpty()) {
                frame.addSlot("option", (AbstractFrame[])this.frameOf(option.optionList()));
            }
            frames.add(frame);
        }
        return frames.toArray(new Frame[0]);
    }

    private Frame formEdition(FormEditionSensor sensor) {
        return new Frame(new String[]{"formEdition"}).addSlot("path", new String[]{sensor.path()});
    }

    private Frame documentEdition(DocumentEditionSensor sensor) {
        return new Frame(new String[]{"documentEdition"}).addSlot("mode", new String[]{sensor.mode().name()});
    }

    private Frame documentSignature(DocumentSignatureSensor sensor) {
        return new Frame(new String[]{"documentSignature"}).addSlot("signType", new String[]{sensor.signType().name()}).addSlot("signFormat", new String[]{sensor.signFormat().name()});
    }

    private String composedType(Schema schema, String subdomain) {
        return this.fullDomain(subdomain) + schema.name$().toLowerCase();
    }

    private String fullDomain(String subdomain) {
        return (this.domain.isEmpty() ? "" : this.domain + ".") + (subdomain.isEmpty() ? "" : subdomain + ".");
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

