/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import io.intino.konos.builder.codegeneration.AbstractBoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.ParameterPublisher;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.jmx.JMXService;
import io.intino.konos.model.graph.ness.NessClient;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class AbstractBoxRenderer {
    private final File gen;
    private final String packageName;
    private final Module module;
    private final KonosGraph graph;
    private final Configuration configuration;
    private final String parent;
    private final boolean hasModel;
    private final Set<String> customParameters;

    AbstractBoxRenderer(KonosGraph graph, File gen, String packageName, Module module, String parent, boolean hasModel) {
        this.graph = graph;
        this.gen = gen;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.parent = parent;
        this.hasModel = hasModel;
        this.customParameters = new HashSet<String>();
    }

    public void execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"box"});
        String name = this.name();
        frame.addSlot("name", new String[]{name});
        frame.addSlot("package", new String[]{this.packageName});
        if (this.hasModel) {
            frame.addSlot("tara", new String[]{name});
        }
        this.parent(frame);
        this.services(frame, name);
        this.tasks(frame, name);
        this.dataLake(frame, name);
        Commons.writeFrame(this.gen, "AbstractBox", this.template().format((Object)frame));
        this.notifyNewParameters();
    }

    private void notifyNewParameters() {
        new ParameterPublisher((LegioConfiguration)this.configuration).publish(this.customParameters);
    }

    private void tasks(Frame frame, String name) {
        if (!this.graph.taskList().isEmpty()) {
            frame.addSlot("task", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"task"}).addSlot("configuration", new String[]{name})});
        }
    }

    private void dataLake(Frame root, String name) {
        if (!this.graph.nessClientList().isEmpty()) {
            NessClient client = this.graph.nessClientList().get(0);
            Frame datalake = new Frame(new String[0]).addTypes(new String[]{"dataLake"}).addSlot("mode", new String[]{this.graph.nessClient(0).mode().name()}).addSlot("name", new String[]{this.graph.nessClient(0).name$()}).addSlot("package", new String[]{this.packageName}).addSlot("configuration", new String[]{name});
            datalake.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(client.url()) ? "custom" : "standard"}).addSlot("value", new String[]{client.url()})});
            datalake.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(client.user()) ? "custom" : "standard"}).addSlot("value", new String[]{client.user()})});
            datalake.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(client.password()) ? "custom" : "standard"}).addSlot("value", new String[]{client.password()})});
            datalake.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(client.clientID()) ? "custom" : "standard"}).addSlot("value", new String[]{client.clientID()})});
            datalake.addSlot("feeder", (AbstractFrame[])client.feederList().stream().map(f -> this.frameOf((Feeder)((Object)f))).toArray(Frame[]::new));
            if (!this.graph.procedureList().isEmpty()) {
                datalake.addSlot("procedure", new AbstractFrame[]{new Frame(new String[0]).addSlot("package", new String[]{this.packageName}).addSlot("configuration", new String[]{name})});
            }
            if (this.hasModel) {
                datalake.addSlot("nessOperations", new AbstractFrame[]{new Frame(new String[0]).addSlot("package", new String[]{this.packageName}).addSlot("configuration", new String[]{name})});
            }
            root.addSlot("dataLake", new AbstractFrame[]{datalake});
        }
    }

    private Frame frameOf(Feeder feeder) {
        return new Frame(new String[]{"feeder"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{feeder.name$()}).addSlot("box", new String[]{this.name()});
    }

    private void services(Frame frame, String name) {
        Frame serviceFrame;
        if (!this.graph.jMSServiceList().isEmpty()) {
            frame.addSlot("jms", new String[]{""});
        }
        for (RESTService rESTService : this.graph.rESTServiceList()) {
            serviceFrame = new Frame(new String[0]).addTypes(new String[]{"service", "rest"}).addSlot("name", new String[]{rESTService.name$()}).addSlot("configuration", new String[]{name});
            serviceFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(rESTService.port()) ? "custom" : "standard"}).addSlot("value", new String[]{rESTService.port()})});
            frame.addSlot("service", new AbstractFrame[]{serviceFrame});
        }
        for (JMSService jMSService : this.graph.jMSServiceList()) {
            serviceFrame = new Frame(new String[0]).addTypes(new String[]{"service", "jms"}).addSlot("name", new String[]{jMSService.name$()}).addSlot("configuration", new String[]{name});
            serviceFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(jMSService.user()) ? "custom" : "standard"}).addSlot("value", new String[]{jMSService.user()})});
            serviceFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(jMSService.password()) ? "custom" : "standard"}).addSlot("value", new String[]{jMSService.password()})});
            serviceFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(jMSService.url()) ? "custom" : "standard"}).addSlot("value", new String[]{jMSService.url()})});
            frame.addSlot("service", new AbstractFrame[]{serviceFrame});
        }
        for (JMXService jMXService : this.graph.jMXServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"service", "jmx"}).addSlot("name", new String[]{jMXService.name$()}).addSlot("configuration", new String[]{name})});
        }
        for (SlackBotService slackBotService : this.graph.slackBotServiceList()) {
            Frame slackFrame = new Frame(new String[0]).addTypes(new String[]{"service", "slack"}).addSlot("name", new String[]{slackBotService.name$()}).addSlot("configuration", new String[]{name});
            slackFrame.addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(slackBotService.token()) ? "custom" : "standard"}).addSlot("value", new String[]{slackBotService.token()})});
            frame.addSlot("service", new AbstractFrame[]{slackFrame});
        }
        if (!this.graph.rESTServiceList().isEmpty() || !this.graph.uIServiceList().isEmpty()) {
            frame.addSlot("spark", new String[]{"stop"});
        }
        if (!this.graph.uIServiceList().isEmpty()) {
            Frame uiFrame = new Frame(new String[0]);
            if (this.parent != null) {
                uiFrame.addSlot("parent", new String[]{this.parent});
            }
            frame.addSlot("hasUi", new AbstractFrame[]{uiFrame});
            frame.addSlot("uiAuthentication", new AbstractFrame[]{uiFrame});
            frame.addSlot("uiEdition", new AbstractFrame[]{uiFrame});
            frame.addSlot("service", (AbstractFrame[])this.graph.uIServiceList().stream().map(s -> this.uiServiceFrame((UIService)((Object)((Object)s)), name)).toArray(Frame[]::new));
        }
    }

    private Frame uiServiceFrame(UIService service, String name) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"service", "ui"}).addSlot("name", new String[]{service.name$()}).addSlot("configuration", new String[]{name}).addSlot("parameter", new AbstractFrame[]{new Frame(new String[]{this.isCustom(service.port()) ? "custom" : "standard"}).addSlot("value", new String[]{service.port()})});
        if (service.authentication() != null) {
            frame.addSlot("authentication", new AbstractFrame[]{new Frame(new String[]{this.isCustom(service.authentication().by()) ? "custom" : "standard"}).addSlot("value", new String[]{service.authentication().by()})});
        }
        if (service.edition() != null) {
            frame.addSlot("edition", new AbstractFrame[]{new Frame(new String[]{this.isCustom(service.edition().by()) ? "custom" : "standard"}).addSlot("value", new String[]{service.edition().by()})});
        }
        return frame;
    }

    private boolean isCustom(String value) {
        boolean custom;
        boolean bl = custom = value != null && value.startsWith("{");
        if (custom) {
            this.customParameters.add(value.substring(1, value.length() - 1));
        }
        return custom;
    }

    private void parent(Frame frame) {
        if (this.parent != null && this.configuration != null && !Configuration.Level.Platform.equals((Object)this.configuration.level())) {
            frame.addSlot("parent", new String[]{this.parent}).addSlot("hasParent", new String[]{""});
        } else {
            frame.addSlot("hasntParent", new String[]{""});
        }
    }

    private String name() {
        if (this.module != null) {
            String dsl = this.configuration.outDSL();
            if (dsl == null || dsl.isEmpty()) {
                return this.module.getName();
            }
            return dsl;
        }
        return "System";
    }

    private Template template() {
        return Formatters.customize(AbstractBoxTemplate.create());
    }
}

