/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import com.intellij.openapi.project.Project;
import cottons.utils.MimeTypes;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.action.RESTActionRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RestResourceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.rest.RESTService;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class RESTResourceRenderer {
    private static final String RESOURCES = "resources";
    private final Project project;
    private final List<RESTService> services;
    private File gen;
    private File src;
    private String packageName;
    private final String boxName;
    private final Map<String, String> classes;

    public RESTResourceRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName, Map<String, String> classes) {
        this.project = project;
        this.services = graph.rESTServiceList();
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        this.services.forEach(this::processService);
    }

    private void processService(RESTService service) {
        service.core$().findNode(RESTService.Resource.class).forEach(this::processResource);
    }

    private void processResource(RESTService.Resource resource) {
        for (RESTService.Resource.Operation operation : resource.operationList()) {
            Frame frame = this.fillResourceFrame(resource, operation);
            String className = StringHelper.snakeCaseToCamelCase((String)(((Object)((Object)operation)).getClass().getSimpleName() + "_" + resource.name$())) + "Resource";
            Commons.writeFrame(new File(this.gen, RESOURCES), className, this.template().format((Object)frame));
            this.createCorrespondingAction(operation);
        }
    }

    private void createCorrespondingAction(RESTService.Resource.Operation operation) {
        new RESTActionRenderer(this.project, operation, this.src, this.packageName, this.boxName, this.classes).execute();
    }

    private Frame fillResourceFrame(RESTService.Resource resource, RESTService.Resource.Operation operation) {
        RESTService.AuthenticatedWithToken authenticated;
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"resource"});
        frame.addSlot("name", new String[]{resource.name$()});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("operation", new String[]{((Object)((Object)operation)).getClass().getSimpleName()});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("throws", this.throwCodes(operation));
        if (this.hasResponse(operation)) {
            frame.addSlot("returnType", new AbstractFrame[]{this.frameOf(operation.response())});
        }
        frame.addSlot("parameter", (AbstractFrame[])this.parameters(operation.parameterList()));
        if (!resource.graph().schemaList().isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        if ((authenticated = ((RESTService)resource.core$().ownerAs(RESTService.class)).authenticatedWithToken()) != null) {
            frame.addSlot("authenticationValidator", new AbstractFrame[]{new Frame(new String[]{"authenticationValidator"}).addSlot("type", new String[]{"Basic"})});
        }
        return frame;
    }

    private boolean hasResponse(RESTService.Resource.Operation operation) {
        return operation.response() != null && operation.response().isType();
    }

    private Frame frameOf(Response response) {
        Frame frame = new Frame(new String[0]).addSlot("value", new String[]{Commons.returnType(response, this.packageName)});
        if (response.isText() && response.dataFormat() != Response.DataFormat.html) {
            frame.addSlot("format", new String[]{MimeTypes.get((String)response.dataFormat().toString())});
        }
        return frame;
    }

    private String[] throwCodes(RESTService.Resource.Operation resource) {
        String[] stringArray;
        RESTService.AuthenticatedWithToken authenticated = ((RESTService)resource.core$().ownerAs(RESTService.class)).authenticatedWithToken();
        List<String> throwCodes = resource.exceptionList().stream().map(r -> r.code().toString()).collect(Collectors.toList());
        if (authenticated != null) {
            throwCodes.add("Unauthorized");
        }
        if (throwCodes.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Unknown";
        } else {
            stringArray = throwCodes.toArray(new String[0]);
        }
        return stringArray;
    }

    private Frame[] parameters(List<RESTService.Resource.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(RESTService.Resource.Parameter parameter) {
        Frame parameterFrame = new Frame(new String[0]).addTypes(new String[]{"parameter", parameter.in().toString(), ((Object)((Object)parameter.asType())).getClass().getSimpleName(), parameter.isRequired() ? "required" : "optional"});
        if (parameter.isList()) {
            parameterFrame.addTypes(new String[]{"List"});
        }
        return parameterFrame.addSlot("name", new String[]{parameter.name$()}).addSlot("parameterType", new AbstractFrame[]{this.parameterType(parameter)}).addSlot("in", new String[]{parameter.in().name()});
    }

    private Frame parameterType(RESTService.Resource.Parameter parameter) {
        String innerPackage = parameter.isObject() && parameter.asObject().isComponent() ? String.join((CharSequence)".", this.packageName, "schemas.") : "";
        Frame frame = new Frame(new String[0]).addSlot("value", new String[]{innerPackage + parameter.asType().type()});
        if (parameter.i$(ListData.class)) {
            frame.addTypes(new String[]{"list"});
        }
        return frame;
    }

    private Template template() {
        return Formatters.customize(RestResourceTemplate.create());
    }
}

