/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.catalog;

import com.intellij.openapi.project.Project;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.DisplayRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.catalog.AbstractCatalogTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.catalog.CatalogTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.catalog.CatalogUpdater;
import io.intino.konos.builder.codegeneration.services.ui.display.toolbar.OperationRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.view.ViewRenderer;
import io.intino.konos.model.graph.AbstractToolbar;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.TemporalCatalog;
import io.intino.konos.model.graph.Toolbar;
import io.intino.konos.model.graph.View;
import java.io.File;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class CatalogRenderer
extends DisplayRenderer {
    private final Project project;
    private final String itemClass;

    public CatalogRenderer(Project project, Catalog catalog, String packageName, String box) {
        super(catalog, box, packageName);
        this.project = project;
        this.itemClass = catalog.itemClass();
    }

    @Override
    public Frame buildFrame() {
        Catalog catalog = (Catalog)this.display().a$(Catalog.class);
        Frame frame = super.buildFrame().addTypes(new String[]{"catalog"}).addSlot("type", new String[]{this.itemClass});
        if (catalog.i$(TemporalCatalog.class)) {
            TemporalCatalog temporalCatalog = (TemporalCatalog)catalog.a$(TemporalCatalog.class);
            frame.addSlot("mode", new String[]{temporalCatalog.type().name()});
            frame.addSlot("scale", temporalCatalog.scales().stream().map(Enum::name).toArray());
            frame.addSlot("range", new AbstractFrame[]{new Frame(new String[0]).addSlot("catalog", new String[]{catalog.name$()}).addSlot("box", new String[]{this.box}).addSlot("type", new String[]{this.itemClass})});
            if (temporalCatalog.temporalFilter() != null) {
                frame.addSlot("temporalFilter", new AbstractFrame[]{this.frameOf(temporalCatalog, temporalCatalog.temporalFilter())});
            }
        }
        if (catalog.label() != null) {
            frame.addSlot("label", new String[]{catalog.label()});
        }
        if (catalog.events() != null) {
            frame.addSlot("event", new AbstractFrame[]{this.frameOf(catalog.events().onClickItem())});
        }
        if (catalog.toolbar() != null) {
            frame.addSlot("toolbar", new AbstractFrame[]{this.frameOf(catalog.toolbar())});
        }
        if (catalog.hasCustomItemsArrivalMessage()) {
            frame.addSlot("hasCustomItemsArrivalMessage", new AbstractFrame[]{this.baseFrame()});
        }
        this.views(catalog, frame);
        this.arrangements(catalog, frame);
        return frame;
    }

    private Frame frameOf(TemporalCatalog catalog, TemporalCatalog.TemporalFilter filter) {
        Frame frame = new Frame(new String[0]);
        frame.addSlot("temporalFilterLayout", new String[]{filter.layout().toString()});
        Frame enabledFrame = new Frame(new String[0]);
        if (filter.enabled() == TemporalCatalog.TemporalFilter.Enabled.Conditional) {
            enabledFrame.addSlot("catalog", new String[]{catalog.name$()});
        }
        frame.addSlot("temporalFilterEnabled", new AbstractFrame[]{enabledFrame.addSlot(filter.enabled().toString(), new String[]{filter.enabled().toString()})});
        Frame visibleFrame = new Frame(new String[0]);
        if (filter.visible() == TemporalCatalog.TemporalFilter.Visible.Conditional) {
            visibleFrame.addSlot("catalog", new String[]{catalog.name$()});
        }
        frame.addSlot("temporalFilterVisible", new AbstractFrame[]{visibleFrame.addSlot(filter.visible().toString(), new String[]{filter.visible().toString()})});
        return frame;
    }

    private Frame frameOf(Catalog.Events.OnClickItem onClickItem) {
        Catalog.Events.OnClickItem.CatalogEvent catalogEvent = onClickItem.catalogEvent();
        Display display = this.display();
        if (catalogEvent.i$(Catalog.Events.OnClickItem.OpenPanel.class)) {
            return CatalogRenderer.frameOf((Catalog.Events.OnClickItem.OpenPanel)catalogEvent.a$(Catalog.Events.OnClickItem.OpenPanel.class), (Catalog)display.a$(Catalog.class), this.box, this.itemClass);
        }
        if (catalogEvent.i$(Catalog.Events.OnClickItem.OpenCatalog.class)) {
            return CatalogRenderer.frameOf((Catalog.Events.OnClickItem.OpenCatalog)catalogEvent.a$(Catalog.Events.OnClickItem.OpenCatalog.class), (Catalog)display.a$(Catalog.class), this.box, this.itemClass);
        }
        return CatalogRenderer.frameOf((Catalog.Events.OnClickItem.OpenDialog)catalogEvent.a$(Catalog.Events.OnClickItem.OpenDialog.class), display).addSlot("box", new String[]{this.box}).addSlot("package", new String[]{this.packageName});
    }

    public static Frame frameOf(Catalog.Events.OnClickItem.OpenDialog openDialog, Display catalog) {
        Frame frame = new Frame(new String[]{"event", ((Object)((Object)openDialog)).getClass().getSimpleName()});
        if (openDialog.height() >= 0) {
            frame.addSlot("height", new Integer[]{openDialog.height()});
        }
        if (openDialog.width() >= 0) {
            frame.addSlot("width", new Integer[]{openDialog.width()});
        }
        frame.addSlot("dialog", new String[]{openDialog.dialog().name$()});
        frame.addSlot("catalog", new String[]{catalog.name$()});
        return frame;
    }

    public static Frame frameOf(Catalog.Events.OnClickItem.OpenPanel openPanel, Catalog catalog, String box, String modelClass) {
        Frame frame = new Frame(new String[]{"event", ((Object)((Object)openPanel)).getClass().getSimpleName()});
        frame.addSlot("panel", new String[]{openPanel.panel().name$()});
        if (openPanel.hasBreadcrumbs()) {
            frame.addSlot("breadcrumbs", new AbstractFrame[]{new Frame(new String[]{"breadCrumbs"}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("box", new String[]{box}).addSlot("type", new String[]{modelClass})});
        }
        return frame;
    }

    public static Frame frameOf(Catalog.Events.OnClickItem.OpenCatalog openCatalog, Catalog catalog, String box, String modelClass) {
        Frame frame = new Frame(new String[]{"event", ((Object)((Object)openCatalog)).getClass().getSimpleName()});
        frame.addSlot("catalog", new String[]{openCatalog.catalog().name$()});
        if (openCatalog.openItem()) {
            frame.addSlot("openCatalogLoader", new AbstractFrame[]{new Frame(new String[]{"openCatalogLoader"}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("box", new String[]{box}).addSlot("type", new String[]{modelClass})});
        }
        if (openCatalog.filtered()) {
            frame.addSlot("openCatalogFilter", new AbstractFrame[]{new Frame(new String[]{"openCatalogFilter"}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("box", new String[]{box}).addSlot("type", new String[]{modelClass})});
        }
        return frame;
    }

    private void views(Catalog catalog, Frame frame) {
        if (catalog.views().viewList().stream().anyMatch(View::isMagazineContainer)) {
            Frame hasMagazineFrame = this.baseFrame().addSlot("type", new String[]{catalog.itemClass()});
            if (catalog.i$(TemporalCatalog.class)) {
                TemporalCatalog temporalCatalog = (TemporalCatalog)catalog.a$(TemporalCatalog.class);
                hasMagazineFrame.addSlot("mode", new String[]{temporalCatalog.type().name()});
                hasMagazineFrame.addSlot("scale", temporalCatalog.scales().stream().map(Enum::name).toArray());
            }
            frame.addSlot("hasMagazineView", new AbstractFrame[]{hasMagazineFrame});
        }
        catalog.views().viewList().forEach(view -> {
            ViewRenderer builder = new ViewRenderer((View)((Object)view), this.display(), this.box, this.packageName);
            frame.addSlot("view", new AbstractFrame[]{new Frame(new String[0]).addSlot("value", new AbstractFrame[]{builder.buildFrame()})});
        });
    }

    private void arrangements(Catalog catalog, Frame frame) {
        boolean existsGroupings;
        Catalog.Content content = catalog.content();
        boolean bl = existsGroupings = content != null && !content.groupingList().isEmpty();
        if (existsGroupings) {
            frame.addSlot("hasGroupings", new AbstractFrame[]{this.baseFrame().addSlot("histogramsMode", new String[]{content.histograms().toString()})});
        }
        if (content == null) {
            return;
        }
        content.groupingList().forEach(grouping -> frame.addSlot("arrangement", new AbstractFrame[]{CatalogRenderer.frameOf(grouping, catalog, this.box, this.itemClass)}));
        content.sortingList().forEach(sorting -> frame.addSlot("arrangement", new AbstractFrame[]{CatalogRenderer.frameOf(sorting, catalog, this.box, this.itemClass)}));
    }

    private Frame baseFrame() {
        return new Frame(new String[0]).addSlot("box", new String[]{this.box}).addSlot("name", new String[]{this.display().name$()});
    }

    public static Frame frameOf(Catalog.Content.Sorting sorting, Catalog catalog, String box, String modelClass) {
        return new Frame(new String[]{"arrangement", ((Object)((Object)sorting)).getClass().getSimpleName().toLowerCase()}).addSlot("box", new String[]{box}).addSlot("name", new String[]{sorting.name$()}).addSlot("label", new String[]{sorting.label()}).addSlot("visible", new Boolean[]{sorting.visible()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("type", new String[]{modelClass});
    }

    public static Frame frameOf(Catalog.Content.Grouping grouping, Catalog catalog, String box, String modelClass) {
        return new Frame(new String[]{"arrangement", ((Object)((Object)grouping)).getClass().getSimpleName().toLowerCase()}).addSlot("box", new String[]{box}).addSlot("name", new String[]{grouping.name$()}).addSlot("label", new String[]{grouping.label()}).addSlot("catalog", new String[]{catalog.name$()}).addSlot("type", new String[]{modelClass}).addSlot("histogram", new Object[]{grouping.histogram()});
    }

    private Frame frameOf(Toolbar toolbar) {
        Frame frame = new Frame(new String[]{"toolbar"});
        frame.addSlot("box", new String[]{this.box}).addSlot("type", new String[]{this.itemClass}).addSlot("canSearch", new Boolean[]{toolbar.canSearch()});
        toolbar.operations().forEach(operation -> {
            OperationRenderer builder = new OperationRenderer((AbstractToolbar.Operation)((Object)operation), this.display(), this.box, this.packageName);
            frame.addSlot("operation", new AbstractFrame[]{builder.buildFrame()});
        });
        return frame;
    }

    @Override
    protected Template srcTemplate() {
        return Formatters.customize(CatalogTemplate.create());
    }

    @Override
    protected Template genTemplate() {
        return Formatters.customize(AbstractCatalogTemplate.create());
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return new CatalogUpdater(sourceFile, (Catalog)this.display().a$(Catalog.class), this.project, this.packageName, this.box);
    }
}

