/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.slack;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.slack.SlackTemplate;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import java.io.File;
import java.util.List;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

class BotActionsUpdater {
    private final Project project;
    private final List<? extends SlackBotService.Request> requests;
    private final PsiElementFactory factory;
    private final String boxName;
    private PsiFile file;

    BotActionsUpdater(Project project, File destination, List<? extends SlackBotService.Request> requests, String boxName) {
        this.project = project;
        this.requests = requests;
        this.factory = JavaPsiFacade.getElementFactory((Project)project);
        this.boxName = boxName;
        VirtualFile vFile = VfsUtil.findFileByIoFile((File)destination, (boolean)true);
        if (vFile != null) {
            this.file = PsiManager.getInstance((Project)project).findFile(vFile);
        }
    }

    void update() {
        if (this.file == null || !(this.file instanceof PsiJavaFile) || ((PsiJavaFile)this.file).getClasses()[0] == null) {
            return;
        }
        PsiJavaFile javaFile = (PsiJavaFile)this.file;
        PsiClass psiClass = javaFile.getClasses()[0];
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> this.update(psiClass));
        } else {
            this.update(psiClass);
        }
    }

    private void update(PsiClass psiClass) {
        for (SlackBotService.Request request : this.requests) {
            PsiMethod psiMethod = this.methodOf(request, psiClass);
            if (psiMethod != null) {
                this.updateMethod(psiMethod, request);
                continue;
            }
            this.addMethod(psiClass, request);
        }
    }

    private void addMethod(PsiClass psiClass, SlackBotService.Request request) {
        String methodText = Formatters.customize(SlackTemplate.create()).format((Object)this.createRequestFrame((SlackBotService)request.core$().ownerAs(SlackBotService.class), request));
        psiClass.addAfter((PsiElement)this.factory.createMethodFromText(methodText, (PsiElement)psiClass), this.anchor(psiClass));
    }

    private PsiElement anchor(PsiClass psiClass) {
        if (psiClass.getMethods().length == 0) {
            return psiClass.getLBrace();
        }
        PsiMethod returnMethod = null;
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (psiMethod.getModifierList().hasExplicitModifier("private") && returnMethod != null) {
                return returnMethod;
            }
            if (psiMethod.getModifierList().hasExplicitModifier("private")) continue;
            returnMethod = psiMethod;
        }
        return psiClass.getMethods()[psiClass.getMethods().length - 1];
    }

    private Frame createRequestFrame(SlackBotService service, SlackBotService.Request request) {
        Frame requestFrame = new Frame(new String[0]).addTypes(new String[]{"request", "newMethod"}).addSlot("bot", new String[]{service.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{request.name$()}).addSlot("description", new String[]{request.description()});
        List<SlackBotService.Request.Parameter> parameters = request.parameterList();
        for (int i = 0; i < parameters.size(); ++i) {
            Frame frame = new Frame(new String[0]).addTypes(new String[]{"parameter", parameters.get(i).type().name()}).addSlot("type", new String[]{parameters.get(i).type().name()}).addSlot("name", new String[]{parameters.get(i).name$()}).addSlot("pos", new Integer[]{i});
            if (parameters.get(i).multiple()) {
                frame.addTypes(new String[]{"multiple"});
            }
            requestFrame.addSlot("parameter", new AbstractFrame[]{frame});
        }
        return requestFrame;
    }

    private PsiMethod methodOf(SlackBotService.Request request, PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (!psiMethod.getName().equals(this.nameOf(request))) continue;
            return psiMethod;
        }
        return null;
    }

    private void updateMethod(PsiMethod psiMethod, SlackBotService.Request request) {
        for (SlackBotService.Request.Parameter parameter : request.parameterList()) {
            PsiParameter psiParameter = this.parameter(psiMethod, parameter.name$());
            if (psiParameter != null) {
                String presentableText = psiParameter.getTypeElement().getType().getPresentableText();
                if (presentableText.equals(parameter.type().name() + (parameter.multiple() ? "[]" : "")) || presentableText.equals(parameter.type().name() + (parameter.multiple() ? "..." : ""))) continue;
                psiParameter.replace((PsiElement)this.factory.createParameter(parameter.name$(), this.factory.createTypeFromText("java.lang." + parameter.type().name(), (PsiElement)psiMethod)));
                continue;
            }
            psiMethod.getParameterList().add((PsiElement)this.factory.createParameter(parameter.name$(), this.factory.createTypeFromText("java.lang." + parameter.type().name(), (PsiElement)psiMethod)));
        }
    }

    private String nameOf(SlackBotService.Request request) {
        return Formatters.firstLowerCase(Formatters.snakeCaseToCamelCase().format((Object)request.name$()).toString());
    }

    private PsiParameter parameter(PsiMethod method, String name) {
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!name.equals(parameter.getName())) continue;
            return parameter;
        }
        return null;
    }
}

