/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayNotifierTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayRequesterTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.DisplayUpdater;
import io.intino.konos.builder.codegeneration.services.ui.display.catalog.CatalogRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.desktop.DesktopRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.editor.EditorRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.mold.MoldRenderer;
import io.intino.konos.builder.codegeneration.services.ui.display.panel.PanelRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.Editor;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.Panel;
import io.intino.konos.model.graph.TemporalCatalog;
import io.intino.konos.model.graph.desktop.DesktopPanel;
import io.intino.tara.magritte.Layer;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class DisplayRenderer {
    private static final String DISPLAYS = "displays";
    private static final String NOTIFIERS = "notifiers";
    private static final String REQUESTERS = "requesters";
    private final Project project;
    private final File gen;
    private final File src;
    private final String packageName;
    private final List<Display> displays;
    private final String boxName;
    private final Map<String, String> classes;
    private final String parent;

    public DisplayRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String parent, String boxName, Map<String, String> classes) {
        this.project = project;
        this.gen = gen;
        this.src = src;
        this.packageName = packageName;
        this.parent = parent;
        this.displays = graph.displayList();
        this.boxName = boxName;
        this.classes = classes;
    }

    public void execute() {
        this.displays.forEach(this::processDisplay);
    }

    private void processDisplay(Display display) {
        if (display == null) {
            return;
        }
        Frame frame = this.createFrame(display);
        this.writeNotifier(display, frame);
        this.writeRequester(display, frame);
        if (((Object)((Object)display)).getClass().getSimpleName().equals(Display.class.getSimpleName())) {
            this.writeDisplay(display, frame);
        } else {
            this.processPrototype(display);
        }
    }

    private void processPrototype(Display display) {
        this.classes.put(((Object)((Object)display)).getClass().getSimpleName() + "#" + display.name$(), "displays." + StringHelper.snakeCaseToCamelCase((String)display.name$()));
        if (display.i$(Editor.class)) {
            new EditorRenderer(this.project, (Editor)display.a$(Editor.class), this.packageName, this.boxName).write(this.src, this.gen);
        } else if (display.i$(Catalog.class)) {
            new CatalogRenderer(this.project, (Catalog)display.a$(Catalog.class), this.packageName, this.boxName).write(this.src, this.gen);
        } else if (display.i$(Panel.class)) {
            Panel panel = (Panel)display.a$(Panel.class);
            if (panel.isDesktop()) {
                DesktopPanel desktop = ((Panel)display.a$(Panel.class)).asDesktop();
                new DesktopRenderer(this.project, desktop, this.packageName, this.boxName).write(this.src, this.gen);
            } else {
                new PanelRenderer(this.project, (Panel)display.a$(Panel.class), this.packageName, this.boxName).write(this.src, this.gen);
            }
        } else if (display.i$(Mold.class)) {
            new MoldRenderer(this.project, (Mold)display.a$(Mold.class), this.packageName, this.boxName).write(this.src, this.gen);
        }
    }

    private void writeDisplay(Display display, Frame frame) {
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)display.name$());
        this.classes.put("Display#" + display.name$(), "displays." + newDisplay);
        if (!Commons.javaFile(new File(this.src, DISPLAYS), newDisplay).exists()) {
            Commons.writeFrame(new File(this.src, DISPLAYS), newDisplay, this.displayTemplate().format((Object)frame));
        } else {
            new DisplayUpdater(this.project, display, Commons.javaFile(new File(this.src, DISPLAYS), newDisplay), this.packageName).update();
        }
    }

    private void writeRequester(Display display, Frame frame) {
        Commons.writeFrame(new File(this.gen, DISPLAYS + File.separator + REQUESTERS), StringHelper.snakeCaseToCamelCase((String)(display.name$() + "Requester")), this.displayRequesterTemplate().format((Object)frame));
    }

    private void writeNotifier(Display display, Frame frame) {
        Commons.writeFrame(new File(this.gen, DISPLAYS + File.separator + NOTIFIERS), StringHelper.snakeCaseToCamelCase((String)(display.name$() + "Notifier")), this.displayNotifierTemplate().format((Object)frame));
    }

    @NotNull
    private Frame createFrame(Display display) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"display"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{display.name$()});
        frame.addSlot("type", new String[]{this.typeOf(display)});
        frame.addSlot("innerDisplay", (String[])display.displays().stream().map(Layer::name$).toArray(String[]::new));
        if (display.parentDisplay() != null) {
            this.addParent(display, frame);
        }
        if (!display.graph().schemaList().isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        frame.addSlot("notification", (AbstractFrame[])this.framesOfNotifications(display.notificationList()));
        frame.addSlot("request", (AbstractFrame[])this.framesOfRequests(display.requestList()));
        frame.addSlot("box", new String[]{this.boxName});
        Frame frame2 = frame;
        if (frame2 == null) {
            DisplayRenderer.$$$reportNull$$$0(0);
        }
        return frame2;
    }

    private String typeOf(Display display) {
        String type = ((Object)((Object)display)).getClass().getSimpleName().toLowerCase();
        if (display.i$(DesktopPanel.class)) {
            return "desktop";
        }
        if (type.equalsIgnoreCase("temporalCatalog")) {
            return "temporal" + ((TemporalCatalog)display.a$(TemporalCatalog.class)).type().name() + "Catalog";
        }
        return type;
    }

    private void addParent(Display display, Frame frame) {
        Frame parent = new Frame(new String[0]).addSlot("value", new String[]{display.parentDisplay()}).addSlot("dsl", new String[]{this.parent}).addSlot("package", new String[]{this.parent.substring(0, this.parent.lastIndexOf("."))});
        frame.addSlot("parent", new AbstractFrame[]{parent});
    }

    private Frame[] framesOfNotifications(List<Display.Notification> notifications) {
        return (Frame[])notifications.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(Display.Notification notification) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"notification"});
        frame.addSlot("name", new String[]{notification.name$()});
        frame.addSlot("target", new String[]{notification.to().name()});
        if (notification.isType()) {
            Frame parameterFrame = new Frame(new String[0]).addTypes(new String[]{"parameter", notification.asType().type(), ((Object)((Object)notification.asType())).getClass().getSimpleName().replace("Data", "")}).addSlot("value", new String[]{notification.asType().type()});
            if (notification.isList()) {
                parameterFrame.addTypes(new String[]{"list"});
            }
            frame.addSlot("parameter", new AbstractFrame[]{parameterFrame});
        }
        return frame;
    }

    private Frame[] framesOfRequests(List<Display.Request> requests) {
        return (Frame[])requests.stream().map(r -> DisplayRenderer.frameOf(r, this.packageName)).toArray(Frame[]::new);
    }

    static Frame frameOf(Display.Request request, String packageName) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"request"});
        if (request.responseType().equals((Object)Display.Request.ResponseType.Asset)) {
            frame.addTypes(new String[]{"asset"});
        }
        frame.addSlot("name", new String[]{request.name$()});
        if (request.isType()) {
            Frame parameterFrame = new Frame(new String[0]).addTypes(new String[]{"parameter", request.asType().type(), ((Object)((Object)request.asType())).getClass().getSimpleName().replace("Data", "")}).addSlot("value", new String[]{DisplayRenderer.parameter(request, packageName)});
            if (request.isList()) {
                parameterFrame.addTypes(new String[]{"list"});
            }
            frame.addSlot("parameter", new AbstractFrame[]{parameterFrame});
        }
        return frame;
    }

    private static String parameter(Display.Request request, String packageName) {
        return request.isObject() ? packageName.toLowerCase() + ".schemas." + request.asType().type() : request.asType().type();
    }

    private Template displayNotifierTemplate() {
        Template template = DisplayNotifierTemplate.create();
        this.addFormats(template);
        return template;
    }

    private Template displayTemplate() {
        Template template = DisplayTemplate.create();
        this.addFormats(template);
        return template;
    }

    private Template displayRequesterTemplate() {
        Template template = DisplayRequesterTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/intino/konos/builder/codegeneration/services/ui/display/DisplayRenderer", "createFrame"));
    }
}

