/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.bool.BoolData;
import io.intino.konos.model.graph.date.DateData;
import io.intino.konos.model.graph.datetime.DateTimeData;
import io.intino.konos.model.graph.extensionof.ExtensionOfSchema;
import io.intino.konos.model.graph.file.FileData;
import io.intino.konos.model.graph.integer.IntegerData;
import io.intino.konos.model.graph.list.ListData;
import io.intino.konos.model.graph.longinteger.LongIntegerData;
import io.intino.konos.model.graph.object.ObjectData;
import io.intino.konos.model.graph.real.RealData;
import io.intino.konos.model.graph.text.TextData;
import io.intino.konos.model.graph.type.TypeData;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Schema
extends Layer
implements Terminal {
    protected boolean isRequired;
    protected boolean multiple;
    protected AttributeMap attributeMap;
    protected List<Attribute> attributeList = new ArrayList<Attribute>();
    protected List<Has> hasList = new ArrayList<Has>();
    protected List<Schema> schemaList = new ArrayList<Schema>();

    public Schema(Node node) {
        super(node);
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean multiple() {
        return this.multiple;
    }

    public Schema isRequired(boolean value) {
        this.isRequired = value;
        return this;
    }

    public Schema multiple(boolean value) {
        this.multiple = value;
        return this;
    }

    public AttributeMap attributeMap() {
        return this.attributeMap;
    }

    public List<Attribute> attributeList() {
        return Collections.unmodifiableList(this.attributeList);
    }

    public Attribute attribute(int index) {
        return this.attributeList.get(index);
    }

    public List<Attribute> attributeList(Predicate<Attribute> predicate) {
        return this.attributeList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Has> hasList() {
        return Collections.unmodifiableList(this.hasList);
    }

    public Has has(int index) {
        return this.hasList.get(index);
    }

    public List<Has> hasList(Predicate<Has> predicate) {
        return this.hasList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Schema> schemaList() {
        return Collections.unmodifiableList(this.schemaList);
    }

    public Schema schema(int index) {
        return this.schemaList.get(index);
    }

    public List<Schema> schemaList(Predicate<Schema> predicate) {
        return this.schemaList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Schema attributeMap(AttributeMap value) {
        this.attributeMap = value;
        return this;
    }

    public ExtensionOfSchema asExtensionOf() {
        return (ExtensionOfSchema)this.a$(ExtensionOfSchema.class);
    }

    public ExtensionOfSchema asExtensionOf(Schema parent) {
        ExtensionOfSchema newElement = (ExtensionOfSchema)this.core$().addFacet(ExtensionOfSchema.class);
        newElement.core$().set((Layer)newElement, "parent", Collections.singletonList(parent));
        return newElement;
    }

    public boolean isExtensionOf() {
        return this.core$().is(ExtensionOfSchema.class);
    }

    public void removeExtensionOf() {
        this.core$().removeFacet(ExtensionOfSchema.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.attributeMap != null) {
            components.add(this.attributeMap.core$());
        }
        new ArrayList<Attribute>(this.attributeList).forEach(c -> components.add(c.core$()));
        new ArrayList<Has>(this.hasList).forEach(c -> components.add(c.core$()));
        new ArrayList<Schema>(this.schemaList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("isRequired", new ArrayList<Boolean>(Collections.singletonList(this.isRequired)));
        map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Schema$AttributeMap")) {
            this.attributeMap = (AttributeMap)node.as(AttributeMap.class);
        }
        if (node.is("Schema$Attribute")) {
            this.attributeList.add((Attribute)node.as(Attribute.class));
        }
        if (node.is("Schema$Has")) {
            this.hasList.add((Has)node.as(Has.class));
        }
        if (node.is("Schema")) {
            this.schemaList.add((Schema)node.as(Schema.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Schema$AttributeMap")) {
            this.attributeMap = null;
        }
        if (node.is("Schema$Attribute")) {
            this.attributeList.remove(node.as(Attribute.class));
        }
        if (node.is("Schema$Has")) {
            this.hasList.remove(node.as(Has.class));
        }
        if (node.is("Schema")) {
            this.schemaList.remove(node.as(Schema.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("isRequired")) {
            this.isRequired = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("multiple")) {
            this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("isRequired")) {
            this.isRequired = (Boolean)values.get(0);
        } else if (name.equalsIgnoreCase("multiple")) {
            this.multiple = (Boolean)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Has
    extends Layer
    implements Terminal {
        protected Schema reference;
        protected boolean isRequired;
        protected boolean multiple;

        public Has(Node node) {
            super(node);
        }

        public Schema reference() {
            return this.reference;
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public boolean multiple() {
            return this.multiple;
        }

        public Has reference(Schema value) {
            this.reference = value;
            return this;
        }

        public Has isRequired(boolean value) {
            this.isRequired = value;
            return this;
        }

        public Has multiple(boolean value) {
            this.multiple = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("reference", this.reference != null ? new ArrayList<Schema>(Collections.singletonList(this.reference)) : Collections.emptyList());
            map.put("isRequired", new ArrayList<Boolean>(Collections.singletonList(this.isRequired)));
            map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("reference")) {
                this.reference = (Schema)((Object)NodeLoader.load(values, Schema.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("isRequired")) {
                this.isRequired = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("multiple")) {
                this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("reference")) {
                this.reference = values.get(0) != null ? (Schema)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Schema.class) : null;
            } else if (name.equalsIgnoreCase("isRequired")) {
                this.isRequired = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("multiple")) {
                this.multiple = (Boolean)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Attribute
    extends Data
    implements Terminal {
        protected boolean isRequired;
        protected boolean multiple;

        public Attribute(Node node) {
            super(node);
        }

        public boolean isRequired() {
            return this.isRequired;
        }

        public boolean multiple() {
            return this.multiple;
        }

        public Attribute isRequired(boolean value) {
            this.isRequired = value;
            return this;
        }

        public Attribute multiple(boolean value) {
            this.multiple = value;
            return this;
        }

        @Override
        public IntegerData asInteger() {
            Layer as = this.a$(IntegerData.class);
            return as != null ? (IntegerData)as : (IntegerData)this.core$().addFacet(IntegerData.class);
        }

        @Override
        public boolean isInteger() {
            return this.core$().is(IntegerData.class);
        }

        @Override
        public TypeData asType() {
            return (TypeData)this.a$(TypeData.class);
        }

        @Override
        public TypeData asType(Expression<String> type) {
            TypeData newElement = (TypeData)this.core$().addFacet(TypeData.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }

        @Override
        public boolean isType() {
            return this.core$().is(TypeData.class);
        }

        @Override
        public void removeType() {
            this.core$().removeFacet(TypeData.class);
        }

        @Override
        public BoolData asBool() {
            Layer as = this.a$(BoolData.class);
            return as != null ? (BoolData)as : (BoolData)this.core$().addFacet(BoolData.class);
        }

        @Override
        public boolean isBool() {
            return this.core$().is(BoolData.class);
        }

        @Override
        public RealData asReal() {
            Layer as = this.a$(RealData.class);
            return as != null ? (RealData)as : (RealData)this.core$().addFacet(RealData.class);
        }

        @Override
        public boolean isReal() {
            return this.core$().is(RealData.class);
        }

        @Override
        public LongIntegerData asLongInteger() {
            Layer as = this.a$(LongIntegerData.class);
            return as != null ? (LongIntegerData)as : (LongIntegerData)this.core$().addFacet(LongIntegerData.class);
        }

        @Override
        public boolean isLongInteger() {
            return this.core$().is(LongIntegerData.class);
        }

        @Override
        public TextData asText() {
            Layer as = this.a$(TextData.class);
            return as != null ? (TextData)as : (TextData)this.core$().addFacet(TextData.class);
        }

        @Override
        public boolean isText() {
            return this.core$().is(TextData.class);
        }

        @Override
        public ObjectData asObject() {
            return (ObjectData)this.a$(ObjectData.class);
        }

        @Override
        public ObjectData asObject(Schema schema) {
            ObjectData newElement = (ObjectData)this.core$().addFacet(ObjectData.class);
            newElement.core$().set((Layer)newElement, "schema", Collections.singletonList(schema));
            return newElement;
        }

        @Override
        public boolean isObject() {
            return this.core$().is(ObjectData.class);
        }

        @Override
        public void removeObject() {
            this.core$().removeFacet(ObjectData.class);
        }

        @Override
        public ListData asList() {
            Layer as = this.a$(ListData.class);
            return as != null ? (ListData)as : (ListData)this.core$().addFacet(ListData.class);
        }

        @Override
        public boolean isList() {
            return this.core$().is(ListData.class);
        }

        @Override
        public FileData asFile() {
            Layer as = this.a$(FileData.class);
            return as != null ? (FileData)as : (FileData)this.core$().addFacet(FileData.class);
        }

        @Override
        public boolean isFile() {
            return this.core$().is(FileData.class);
        }

        @Override
        public DateData asDate() {
            Layer as = this.a$(DateData.class);
            return as != null ? (DateData)as : (DateData)this.core$().addFacet(DateData.class);
        }

        @Override
        public boolean isDate() {
            return this.core$().is(DateData.class);
        }

        @Override
        public DateTimeData asDateTime() {
            Layer as = this.a$(DateTimeData.class);
            return as != null ? (DateTimeData)as : (DateTimeData)this.core$().addFacet(DateTimeData.class);
        }

        @Override
        public boolean isDateTime() {
            return this.core$().is(DateTimeData.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("isRequired", new ArrayList<Boolean>(Collections.singletonList(this.isRequired)));
            map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("isRequired")) {
                this.isRequired = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("multiple")) {
                this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("isRequired")) {
                this.isRequired = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("multiple")) {
                this.multiple = (Boolean)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class AttributeMap
    extends Layer
    implements Terminal {
        public AttributeMap(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void attribute(Predicate<Attribute> filter) {
            new ArrayList<Attribute>(Schema.this.attributeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void has(Predicate<Has> filter) {
            new ArrayList<Has>(Schema.this.hasList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(Schema.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public AttributeMap attributeMap() {
            AttributeMap newElement = (AttributeMap)Schema.this.core$().graph().concept(AttributeMap.class).createNode(this.name, Schema.this.core$()).as(AttributeMap.class);
            return newElement;
        }

        public Attribute attribute() {
            Attribute newElement = (Attribute)Schema.this.core$().graph().concept(Attribute.class).createNode(this.name, Schema.this.core$()).as(Attribute.class);
            return newElement;
        }

        public Has has(Schema reference) {
            Has newElement = (Has)Schema.this.core$().graph().concept(Has.class).createNode(this.name, Schema.this.core$()).as(Has.class);
            newElement.core$().set((Layer)newElement, "reference", Collections.singletonList(reference));
            return newElement;
        }

        public Schema schema() {
            Schema newElement = (Schema)Schema.this.core$().graph().concept(Schema.class).createNode(this.name, Schema.this.core$()).as(Schema.class);
            return newElement;
        }
    }
}

