/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Dialog;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Toolbar;
import io.intino.konos.model.graph.View;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.BooleanLoader;
import io.intino.tara.magritte.loaders.IntegerLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractToolbar
extends Layer
implements Component,
Terminal {
    protected boolean canSearch;
    protected List<Operation> operationList = new ArrayList<Operation>();
    protected List<OpenDialog> openDialogList = new ArrayList<OpenDialog>();
    protected List<Task> taskList = new ArrayList<Task>();
    protected List<TaskSelection> taskSelectionList = new ArrayList<TaskSelection>();
    protected List<Download> downloadList = new ArrayList<Download>();
    protected List<DownloadSelection> downloadSelectionList = new ArrayList<DownloadSelection>();
    protected List<Export> exportList = new ArrayList<Export>();
    protected List<ExportSelection> exportSelectionList = new ArrayList<ExportSelection>();
    protected List<OpenCatalog> openCatalogList = new ArrayList<OpenCatalog>();
    protected List<OpenCatalogSelection> openCatalogSelectionList = new ArrayList<OpenCatalogSelection>();

    public AbstractToolbar(Node node) {
        super(node);
    }

    public boolean canSearch() {
        return this.canSearch;
    }

    public Toolbar canSearch(boolean value) {
        this.canSearch = value;
        return (Toolbar)this;
    }

    public List<Operation> operationList() {
        return Collections.unmodifiableList(this.operationList);
    }

    public Operation operation(int index) {
        return this.operationList.get(index);
    }

    public List<Operation> operationList(Predicate<Operation> predicate) {
        return this.operationList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<OpenDialog> openDialogList() {
        return Collections.unmodifiableList(this.openDialogList);
    }

    public OpenDialog openDialog(int index) {
        return this.openDialogList.get(index);
    }

    public List<OpenDialog> openDialogList(Predicate<OpenDialog> predicate) {
        return this.openDialogList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Task> taskList() {
        return Collections.unmodifiableList(this.taskList);
    }

    public Task task(int index) {
        return this.taskList.get(index);
    }

    public List<Task> taskList(Predicate<Task> predicate) {
        return this.taskList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<TaskSelection> taskSelectionList() {
        return Collections.unmodifiableList(this.taskSelectionList);
    }

    public TaskSelection taskSelection(int index) {
        return this.taskSelectionList.get(index);
    }

    public List<TaskSelection> taskSelectionList(Predicate<TaskSelection> predicate) {
        return this.taskSelectionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Download> downloadList() {
        return Collections.unmodifiableList(this.downloadList);
    }

    public Download download(int index) {
        return this.downloadList.get(index);
    }

    public List<Download> downloadList(Predicate<Download> predicate) {
        return this.downloadList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<DownloadSelection> downloadSelectionList() {
        return Collections.unmodifiableList(this.downloadSelectionList);
    }

    public DownloadSelection downloadSelection(int index) {
        return this.downloadSelectionList.get(index);
    }

    public List<DownloadSelection> downloadSelectionList(Predicate<DownloadSelection> predicate) {
        return this.downloadSelectionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Export> exportList() {
        return Collections.unmodifiableList(this.exportList);
    }

    public Export export(int index) {
        return this.exportList.get(index);
    }

    public List<Export> exportList(Predicate<Export> predicate) {
        return this.exportList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<ExportSelection> exportSelectionList() {
        return Collections.unmodifiableList(this.exportSelectionList);
    }

    public ExportSelection exportSelection(int index) {
        return this.exportSelectionList.get(index);
    }

    public List<ExportSelection> exportSelectionList(Predicate<ExportSelection> predicate) {
        return this.exportSelectionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<OpenCatalog> openCatalogList() {
        return Collections.unmodifiableList(this.openCatalogList);
    }

    public OpenCatalog openCatalog(int index) {
        return this.openCatalogList.get(index);
    }

    public List<OpenCatalog> openCatalogList(Predicate<OpenCatalog> predicate) {
        return this.openCatalogList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<OpenCatalogSelection> openCatalogSelectionList() {
        return Collections.unmodifiableList(this.openCatalogSelectionList);
    }

    public OpenCatalogSelection openCatalogSelection(int index) {
        return this.openCatalogSelectionList.get(index);
    }

    public List<OpenCatalogSelection> openCatalogSelectionList(Predicate<OpenCatalogSelection> predicate) {
        return this.openCatalogSelectionList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
        new ArrayList<OpenDialog>(this.openDialogList).forEach(c -> components.add(c.core$()));
        new ArrayList<Task>(this.taskList).forEach(c -> components.add(c.core$()));
        new ArrayList<TaskSelection>(this.taskSelectionList).forEach(c -> components.add(c.core$()));
        new ArrayList<Download>(this.downloadList).forEach(c -> components.add(c.core$()));
        new ArrayList<DownloadSelection>(this.downloadSelectionList).forEach(c -> components.add(c.core$()));
        new ArrayList<Export>(this.exportList).forEach(c -> components.add(c.core$()));
        new ArrayList<ExportSelection>(this.exportSelectionList).forEach(c -> components.add(c.core$()));
        new ArrayList<OpenCatalog>(this.openCatalogList).forEach(c -> components.add(c.core$()));
        new ArrayList<OpenCatalogSelection>(this.openCatalogSelectionList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("canSearch", new ArrayList<Boolean>(Collections.singletonList(this.canSearch)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Toolbar$Operation")) {
            this.operationList.add((Operation)node.as(Operation.class));
        }
        if (node.is("Toolbar$OpenDialog")) {
            this.openDialogList.add((OpenDialog)node.as(OpenDialog.class));
        }
        if (node.is("Toolbar$Task")) {
            this.taskList.add((Task)node.as(Task.class));
        }
        if (node.is("Toolbar$TaskSelection")) {
            this.taskSelectionList.add((TaskSelection)node.as(TaskSelection.class));
        }
        if (node.is("Toolbar$Download")) {
            this.downloadList.add((Download)node.as(Download.class));
        }
        if (node.is("Toolbar$DownloadSelection")) {
            this.downloadSelectionList.add((DownloadSelection)node.as(DownloadSelection.class));
        }
        if (node.is("Toolbar$Export")) {
            this.exportList.add((Export)node.as(Export.class));
        }
        if (node.is("Toolbar$ExportSelection")) {
            this.exportSelectionList.add((ExportSelection)node.as(ExportSelection.class));
        }
        if (node.is("Toolbar$OpenCatalog")) {
            this.openCatalogList.add((OpenCatalog)node.as(OpenCatalog.class));
        }
        if (node.is("Toolbar$OpenCatalogSelection")) {
            this.openCatalogSelectionList.add((OpenCatalogSelection)node.as(OpenCatalogSelection.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Toolbar$Operation")) {
            this.operationList.remove(node.as(Operation.class));
        }
        if (node.is("Toolbar$OpenDialog")) {
            this.openDialogList.remove(node.as(OpenDialog.class));
        }
        if (node.is("Toolbar$Task")) {
            this.taskList.remove(node.as(Task.class));
        }
        if (node.is("Toolbar$TaskSelection")) {
            this.taskSelectionList.remove(node.as(TaskSelection.class));
        }
        if (node.is("Toolbar$Download")) {
            this.downloadList.remove(node.as(Download.class));
        }
        if (node.is("Toolbar$DownloadSelection")) {
            this.downloadSelectionList.remove(node.as(DownloadSelection.class));
        }
        if (node.is("Toolbar$Export")) {
            this.exportList.remove(node.as(Export.class));
        }
        if (node.is("Toolbar$ExportSelection")) {
            this.exportSelectionList.remove(node.as(ExportSelection.class));
        }
        if (node.is("Toolbar$OpenCatalog")) {
            this.openCatalogList.remove(node.as(OpenCatalog.class));
        }
        if (node.is("Toolbar$OpenCatalogSelection")) {
            this.openCatalogSelectionList.remove(node.as(OpenCatalogSelection.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("canSearch")) {
            this.canSearch = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("canSearch")) {
            this.canSearch = (Boolean)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class OpenCatalogSelection
    extends Operation
    implements Terminal {
        protected Catalog catalog;
        protected List<View> views = new ArrayList<View>();
        protected boolean filtered;
        protected Selection selection;
        protected Position position;
        protected int width;
        protected int height;

        public OpenCatalogSelection(Node node) {
            super(node);
        }

        public Catalog catalog() {
            return this.catalog;
        }

        public List<View> views() {
            return this.views;
        }

        public View views(int index) {
            return this.views.get(index);
        }

        public List<View> views(Predicate<View> predicate) {
            return this.views().stream().filter(predicate).collect(Collectors.toList());
        }

        public boolean filtered() {
            return this.filtered;
        }

        public Selection selection() {
            return this.selection;
        }

        public Position position() {
            return this.position;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public OpenCatalogSelection catalog(Catalog value) {
            this.catalog = value;
            return this;
        }

        public OpenCatalogSelection filtered(boolean value) {
            this.filtered = value;
            return this;
        }

        public OpenCatalogSelection selection(Selection value) {
            this.selection = value;
            return this;
        }

        public OpenCatalogSelection position(Position value) {
            this.position = value;
            return this;
        }

        public OpenCatalogSelection width(int value) {
            this.width = value;
            return this;
        }

        public OpenCatalogSelection height(int value) {
            this.height = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
            map.put("views", this.views);
            map.put("filtered", new ArrayList<Boolean>(Collections.singletonList(this.filtered)));
            map.put("selection", new ArrayList<Selection>(Collections.singletonList(this.selection)));
            map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("catalog")) {
                this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("views")) {
                this.views = NodeLoader.load(values, View.class, (Layer)this);
            } else if (name.equalsIgnoreCase("filtered")) {
                this.filtered = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("selection")) {
                this.selection = (Selection)((Object)WordLoader.load(values, Selection.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("catalog")) {
                this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
            } else if (name.equalsIgnoreCase("views")) {
                this.views = values.stream().map(s -> (View)this.graph().core$().load(((Layer)s).core$().id()).as(View.class)).collect(Collectors.toList());
            } else if (name.equalsIgnoreCase("filtered")) {
                this.filtered = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("selection")) {
                this.selection = (Selection)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Position {
            Standalone,
            RelativeToOperation;

        }

        public static enum Selection {
            None,
            Single,
            Multiple;

        }
    }

    public static class OpenCatalog
    extends Operation
    implements Terminal {
        protected Catalog catalog;
        protected List<View> views = new ArrayList<View>();
        protected boolean filtered;
        protected boolean openItem;
        protected int width;
        protected int height;
        protected Position position;

        public OpenCatalog(Node node) {
            super(node);
        }

        public Catalog catalog() {
            return this.catalog;
        }

        public List<View> views() {
            return this.views;
        }

        public View views(int index) {
            return this.views.get(index);
        }

        public List<View> views(Predicate<View> predicate) {
            return this.views().stream().filter(predicate).collect(Collectors.toList());
        }

        public boolean filtered() {
            return this.filtered;
        }

        public boolean openItem() {
            return this.openItem;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public Position position() {
            return this.position;
        }

        public OpenCatalog catalog(Catalog value) {
            this.catalog = value;
            return this;
        }

        public OpenCatalog filtered(boolean value) {
            this.filtered = value;
            return this;
        }

        public OpenCatalog openItem(boolean value) {
            this.openItem = value;
            return this;
        }

        public OpenCatalog width(int value) {
            this.width = value;
            return this;
        }

        public OpenCatalog height(int value) {
            this.height = value;
            return this;
        }

        public OpenCatalog position(Position value) {
            this.position = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("catalog", this.catalog != null ? new ArrayList<Catalog>(Collections.singletonList(this.catalog)) : Collections.emptyList());
            map.put("views", this.views);
            map.put("filtered", new ArrayList<Boolean>(Collections.singletonList(this.filtered)));
            map.put("openItem", new ArrayList<Boolean>(Collections.singletonList(this.openItem)));
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("catalog")) {
                this.catalog = (Catalog)((Object)NodeLoader.load(values, Catalog.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("views")) {
                this.views = NodeLoader.load(values, View.class, (Layer)this);
            } else if (name.equalsIgnoreCase("filtered")) {
                this.filtered = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("openItem")) {
                this.openItem = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("catalog")) {
                this.catalog = values.get(0) != null ? (Catalog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Catalog.class) : null;
            } else if (name.equalsIgnoreCase("views")) {
                this.views = values.stream().map(s -> (View)this.graph().core$().load(((Layer)s).core$().id()).as(View.class)).collect(Collectors.toList());
            } else if (name.equalsIgnoreCase("filtered")) {
                this.filtered = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("openItem")) {
                this.openItem = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)values.get(0));
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Position {
            Standalone,
            RelativeToOperation;

        }
    }

    public static class ExportSelection
    extends Operation
    implements Terminal {
        public ExportSelection(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Export
    extends Operation
    implements Terminal {
        public Export(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class DownloadSelection
    extends Operation
    implements Terminal {
        protected List<String> options = new ArrayList<String>();

        public DownloadSelection(Node node) {
            super(node);
        }

        public List<String> options() {
            return this.options;
        }

        public String options(int index) {
            return this.options.get(index);
        }

        public List<String> options(Predicate<String> predicate) {
            return this.options().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("options", this.options);
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = StringLoader.load(values, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = new ArrayList(values);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Download
    extends Operation
    implements Terminal {
        protected List<String> options = new ArrayList<String>();

        public Download(Node node) {
            super(node);
        }

        public List<String> options() {
            return this.options;
        }

        public String options(int index) {
            return this.options.get(index);
        }

        public List<String> options(Predicate<String> predicate) {
            return this.options().stream().filter(predicate).collect(Collectors.toList());
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("options", this.options);
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = StringLoader.load(values, (Layer)this);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = new ArrayList(values);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class TaskSelection
    extends Operation
    implements Terminal {
        protected String confirmText;

        public TaskSelection(Node node) {
            super(node);
        }

        public String confirmText() {
            return this.confirmText;
        }

        public TaskSelection confirmText(String value) {
            this.confirmText = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("confirmText", new ArrayList<String>(Collections.singletonList(this.confirmText)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("confirmText")) {
                this.confirmText = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("confirmText")) {
                this.confirmText = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Task
    extends Operation
    implements Terminal {
        protected String confirmText;

        public Task(Node node) {
            super(node);
        }

        public String confirmText() {
            return this.confirmText;
        }

        public Task confirmText(String value) {
            this.confirmText = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("confirmText", new ArrayList<String>(Collections.singletonList(this.confirmText)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("confirmText")) {
                this.confirmText = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("confirmText")) {
                this.confirmText = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class OpenDialog
    extends Operation
    implements Terminal {
        protected Dialog dialog;
        protected int width;
        protected int height;

        public OpenDialog(Node node) {
            super(node);
        }

        public Dialog dialog() {
            return this.dialog;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public OpenDialog dialog(Dialog value) {
            this.dialog = value;
            return this;
        }

        public OpenDialog width(int value) {
            this.width = value;
            return this;
        }

        public OpenDialog height(int value) {
            this.height = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("dialog", this.dialog != null ? new ArrayList<Dialog>(Collections.singletonList(this.dialog)) : Collections.emptyList());
            map.put("width", new ArrayList<Integer>(Collections.singletonList(this.width)));
            map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("dialog")) {
                this.dialog = (Dialog)((Object)NodeLoader.load(values, Dialog.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("dialog")) {
                this.dialog = values.get(0) != null ? (Dialog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Dialog.class) : null;
            } else if (name.equalsIgnoreCase("width")) {
                this.width = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("height")) {
                this.height = (Integer)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class Operation
    extends Layer
    implements Terminal {
        protected String title;
        protected String polymerIcon;
        protected Mode mode;

        public Operation(Node node) {
            super(node);
        }

        public String title() {
            return this.title;
        }

        public String polymerIcon() {
            return this.polymerIcon;
        }

        public Mode mode() {
            return this.mode;
        }

        public Operation title(String value) {
            this.title = value;
            return this;
        }

        public Operation polymerIcon(String value) {
            this.polymerIcon = value;
            return this;
        }

        public Operation mode(Mode value) {
            this.mode = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
            map.put("polymerIcon", new ArrayList<String>(Collections.singletonList(this.polymerIcon)));
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("polymerIcon")) {
                this.polymerIcon = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)values.get(0);
            } else if (name.equalsIgnoreCase("polymerIcon")) {
                this.polymerIcon = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }

        public static enum Mode {
            Link,
            Button,
            Icon,
            Chip;

        }
    }

    public class Clear {
        public void openDialog(Predicate<OpenDialog> filter) {
            new ArrayList<OpenDialog>(AbstractToolbar.this.openDialogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void task(Predicate<Task> filter) {
            new ArrayList<Task>(AbstractToolbar.this.taskList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void taskSelection(Predicate<TaskSelection> filter) {
            new ArrayList<TaskSelection>(AbstractToolbar.this.taskSelectionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void download(Predicate<Download> filter) {
            new ArrayList<Download>(AbstractToolbar.this.downloadList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void downloadSelection(Predicate<DownloadSelection> filter) {
            new ArrayList<DownloadSelection>(AbstractToolbar.this.downloadSelectionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void export(Predicate<Export> filter) {
            new ArrayList<Export>(AbstractToolbar.this.exportList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exportSelection(Predicate<ExportSelection> filter) {
            new ArrayList<ExportSelection>(AbstractToolbar.this.exportSelectionList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void openCatalog(Predicate<OpenCatalog> filter) {
            new ArrayList<OpenCatalog>(AbstractToolbar.this.openCatalogList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void openCatalogSelection(Predicate<OpenCatalogSelection> filter) {
            new ArrayList<OpenCatalogSelection>(AbstractToolbar.this.openCatalogSelectionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public OpenDialog openDialog(String title, Dialog dialog) {
            OpenDialog newElement = (OpenDialog)AbstractToolbar.this.core$().graph().concept(OpenDialog.class).createNode(this.name, AbstractToolbar.this.core$()).as(OpenDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "dialog", Collections.singletonList(dialog));
            return newElement;
        }

        public Task task(String title) {
            Task newElement = (Task)AbstractToolbar.this.core$().graph().concept(Task.class).createNode(this.name, AbstractToolbar.this.core$()).as(Task.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public TaskSelection taskSelection(String title) {
            TaskSelection newElement = (TaskSelection)AbstractToolbar.this.core$().graph().concept(TaskSelection.class).createNode(this.name, AbstractToolbar.this.core$()).as(TaskSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public Download download(String title) {
            Download newElement = (Download)AbstractToolbar.this.core$().graph().concept(Download.class).createNode(this.name, AbstractToolbar.this.core$()).as(Download.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public DownloadSelection downloadSelection(String title) {
            DownloadSelection newElement = (DownloadSelection)AbstractToolbar.this.core$().graph().concept(DownloadSelection.class).createNode(this.name, AbstractToolbar.this.core$()).as(DownloadSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public Export export(String title) {
            Export newElement = (Export)AbstractToolbar.this.core$().graph().concept(Export.class).createNode(this.name, AbstractToolbar.this.core$()).as(Export.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public ExportSelection exportSelection(String title) {
            ExportSelection newElement = (ExportSelection)AbstractToolbar.this.core$().graph().concept(ExportSelection.class).createNode(this.name, AbstractToolbar.this.core$()).as(ExportSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OpenCatalog openCatalog(String title, Catalog catalog, List<View> views) {
            OpenCatalog newElement = (OpenCatalog)AbstractToolbar.this.core$().graph().concept(OpenCatalog.class).createNode(this.name, AbstractToolbar.this.core$()).as(OpenCatalog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            newElement.core$().set((Layer)newElement, "views", views);
            return newElement;
        }

        public OpenCatalogSelection openCatalogSelection(String title, Catalog catalog, List<View> views) {
            OpenCatalogSelection newElement = (OpenCatalogSelection)AbstractToolbar.this.core$().graph().concept(OpenCatalogSelection.class).createNode(this.name, AbstractToolbar.this.core$()).as(OpenCatalogSelection.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            newElement.core$().set((Layer)newElement, "views", views);
            return newElement;
        }
    }
}

