/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake.process;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.process.ProcessTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHandler;
import io.intino.konos.model.graph.Process;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ProcessRenderer {
    private final List<Process> processes;
    private final File src;
    private final String packageName;
    private final String boxName;

    public ProcessRenderer(KonosGraph graph, File src, String packageName, String boxName) {
        this.processes = this.processes(graph);
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        for (Process process : this.processes) {
            String handlerName;
            File destination;
            String name = this.composedName(process);
            Frame frame = new Frame(new String[0]).addTypes(new String[]{"process"}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name});
            if (process.schema() != null) {
                frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
                frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{process.schema().name$()})});
            } else {
                frame.addSlot("type", new String[]{"message"});
            }
            if (this.alreadyRendered(destination = new File(this.src, "ness/processes"), handlerName = Formatters.firstUpperCase(name) + "Process")) continue;
            Commons.writeFrame(destination, handlerName, Formatters.customize(ProcessTemplate.create()).format((Object)frame));
        }
    }

    private String composedName(MessageHandler handler) {
        return Commons.firstUpperCase((handler.subdomain().isEmpty() ? "" : Formatters.snakeCaseToCamelCase().format((Object)handler.subdomain().replace(".", "_"))) + Commons.firstUpperCase(this.name(handler)));
    }

    private String name(MessageHandler handler) {
        return handler.schema() == null ? handler.name$() : handler.schema().name$();
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }

    private List<Process> processes(KonosGraph graph) {
        if (graph == null) {
            return Collections.emptyList();
        }
        return !graph.nessClientList().isEmpty() ? graph.nessClient(0).messageHandlerList().stream().filter(h -> h.i$(Process.class)).map(h -> (Process)h.a$(Process.class)).collect(Collectors.toList()) : Collections.emptyList();
    }
}

