/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.resource;

import com.intellij.openapi.project.Project;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.action.UIActionRenderer;
import io.intino.konos.builder.codegeneration.services.ui.resource.ResourceTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ResourceRenderer {
    private static final String RESOURCES = "resources";
    private final Project project;
    private final File src;
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final List<AbstractUIService.Resource> resourceList;

    public ResourceRenderer(Project project, KonosGraph graph, File src, File gen, String packageName, String boxName) {
        this.project = project;
        this.src = src;
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.resourceList = graph.core$().find(AbstractUIService.Resource.class);
    }

    public void execute() {
        this.resourceList.forEach(this::processResource);
    }

    private void processResource(AbstractUIService.Resource resource) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"resource"});
        frame.addSlot("package", new String[]{this.packageName});
        frame.addSlot("name", new String[]{resource.name$()});
        frame.addSlot("box", new String[]{this.boxName});
        frame.addSlot("parameter", (AbstractFrame[])this.parameters(resource));
        if (resource.isEditorPage()) {
            frame.addSlot("editor", new String[]{"Editor"});
        }
        if (((UIService)resource.core$().ownerAs(UIService.class)).googleApiKey() != null) {
            frame.addSlot("googleApiKey", new String[]{((UIService)resource.core$().ownerAs(UIService.class)).googleApiKey()});
        }
        if (resource.isConfidential()) {
            frame.addSlot("confidential", new String[]{""});
        }
        Commons.writeFrame(new File(this.gen, RESOURCES), StringHelper.snakeCaseToCamelCase((String)(resource.name$() + "Resource")), this.template().format((Object)frame));
        this.createCorrespondingAction(resource);
    }

    private void createCorrespondingAction(AbstractUIService.Resource resource) {
        new UIActionRenderer(this.project, resource, this.src, this.gen, this.packageName, this.boxName).execute();
    }

    private Template template() {
        Template template = ResourceTemplate.create();
        this.addFormats(template);
        return template;
    }

    private void addFormats(Template template) {
        template.add("SnakeCaseToCamelCase", value -> StringHelper.snakeCaseToCamelCase((String)value.toString()));
        template.add("ReturnTypeFormatter", value -> value.equals("Void") ? "void" : value);
        template.add("validname", value -> value.toString().replace("-", "").toLowerCase());
    }

    private Frame[] parameters(AbstractUIService.Resource resource) {
        List<String> parameters = Commons.extractUrlPathParameters(resource.path());
        return parameters.stream().map(parameter -> new Frame(new String[0]).addTypes(new String[]{"parameter"}).addSlot("name", new String[]{parameter})).collect(Collectors.toList()).toArray(new Frame[0]);
    }
}

