/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.PsiTestUtil;
import io.intino.konos.builder.KonosIcons;
import io.intino.konos.builder.actions.KonosAction;
import io.intino.konos.builder.codegeneration.FullRenderer;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.legio.graph.Artifact;
import io.intino.plugin.project.LegioConfiguration;
import io.intino.plugin.project.LibraryConflictResolver;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CreateKonosBoxAction
extends KonosAction {
    private static final Logger LOG = Logger.getInstance((String)"CreateKonosBoxAction: ");
    private static final String BOX = "box";
    private static final String TEXT = "Create Konos Box";

    public CreateKonosBoxAction() {
        super(TEXT, "Creates Konos Box", KonosIcons.GENERATE_16);
        this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"control alt S"}));
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setIcon(KonosIcons.GENERATE_16);
        super.update(e);
        File file = new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        if (!file.exists()) {
            return;
        }
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module != null) {
            e.getPresentation().setText("Create Konos Box for " + module.getName() + " (" + file.getParentFile().getName() + ")");
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (this.noProject(e, project) || module == null) {
            return;
        }
        project.save();
        FileDocumentManager.getInstance().saveAllDocuments();
        KonosGraph konosGraph = new KonosGenerator(module).generate(TaraUtil.getSrcRoot((Module)module), this.getGenRoot(module), this.getResRoot(module));
        if (konosGraph != null) {
            this.updateDependencies(module, this.requiredDependencies(module, konosGraph));
        }
    }

    private void updateDependencies(Module module, Map<String, String> requiredLibraries) {
        LegioConfiguration configuration = (LegioConfiguration)TaraUtil.configurationOf((Module)module);
        List dependencies = configuration.graph().artifact().imports().dependencyList();
        configuration.addCompileDependencies(requiredLibraries.keySet().stream().filter(dep -> this.findDependency(dependencies, (String)dep) == null).map(dep -> dep + ":" + (String)requiredLibraries.get(dep)).collect(Collectors.toList()));
        configuration.updateCompileDependencies(requiredLibraries.keySet().stream().filter(dep -> {
            Artifact.Imports.Dependency dependency = this.findDependency(dependencies, (String)dep);
            return dependency != null && this.isOlder(dependency, (String)requiredLibraries.get(dep));
        }).map(dep -> dep + ":" + (String)requiredLibraries.get(dep)).collect(Collectors.toList()));
        configuration.reload();
    }

    private boolean isOlder(Artifact.Imports.Dependency dependency, String version) {
        return new LibraryConflictResolver.Version(dependency.effectiveVersion()).compareTo(new LibraryConflictResolver.Version(version)) < 0;
    }

    private Artifact.Imports.Dependency findDependency(List<Artifact.Imports.Dependency> dependencies, String artifact) {
        return dependencies.stream().filter(dependency -> artifact.equals(dependency.groupId() + ":" + dependency.artifactId())).findFirst().orElse(null);
    }

    private Map<String, String> requiredDependencies(Module module, KonosGraph konosGraph) {
        Type typeOfHashMap = new TypeToken<Map<String, String>>(){}.getType();
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream("/versions.json");
        if (resourceAsStream == null) {
            return Collections.emptyMap();
        }
        Map dependencies = (Map)new Gson().fromJson((Reader)new InputStreamReader(resourceAsStream), typeOfHashMap);
        if (!this.hasModel(module) && konosGraph.jMXServiceList().isEmpty()) {
            this.remove(dependencies, "jmx");
        }
        if (konosGraph.jMSServiceList().isEmpty()) {
            this.remove(dependencies, "jms");
        }
        if (konosGraph.taskList().isEmpty()) {
            this.remove(dependencies, "scheduler");
        }
        if (konosGraph.nessClientList().isEmpty()) {
            this.remove(dependencies, "ness-accessor");
        }
        if (konosGraph.uIServiceList().isEmpty()) {
            this.remove(dependencies, "ui");
        }
        if (konosGraph.rESTServiceList().isEmpty()) {
            this.remove(dependencies, "rest");
        }
        if (konosGraph.slackBotServiceList().isEmpty()) {
            this.remove(dependencies, "slack");
        }
        return dependencies;
    }

    private void remove(Map<String, String> dependencies, String type) {
        String toRemove = null;
        for (String dep : dependencies.keySet()) {
            if (!dep.contains(type)) continue;
            toRemove = dep;
        }
        if (toRemove != null) {
            dependencies.remove(toRemove);
        }
    }

    private boolean hasModel(Module module) {
        return module != null && TaraUtil.configurationOf((Module)module) != null && this.hasModel(TaraUtil.configurationOf((Module)module));
    }

    private boolean hasModel(Configuration configuration) {
        return !configuration.languages().isEmpty();
    }

    private boolean noProject(AnActionEvent e, Project project) {
        if (project == null) {
            LOG.error("actionPerformed: no project for " + e);
            return true;
        }
        return false;
    }

    private VirtualFile getGenRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"gen".equals(file.getName())) continue;
            return file;
        }
        VirtualFile genDirectory = this.createDirectory(module, "gen");
        if (genDirectory == null) {
            return null;
        }
        PsiTestUtil.addSourceRoot((Module)module, (VirtualFile)genDirectory, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        return genDirectory;
    }

    private VirtualFile getResRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"res".equals(file.getName())) continue;
            return file;
        }
        VirtualFile resDirectory = this.createDirectory(module, "res");
        PsiTestUtil.addSourceRoot((Module)module, (VirtualFile)resDirectory, (JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        return resDirectory;
    }

    private VirtualFile createDirectory(Module module, String name) {
        Application a = ApplicationManager.getApplication();
        if (!a.isWriteAccessAllowed()) {
            return (VirtualFile)a.runWriteAction(() -> this.create(module, name));
        }
        return this.create(module, name);
    }

    @Nullable
    private VirtualFile create(Module module, String name) {
        try {
            VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            return VfsUtil.createDirectoryIfMissing((VirtualFile)contentRoots[0], (String)name);
        }
        catch (IOException e) {
            return null;
        }
    }

    private class KonosGenerator {
        private final Module module;

        KonosGenerator(Module module) {
            this.module = module;
        }

        KonosGraph generate(VirtualFile srcDirectory, VirtualFile genDirectory, VirtualFile resDirectory) {
            if (genDirectory == null) {
                this.notifyError("gen source root not found.");
                return null;
            }
            Configuration configuration = TaraUtil.configurationOf((Module)this.module);
            String generationPackage = configuration == null ? CreateKonosBoxAction.BOX : configuration.workingPackage() + (configuration.boxPackage().isEmpty() ? "" : "." + configuration.boxPackage());
            File gen = new File(genDirectory.getPath(), generationPackage.replace(".", File.separator));
            gen.mkdirs();
            File src = new File(srcDirectory.getPath(), generationPackage.replace(".", File.separator));
            src.mkdirs();
            return this.generate(generationPackage, gen, src, new File(resDirectory.getPath()));
        }

        private KonosGraph generate(String packageName, File gen, File src, File res) {
            KonosGraph graph = GraphLoader.loadGraph(this.module);
            if (graph == null) {
                this.notifyError("Models have errors");
                return null;
            }
            if (!this.render(packageName, gen, src, res, graph)) {
                return null;
            }
            this.refreshDirectories(gen, src, res);
            this.notifySuccess();
            return graph;
        }

        private void refreshDirectories(File gen, File src, File res) {
            this.refreshDirectory(gen);
            this.refreshDirectory(src);
            this.refreshDirectory(res);
        }

        private boolean render(String packageName, File gen, File src, File res, KonosGraph graph) {
            try {
                new FullRenderer(this.module, graph, src, gen, res, packageName).execute();
            }
            catch (Exception e) {
                Logger.getInstance(this.getClass()).error(e.getMessage(), (Throwable)e);
                this.notifyError(e.getMessage() == null ? e.toString() : e.getMessage());
                return false;
            }
            return true;
        }

        private void notifySuccess() {
            VirtualFile genRoot = CreateKonosBoxAction.this.getGenRoot(this.module);
            if (genRoot != null) {
                Notifications.Bus.notify((Notification)new Notification("Boxing", "Services for " + this.module.getName(), "Generated", NotificationType.INFORMATION), (Project)this.module.getProject());
            }
        }

        private void notifyError(String message) {
            Notifications.Bus.notify((Notification)new Notification("Boxing", "Services cannot be generated", message, NotificationType.ERROR), (Project)this.module.getProject());
        }

        private void refreshDirectory(File dir) {
            VirtualFile vDir = VfsUtil.findFileByIoFile((File)dir, (boolean)true);
            if (vDir == null || !vDir.isValid()) {
                return;
            }
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{vDir});
            vDir.refresh(true, true);
        }
    }
}

