/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Toolbar;
import io.intino.konos.model.graph.View;
import io.intino.konos.model.graph.desktop.DesktopPanel;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Panel
extends Display
implements Terminal {
    protected Layout layout;
    protected Toolbar toolbar;
    protected Views views;

    public Panel(Node node) {
        super(node);
    }

    public Layout layout() {
        return this.layout;
    }

    public Panel layout(Layout value) {
        this.layout = value;
        return this;
    }

    public Toolbar toolbar() {
        return this.toolbar;
    }

    public Views views() {
        return this.views;
    }

    public Panel toolbar(Toolbar value) {
        this.toolbar = value;
        return this;
    }

    public Panel views(Views value) {
        this.views = value;
        return this;
    }

    public DesktopPanel asDesktop() {
        return (DesktopPanel)this.a$(DesktopPanel.class);
    }

    public DesktopPanel asDesktop(String title, String subTitle, String logoPath, String faviconPath) {
        DesktopPanel newElement = (DesktopPanel)this.core$().addFacet(DesktopPanel.class);
        newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
        newElement.core$().set((Layer)newElement, "subTitle", Collections.singletonList(subTitle));
        newElement.core$().set((Layer)newElement, "logoPath", Collections.singletonList(logoPath));
        newElement.core$().set((Layer)newElement, "faviconPath", Collections.singletonList(faviconPath));
        return newElement;
    }

    public boolean isDesktop() {
        return this.core$().is(DesktopPanel.class);
    }

    public void removeDesktop() {
        this.core$().removeFacet(DesktopPanel.class);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.toolbar != null) {
            components.add(this.toolbar.core$());
        }
        if (this.views != null) {
            components.add(this.views.core$());
        }
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("layout", new ArrayList<Layout>(Collections.singletonList(this.layout)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Toolbar")) {
            this.toolbar = (Toolbar)node.as(Toolbar.class);
        }
        if (node.is("Panel$Views")) {
            this.views = (Views)node.as(Views.class);
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Toolbar")) {
            this.toolbar = null;
        }
        if (node.is("Panel$Views")) {
            this.views = null;
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("layout")) {
            this.layout = (Layout)((Object)WordLoader.load(values, Layout.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("layout")) {
            this.layout = (Layout)((Object)values.get(0));
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Views
    extends Layer
    implements Terminal {
        protected List<View> viewList = new ArrayList<View>();

        public Views(Node node) {
            super(node);
        }

        public List<View> viewList() {
            return Collections.unmodifiableList(this.viewList);
        }

        public View view(int index) {
            return this.viewList.get(index);
        }

        public List<View> viewList(Predicate<View> predicate) {
            return this.viewList().stream().filter(predicate).collect(Collectors.toList());
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<View>(this.viewList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("View")) {
                this.viewList.add((View)node.as(View.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("View")) {
                this.viewList.remove(node.as(View.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void view(Predicate<View> filter) {
                new ArrayList<View>(Views.this.viewList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public View view(String label) {
                View newElement = (View)Views.this.core$().graph().concept(View.class).createNode(this.name, Views.this.core$()).as(View.class);
                newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
                return newElement;
            }
        }
    }

    public class Clear
    extends Display.Clear {
        public Clear() {
            super(Panel.this);
        }
    }

    public class Create
    extends Display.Create {
        public Create(String name) {
            super(Panel.this, name);
        }

        public Toolbar toolbar() {
            Toolbar newElement = (Toolbar)Panel.this.core$().graph().concept(Toolbar.class).createNode(this.name, Panel.this.core$()).as(Toolbar.class);
            return newElement;
        }

        public Views views() {
            Views newElement = (Views)Panel.this.core$().graph().concept(Views.class).createNode(this.name, Panel.this.core$()).as(Views.class);
            return newElement;
        }
    }

    public static enum Layout {
        Menu,
        Tab;

    }
}

