/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Box
extends Layer
implements Terminal {
    protected List<Parameter> parameterList = new ArrayList<Parameter>();
    protected List<Consumer> consumerList = new ArrayList<Consumer>();
    protected List<Producer> producerList = new ArrayList<Producer>();

    public Box(Node node) {
        super(node);
    }

    public List<Parameter> parameterList() {
        return Collections.unmodifiableList(this.parameterList);
    }

    public Parameter parameter(int index) {
        return this.parameterList.get(index);
    }

    public List<Parameter> parameterList(Predicate<Parameter> predicate) {
        return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Consumer> consumerList() {
        return Collections.unmodifiableList(this.consumerList);
    }

    public Consumer consumer(int index) {
        return this.consumerList.get(index);
    }

    public List<Consumer> consumerList(Predicate<Consumer> predicate) {
        return this.consumerList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Producer> producerList() {
        return Collections.unmodifiableList(this.producerList);
    }

    public Producer producer(int index) {
        return this.producerList.get(index);
    }

    public List<Producer> producerList(Predicate<Producer> predicate) {
        return this.producerList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
        new ArrayList<Consumer>(this.consumerList).forEach(c -> components.add(c.core$()));
        new ArrayList<Producer>(this.producerList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Box$Parameter")) {
            this.parameterList.add((Parameter)node.as(Parameter.class));
        }
        if (node.is("Box$Consumer")) {
            this.consumerList.add((Consumer)node.as(Consumer.class));
        }
        if (node.is("Box$Producer")) {
            this.producerList.add((Producer)node.as(Producer.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Box$Parameter")) {
            this.parameterList.remove(node.as(Parameter.class));
        }
        if (node.is("Box$Consumer")) {
            this.consumerList.remove(node.as(Consumer.class));
        }
        if (node.is("Box$Producer")) {
            this.producerList.remove(node.as(Producer.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Producer
    extends Layer
    implements Terminal {
        protected String tank;

        public Producer(Node node) {
            super(node);
        }

        public String tank() {
            return this.tank;
        }

        public Producer tank(String value) {
            this.tank = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("tank", new ArrayList<String>(Collections.singletonList(this.tank)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("tank")) {
                this.tank = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Consumer
    extends Layer
    implements Terminal {
        protected String topic;

        public Consumer(Node node) {
            super(node);
        }

        public String topic() {
            return this.topic;
        }

        public Consumer topic(String value) {
            this.topic = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("topic", new ArrayList<String>(Collections.singletonList(this.topic)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("topic")) {
                this.topic = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("topic")) {
                this.topic = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Parameter
    extends Layer
    implements Terminal {
        protected String name;
        protected String value;

        public Parameter(Node node) {
            super(node);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Parameter name(String value) {
            this.name = value;
            return this;
        }

        public Parameter value(String value) {
            this.value = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("name")) {
                this.name = (String)values.get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            }
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void parameter(Predicate<Parameter> filter) {
            new ArrayList<Parameter>(Box.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void consumer(Predicate<Consumer> filter) {
            new ArrayList<Consumer>(Box.this.consumerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void producer(Predicate<Producer> filter) {
            new ArrayList<Producer>(Box.this.producerList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Parameter parameter(String name, String value) {
            Parameter newElement = (Parameter)Box.this.core$().graph().concept(Parameter.class).createNode(this.name, Box.this.core$()).as(Parameter.class);
            newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
            newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
            return newElement;
        }

        public Consumer consumer(String topic) {
            Consumer newElement = (Consumer)Box.this.core$().graph().concept(Consumer.class).createNode(this.name, Box.this.core$()).as(Consumer.class);
            newElement.core$().set((Layer)newElement, "topic", Collections.singletonList(topic));
            return newElement;
        }

        public Producer producer(String tank) {
            Producer newElement = (Producer)Box.this.core$().graph().concept(Producer.class).createNode(this.name, Box.this.core$()).as(Producer.class);
            newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
            return newElement;
        }
    }
}

