/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui.display.view;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.services.ui.Renderer;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.services.ui.display.view.AbstractViewTemplate;
import io.intino.konos.builder.codegeneration.services.ui.display.view.ViewTemplate;
import io.intino.konos.model.graph.Catalog;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Mold;
import io.intino.konos.model.graph.View;
import io.intino.konos.model.graph.catalogcontainer.CatalogContainerView;
import io.intino.konos.model.graph.collectioncontainer.CollectionContainerView;
import io.intino.konos.model.graph.displaycontainer.DisplayContainerView;
import io.intino.konos.model.graph.gridcontainer.GridContainerView;
import io.intino.konos.model.graph.listcontainer.ListContainerView;
import io.intino.konos.model.graph.magazinecontainer.MagazineContainerView;
import io.intino.konos.model.graph.mapcontainer.MapContainerView;
import io.intino.konos.model.graph.panelcontainer.PanelContainerView;
import io.intino.konos.model.graph.setcontainer.SetContainerView;
import io.intino.tara.magritte.Node;
import java.io.File;
import java.util.List;
import org.siani.itrules.Template;
import org.siani.itrules.engine.formatters.StringFormatter;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ViewRenderer
extends Renderer {
    private final View view;
    private final Component owner;
    private final String box;
    private final String packageName;

    public ViewRenderer(View view, Component owner, String box, String packageName) {
        super(view.name$(), box, packageName);
        this.view = view;
        this.owner = owner;
        this.box = box;
        this.packageName = packageName;
    }

    @Override
    public Frame buildFrame() {
        Frame frame = super.buildFrame();
        frame.addTypes(new String[]{"view"}).addSlot("owner", new String[]{this.owner.name$()}).addSlot("ownerClass", new String[]{((Object)((Object)this.owner)).getClass().getSimpleName()}).addSlot("label", new String[]{this.view.label()}).addSlot("layout", new String[]{this.view.layout().name()}).addSlot("width", new Integer[]{this.view.width()});
        if (this.view.hidden() == View.Hidden.HiddenEnabled) {
            frame.addSlot("hidden", new AbstractFrame[]{this.hidden(this.view, this.box)});
            frame.addTypes(new String[]{"hasMethods"});
        }
        this.addViewProperties(frame);
        return frame;
    }

    @Override
    protected Template srcTemplate() {
        return Formatters.customize(ViewTemplate.create());
    }

    @Override
    protected Template genTemplate() {
        return Formatters.customize(AbstractViewTemplate.create());
    }

    @Override
    protected Updater updater(String displayName, File sourceFile) {
        return null;
    }

    private void addViewProperties(Frame frame) {
        frame.addSlot("viewDisplayLoaders", new AbstractFrame[]{new Frame(new String[]{"viewDisplayLoaders"}).addSlot("package", new String[]{this.packageName})});
        this.addCollectionContainerProperties(this.view, frame);
        this.addDisplayContainerProperties(this.view, frame);
        this.addMoldContainerProperties(this.view, frame);
        this.addCatalogContainerProperties(this.view, frame);
        this.addPanelContainerProperties(this.view, frame);
        this.addSetContainerProperties(this.view, frame);
    }

    private void addCollectionContainerProperties(View view, Frame frame) {
        if (!view.isCollectionContainer()) {
            return;
        }
        CollectionContainerView collectionView = this.view.asCollectionContainer();
        frame.addSlot("mold", new String[]{collectionView.mold().name$()});
        if (collectionView.noItemsMessage() != null) {
            frame.addSlot("noItemsMessage", new String[]{collectionView.noItemsMessage()});
        }
        this.addListContainerProperties(collectionView, frame);
        this.addGridContainerProperties(collectionView, frame);
        this.addMapContainerProperties(collectionView, frame);
        this.addMagazineContainerProperties(collectionView, frame);
    }

    private void addListContainerProperties(CollectionContainerView view, Frame frame) {
        if (!view.i$(ListContainerView.class)) {
            return;
        }
        frame.addTypes(new String[]{"list"});
    }

    private void addGridContainerProperties(CollectionContainerView view, Frame frame) {
        if (!view.i$(GridContainerView.class)) {
            return;
        }
        frame.addTypes(new String[]{"grid"});
    }

    private void addMapContainerProperties(CollectionContainerView view, Frame frame) {
        if (!view.i$(MapContainerView.class)) {
            return;
        }
        frame.addTypes(new String[]{"map"});
        MapContainerView mapView = (MapContainerView)view.a$(MapContainerView.class);
        if (mapView.center() != null) {
            frame.addSlot("latitude", new Double[]{mapView.center().latitude()}).addSlot("longitude", new Double[]{mapView.center().longitude()});
        }
        frame.addSlot("zoom", new AbstractFrame[]{new Frame(new String[]{"zoom"}).addSlot("default", new Integer[]{mapView.zoom().defaultZoom()}).addSlot("min", new Integer[]{mapView.zoom().min()}).addSlot("max", new Integer[]{mapView.zoom().max()})});
    }

    private void addMagazineContainerProperties(CollectionContainerView view, Frame frame) {
        if (!view.i$(MagazineContainerView.class)) {
            return;
        }
        frame.addTypes(new String[]{"magazine"});
    }

    private void addDisplayContainerProperties(View view, Frame frame) {
        if (!view.isDisplayContainer()) {
            return;
        }
        frame.addTypes(new String[]{"display"});
        DisplayContainerView displayView = view.asDisplayContainer();
        frame.addSlot("hideNavigator", new Boolean[]{displayView.hideNavigator()});
        frame.addSlot("display", new String[]{displayView.display()});
        if (this.owner.i$(Catalog.class)) {
            frame.addSlot("catalogScope", new AbstractFrame[]{new Frame(new String[]{"catalogScope"}).addSlot("name", new String[]{view.name$()}).addSlot("display", new String[]{displayView.display()}).addSlot("box", new String[]{this.box}).addSlot("owner", new String[]{this.owner.name$()})});
        }
    }

    private void addMoldContainerProperties(View view, Frame frame) {
        if (!view.isMoldContainer()) {
            return;
        }
        frame.addTypes(new String[]{"mold"});
        Mold mold = view.asMoldContainer().mold();
        frame.addSlot("mold", new String[]{mold.name$()});
    }

    private void addCatalogContainerProperties(View view, Frame frame) {
        if (!view.isCatalogContainer()) {
            return;
        }
        frame.addTypes(new String[]{"catalog"});
        CatalogContainerView catalogContainerView = view.asCatalogContainer();
        frame.addSlot("catalog", new String[]{catalogContainerView.catalog().name$()});
        frame.addSlot("catalogDisplayLoader", new AbstractFrame[]{new Frame(new String[]{"catalogDisplayLoader"}).addSlot("package", new String[]{this.packageName})});
        if (catalogContainerView.filtered()) {
            frame.addSlot("filter", new AbstractFrame[]{this.filterFrame(view, this.box)});
        }
    }

    private void addPanelContainerProperties(View view, Frame frame) {
        if (!view.isPanelContainer()) {
            return;
        }
        frame.addTypes(new String[]{"panel"});
        PanelContainerView panelContainerView = view.asPanelContainer();
        frame.addSlot("panel", new String[]{panelContainerView.panel().name$()});
    }

    private void addSetContainerProperties(View view, Frame frame) {
        if (!view.isSetContainer()) {
            return;
        }
        frame.addTypes(new String[]{"set"});
        SetContainerView setView = view.asSetContainer();
        frame.addSlot("viewContainerSetItems", new AbstractFrame[]{new Frame(new String[]{"viewContainerSetItems"}).addSlot("item", (AbstractFrame[])this.frameOf(setView.abstractItemList()))});
    }

    private Frame[] frameOf(List<SetContainerView.AbstractItem> items) {
        return (Frame[])items.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(SetContainerView.AbstractItem item) {
        if (item.i$(SetContainerView.Group.class)) {
            return this.frameOf((SetContainerView.Group)item.a$(SetContainerView.Group.class));
        }
        if (item.i$(SetContainerView.Items.class)) {
            return this.frameOf((SetContainerView.Items)item.a$(SetContainerView.Items.class));
        }
        return this.frameOf((SetContainerView.Item)item.a$(SetContainerView.Item.class));
    }

    private Frame frameOf(SetContainerView.Group group) {
        Frame frame = this.baseFrame(group).addTypes(new String[]{"group"}).addSlot("label", new String[]{group.label()}).addSlot("mode", new Object[]{group.mode()});
        if (!group.itemList().isEmpty()) {
            frame.addSlot("item", (AbstractFrame[])group.itemList().stream().map(this::frameOf).toArray(Frame[]::new));
        }
        if (!group.itemsList().isEmpty()) {
            frame.addSlot("item", (AbstractFrame[])group.itemsList().stream().map(this::frameOf).toArray(Frame[]::new));
        }
        return frame;
    }

    private Frame frameOf(SetContainerView.Item item) {
        Frame frame = this.baseFrame(item).addTypes(new String[]{"item"});
        View view = item.view();
        ViewRenderer builder = new ViewRenderer(view, this.owner, this.box, this.packageName);
        frame.addSlot("view", new AbstractFrame[]{builder.buildFrame()});
        return frame;
    }

    private Frame frameOf(SetContainerView.Items items) {
        Frame frame = this.baseFrame(items).addTypes(new String[]{"items"}).addSlot("layout", new String[]{this.owner.name$()}).addSlot("path", new String[]{this.pathOf(items.core$())}).addSlot("modelClass", new String[]{items.itemClass()});
        View view = items.view();
        ViewRenderer builder = new ViewRenderer(view, this.owner, this.box, this.packageName);
        frame.addSlot("view", new AbstractFrame[]{builder.buildFrame()});
        return frame;
    }

    private Frame baseFrame(SetContainerView.AbstractItem item) {
        Frame frame = new Frame(new String[]{"set", ((Object)((Object)item)).getClass().getSimpleName().toLowerCase()}).addSlot("box", new String[]{this.box}).addSlot("name", new String[]{item.name$()});
        if (item.hidden() == SetContainerView.AbstractItem.Hidden.HiddenEnabled) {
            frame.addSlot("hidden", new AbstractFrame[]{new Frame(new String[0]).addSlot("box", new String[]{this.box}).addSlot("layout", new String[]{this.owner.name$()}).addSlot("path", new String[]{this.pathOf(item.core$())})});
        }
        return frame;
    }

    private Frame filterFrame(View view, String box) {
        String itemClass = view.asCatalogContainer().catalog().itemClass();
        return new Frame(new String[]{"filter"}).addSlot("owner", new String[]{this.owner.name$()}).addSlot("view", new String[]{view.name$()}).addSlot("box", new String[]{box}).addSlot("itemClass", new String[]{itemClass});
    }

    private Frame hidden(View view, String box) {
        return new Frame(new String[]{"hidden"}).addSlot("owner", new String[]{this.owner.name$()}).addSlot("view", new String[]{view.name$()}).addSlot("box", new String[]{box});
    }

    private String pathOf(Node node) {
        String qn = "";
        Node parent = node;
        while (!parent.equals(this.view.core$())) {
            qn = StringFormatter.firstUpperCase().format((Object)parent.name()).toString() + (qn.isEmpty() ? "" : ".") + qn;
            parent = parent.owner();
        }
        qn = StringFormatter.firstUpperCase().format((Object)this.view.core$().name()).toString() + (qn.isEmpty() ? "" : ".") + qn;
        return qn;
    }
}

