/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import io.intino.konos.builder.KonosIcons;
import io.intino.konos.builder.actions.AccessorsPublisher;
import io.intino.konos.builder.actions.KonosAction;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class PublishAccessorAction
extends KonosAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"Publish Accessor: publish");
    private static final String TEXT = "Publish Konos Accessor";

    public PublishAccessorAction() {
        super(TEXT, "Publish Konos Accessor in Artifactory", KonosIcons.GENERATE_16);
        this.setShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"control alt A"}));
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setIcon(KonosIcons.PUBLISH_16);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        File file = new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        if (!file.exists()) {
            return;
        }
        String version = file.getParentFile().getName();
        if (module != null) {
            e.getPresentation().setText("Publish Konos Accessor for " + module.getName() + " (" + version + ")");
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (this.projectIsNull(e, project)) {
            return;
        }
        this.publish((Module)LangDataKeys.MODULE.getData(e.getDataContext()));
    }

    private void publish(final Module module) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(module.getProject(), "Publishing Konos Accessor", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                KonosGraph graph = GraphLoader.loadGraph(module);
                Configuration configuration = TaraUtil.configurationOf((Module)module);
                String generationPackage = configuration != null ? configuration.workingPackage() : "konos";
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                new AccessorsPublisher(module, graph, generationPackage).publish();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "io/intino/konos/builder/actions/PublishAccessorAction$1", "run"));
            }
        });
    }

    private boolean projectIsNull(AnActionEvent e, Project project) {
        if (project == null) {
            LOG.error("actionPerformed: no project for " + e);
            return true;
        }
        return false;
    }
}

