/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.actions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import io.intino.konos.builder.actions.IntinoTestTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.jms.JMSService;
import io.intino.konos.model.graph.rest.RESTService;
import io.intino.konos.model.graph.slackbot.SlackBotService;
import io.intino.konos.model.graph.ui.AbstractUIService;
import io.intino.konos.model.graph.ui.UIService;
import io.intino.tara.magritte.Layer;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class IntinoTestRenderer {
    private KonosGraph graph;
    private PsiDirectory directory;
    private String newName;

    IntinoTestRenderer(Module module, PsiDirectory directory, String newName) {
        this.directory = directory;
        this.newName = newName;
        this.graph = GraphLoader.loadGraph(module);
    }

    public String execute() {
        if (this.graph == null) {
            return null;
        }
        Frame frame = new Frame(new String[0]);
        frame.addTypes(new String[]{"intinoTest"}).addSlot("package", new String[]{this.calculatePackage()}).addSlot("name", new String[]{this.newName});
        this.addRESTServices(frame);
        this.addJMSServices(frame);
        this.addSlackServices(frame);
        this.addUIServices(frame);
        return this.template().format((Object)frame);
    }

    private String calculatePackage() {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(this.directory);
        return aPackage == null ? "" : aPackage.getQualifiedName();
    }

    private void addRESTServices(Frame frame) {
        for (RESTService service : this.graph.rESTServiceList()) {
            Frame restFrame = new Frame(new String[0]).addTypes(new String[]{"service", "rest"}).addSlot("name", new String[]{service.name$()});
            this.addUserVariables(service.a$(Service.class), restFrame, this.findCustomParameters(service));
            frame.addSlot("service", new AbstractFrame[]{restFrame});
        }
    }

    private void addJMSServices(Frame frame) {
        for (JMSService service : this.graph.jMSServiceList()) {
            Frame jmsFrame = new Frame(new String[0]).addTypes(new String[]{"service", "jms"}).addSlot("name", new String[]{service.name$()});
            this.addUserVariables(service.a$(Service.class), jmsFrame, this.findCustomParameters(service));
            frame.addSlot("service", new AbstractFrame[]{jmsFrame});
        }
    }

    private void addUIServices(Frame frame) {
        for (UIService service : this.graph.uIServiceList()) {
            Frame serviceFrame = new Frame(new String[0]).addTypes(new String[]{"service", "ui"}).addSlot("name", new String[]{service.name$()});
            frame.addSlot("service", new AbstractFrame[]{serviceFrame});
            if (service.authentication() != null) {
                serviceFrame.addTypes(new String[]{"auth"});
                serviceFrame.addSlot("auth", new String[]{service.authentication().by()});
            }
            this.addUserVariables(service, serviceFrame, this.findCustomParameters(service));
        }
    }

    private void addSlackServices(Frame frame) {
        for (SlackBotService service : this.graph.slackBotServiceList()) {
            frame.addSlot("service", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"service", "slack"}).addSlot("name", new String[]{service.name$()})});
        }
    }

    private void addUserVariables(Layer layer, Frame frame, Collection<String> userVariables) {
        for (String custom : userVariables) {
            frame.addSlot("custom", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"custom"}).addSlot("conf", new String[]{layer.name$()}).addSlot("name", new String[]{custom}).addSlot("type", new String[]{"String"})});
        }
    }

    private Set<String> findCustomParameters(JMSService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (JMSService.Request request : service.requestList()) {
            set.addAll(Commons.extractParameters(request.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(RESTService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (RESTService.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private Set<String> findCustomParameters(UIService service) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (service.authentication() != null) {
            set.addAll(Commons.extractParameters(service.authentication().by()));
        }
        for (AbstractUIService.Resource resource : service.resourceList()) {
            set.addAll(Commons.extractParameters(resource.path()));
        }
        return set;
    }

    private VirtualFile getTestRoot(Module module) {
        for (VirtualFile file : TaraUtil.getSourceRoots((Module)module)) {
            if (!file.isDirectory() || !"test".equals(file.getName())) continue;
            return file;
        }
        return null;
    }

    private Template template() {
        return Formatters.customize(IntinoTestTemplate.create());
    }
}

