/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.ness;

import io.intino.konos.model.graph.Client;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHandler;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.loaders.WordLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class NessClient
extends Layer
implements Terminal {
    protected String url;
    protected String user;
    protected String password;
    protected Mode mode;
    protected String domain;
    protected String clientID;
    protected List<MessageHandler> messageHandlerList = new ArrayList<MessageHandler>();
    protected Client _client;

    public NessClient(Node node) {
        super(node);
    }

    public String url() {
        return this.url;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public Mode mode() {
        return this.mode;
    }

    public String domain() {
        return this.domain;
    }

    public String clientID() {
        return this.clientID;
    }

    public NessClient url(String value) {
        this.url = value;
        return this;
    }

    public NessClient user(String value) {
        this.user = value;
        return this;
    }

    public NessClient password(String value) {
        this.password = value;
        return this;
    }

    public NessClient mode(Mode value) {
        this.mode = value;
        return this;
    }

    public NessClient domain(String value) {
        this.domain = value;
        return this;
    }

    public NessClient clientID(String value) {
        this.clientID = value;
        return this;
    }

    public List<MessageHandler> messageHandlerList() {
        return Collections.unmodifiableList(this.messageHandlerList);
    }

    public MessageHandler messageHandler(int index) {
        return this.messageHandlerList.get(index);
    }

    public List<MessageHandler> messageHandlerList(Predicate<MessageHandler> predicate) {
        return this.messageHandlerList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<MessageHandler>(this.messageHandlerList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
        map.put("user", new ArrayList<String>(Collections.singletonList(this.user)));
        map.put("password", new ArrayList<String>(Collections.singletonList(this.password)));
        map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
        map.put("domain", new ArrayList<String>(Collections.singletonList(this.domain)));
        map.put("clientID", new ArrayList<String>(Collections.singletonList(this.clientID)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("MessageHandler")) {
            this.messageHandlerList.add((MessageHandler)node.as(MessageHandler.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("MessageHandler")) {
            this.messageHandlerList.remove(node.as(MessageHandler.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("user")) {
            this.user = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("password")) {
            this.password = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("domain")) {
            this.domain = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("clientID")) {
            this.clientID = (String)StringLoader.load(values, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("url")) {
            this.url = (String)values.get(0);
        } else if (name.equalsIgnoreCase("user")) {
            this.user = (String)values.get(0);
        } else if (name.equalsIgnoreCase("password")) {
            this.password = (String)values.get(0);
        } else if (name.equalsIgnoreCase("mode")) {
            this.mode = (Mode)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("domain")) {
            this.domain = (String)values.get(0);
        } else if (name.equalsIgnoreCase("clientID")) {
            this.clientID = (String)values.get(0);
        }
    }

    protected void sync$(Layer layer) {
        super.sync$(layer);
        if (layer instanceof Client) {
            this._client = (Client)layer;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public class Clear {
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }
    }

    public static enum Mode {
        Normal,
        Transacted;

    }
}

