/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHandler;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Component;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Process
extends MessageHandler
implements Component,
Terminal {
    protected PreCondition preCondition;
    protected List<OnFinish> onFinishList = new ArrayList<OnFinish>();
    protected Job job;
    protected List<PostCondition> postConditionList = new ArrayList<PostCondition>();

    public Process(Node node) {
        super(node);
    }

    public PreCondition preCondition() {
        return this.preCondition;
    }

    public List<OnFinish> onFinishList() {
        return Collections.unmodifiableList(this.onFinishList);
    }

    public OnFinish onFinish(int index) {
        return this.onFinishList.get(index);
    }

    public List<OnFinish> onFinishList(Predicate<OnFinish> predicate) {
        return this.onFinishList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Job job() {
        return this.job;
    }

    public List<PostCondition> postConditionList() {
        return Collections.unmodifiableList(this.postConditionList);
    }

    public PostCondition postCondition(int index) {
        return this.postConditionList.get(index);
    }

    public List<PostCondition> postConditionList(Predicate<PostCondition> predicate) {
        return this.postConditionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Process preCondition(PreCondition value) {
        this.preCondition = value;
        return this;
    }

    public Process job(Job value) {
        this.job = value;
        return this;
    }

    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        if (this.preCondition != null) {
            components.add(this.preCondition.core$());
        }
        new ArrayList<OnFinish>(this.onFinishList).forEach(c -> components.add(c.core$()));
        if (this.job != null) {
            components.add(this.job.core$());
        }
        new ArrayList<PostCondition>(this.postConditionList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Process$PreCondition")) {
            this.preCondition = (PreCondition)node.as(PreCondition.class);
        }
        if (node.is("Process$OnFinish")) {
            this.onFinishList.add((OnFinish)node.as(OnFinish.class));
        }
        if (node.is("Process$Job")) {
            this.job = (Job)node.as(Job.class);
        }
        if (node.is("Process$PostCondition")) {
            this.postConditionList.add((PostCondition)node.as(PostCondition.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Process$PreCondition")) {
            this.preCondition = null;
        }
        if (node.is("Process$OnFinish")) {
            this.onFinishList.remove(node.as(OnFinish.class));
        }
        if (node.is("Process$Job")) {
            this.job = null;
        }
        if (node.is("Process$PostCondition")) {
            this.postConditionList.remove(node.as(PostCondition.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class PostCondition
    extends OnFinish
    implements Terminal {
        protected String type;

        public PostCondition(Node node) {
            super(node);
        }

        public String type() {
            return this.type;
        }

        public PostCondition type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("type", new ArrayList<String>(Collections.singletonList(this.type)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("type")) {
                this.type = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("type")) {
                this.type = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Job
    extends OnFinish
    implements Terminal {
        public Job(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class OnFinish
    extends Layer
    implements Terminal {
        public OnFinish(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public static class PreCondition
    extends Layer
    implements Terminal {
        public PreCondition(Node node) {
            super(node);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public class Clear {
        public void postCondition(Predicate<PostCondition> filter) {
            new ArrayList<PostCondition>(Process.this.postConditionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends MessageHandler.Create {
        public Create(String name) {
            super(name);
        }

        public PreCondition preCondition() {
            PreCondition newElement = (PreCondition)Process.this.core$().graph().concept(PreCondition.class).createNode(this.name, Process.this.core$()).as(PreCondition.class);
            return newElement;
        }

        public Job job() {
            Job newElement = (Job)Process.this.core$().graph().concept(Job.class).createNode(this.name, Process.this.core$()).as(Job.class);
            return newElement;
        }

        public PostCondition postCondition(String type) {
            PostCondition newElement = (PostCondition)Process.this.core$().graph().concept(PostCondition.class).createNode(this.name, Process.this.core$()).as(PostCondition.class);
            newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
            return newElement;
        }
    }
}

