/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake.process;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.process.ProcessCoordinatorTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Process;
import io.intino.konos.model.graph.ness.NessClient;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class ProcessCoordinatorRenderer {
    private final NessClient datalake;
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final List<Process> processes;

    public ProcessCoordinatorRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.datalake = graph.nessClientList().isEmpty() ? null : graph.nessClient(0);
        this.processes = !graph.nessClientList().isEmpty() ? graph.nessClient(0).messageHandlerList().stream().filter(h -> h.i$(Process.class)).map(h -> (Process)h.a$(Process.class)).collect(Collectors.toList()) : Collections.emptyList();
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        if (this.processes.isEmpty()) {
            return;
        }
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"processes"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.datalake.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("process", (AbstractFrame[])this.processes());
        frame.addSlot("clientId", new AbstractFrame[]{new Frame(new String[]{this.isCustom(this.datalake.clientID()) ? "custom" : "standard"}).addSlot("value", new String[]{this.datalake.clientID()})});
        if (!this.datalake.graph().schemaList().isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        Commons.writeFrame(new File(this.gen, "ness"), "ProcessCoordinator", this.template().format((Object)frame));
    }

    private Frame[] processes() {
        return (Frame[])this.processes.stream().map(this::frameOf).toArray(Frame[]::new);
    }

    private Frame frameOf(Process process) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tank"}).addSlot("box", new String[]{this.boxName}).addSlot("name", new String[]{this.composedName(process)}).addSlot("messageType", new String[]{this.fullName(process)});
        if (process.schema() != null) {
            frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{process.schema().name$()})});
        } else {
            frame.addSlot("type", new String[]{"message"});
        }
        return frame;
    }

    private String fullName(Process process) {
        return (this.datalake.domain().isEmpty() ? "" : this.datalake.domain() + ".") + this.subdomain(process) + this.name(process);
    }

    private String composedName(Process handler) {
        return handler.subdomain().isEmpty() ? "" : handler.subdomain() + Commons.firstUpperCase(this.name(handler));
    }

    private String subdomain(Process process) {
        return process.subdomain().isEmpty() ? "" : process.subdomain() + ".";
    }

    private String name(Process process) {
        return process.schema() == null ? process.name$() : process.schema().name$();
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private Template template() {
        return Formatters.customize(ProcessCoordinatorTemplate.create()).add("shortPath", value -> {
            String[] names = value.toString().split("\\.");
            return names[names.length - 1];
        });
    }
}

