/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import cottons.utils.StringHelper;
import io.intino.konos.builder.codegeneration.BoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.helpers.Commons;
import io.intino.tara.compiler.shared.Configuration;
import io.intino.tara.dsl.Proteo;
import io.intino.tara.dsl.Verso;
import io.intino.tara.plugin.lang.psi.impl.TaraUtil;
import java.io.File;
import java.util.ArrayList;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class BoxRenderer {
    private final File destination;
    private final String packageName;
    private final Module module;
    private final Configuration configuration;
    private boolean isTara;

    public BoxRenderer(File destination, String packageName, Module module, boolean isTara) {
        this.destination = destination;
        this.packageName = packageName;
        this.module = module;
        this.configuration = module != null ? TaraUtil.configurationOf((Module)module) : null;
        this.isTara = isTara;
    }

    public void execute() {
        String name = this.name();
        if (this.configuration == null || Commons.javaFile(this.destination, StringHelper.snakeCaseToCamelCase((String)name) + "Box").exists()) {
            return;
        }
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"Box"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name});
        if (this.isTara) {
            frame.addSlot("tara", new AbstractFrame[]{this.fillTara()});
        }
        DumbService.getInstance((Project)this.module.getProject()).setAlternativeResolveEnabled(true);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.module.getProject());
        if (facade.findClass("io.intino.konos.server.ui.services.AuthService", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module)) != null) {
            frame.addSlot("rest", new String[]{name});
        }
        DumbService.getInstance((Project)this.module.getProject()).setAlternativeResolveEnabled(false);
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)name) + "Box", this.template().format((Object)frame));
    }

    private Frame fillTara() {
        Frame frame = new Frame(new String[0]);
        frame.addSlot("name", new String[]{this.name()});
        if (this.configuration.outDSL() != null) {
            frame.addSlot("outDSL", new String[]{this.configuration.outDSL()});
        }
        frame.addSlot("wrapper", this.dsls());
        return frame;
    }

    private String[] dsls() {
        ArrayList<String> dsls = new ArrayList<String>();
        for (Configuration.LanguageLibrary lang : this.configuration.languages()) {
            if (Verso.class.getSimpleName().equals(lang.name()) || Proteo.class.getSimpleName().equals(lang.name())) continue;
            String genPackage = lang.generationPackage();
            dsls.add((genPackage == null ? "" : genPackage.toLowerCase() + ".") + Formatters.firstUpperCase(lang.name()));
        }
        if (this.configuration.level() != Configuration.Level.Solution) {
            dsls.add(this.configuration.workingPackage().toLowerCase() + "." + Formatters.firstUpperCase(this.configuration.outDSL()));
        }
        return dsls.toArray(new String[dsls.size()]);
    }

    private Template template() {
        return Formatters.customize(BoxTemplate.create());
    }

    private String name() {
        if (this.module != null) {
            String dsl = this.configuration.outDSL();
            return dsl == null || dsl.isEmpty() ? this.module.getName() : dsl;
        }
        return Configuration.Level.Solution.name();
    }
}

