/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import java.util.Locale;
import org.siani.itrules.LineSeparator;
import org.siani.itrules.Template;
import org.siani.itrules.model.Condition;
import org.siani.itrules.model.Rule;
import org.siani.itrules.model.Token;

public class AbstractBoxTemplate
extends Template {
    protected AbstractBoxTemplate(Locale locale, LineSeparator separator) {
        super(locale, separator);
    }

    public static Template create() {
        return new AbstractBoxTemplate(Locale.ENGLISH, LineSeparator.LF).define();
    }

    public Template define() {
        this.add(new Rule[]{this.rule().add(new Condition[]{this.condition("type", "box")}).add((Token.Body)this.literal("package ")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(";\n\nimport java.util.LinkedHashMap;\nimport java.util.Map;\nimport java.util.UUID;")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[0])).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("import java.util.HashMap;")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("import java.util.Map;")).add((Token.Body)this.literal("\n"))).add((Token.Body)this.literal("\nimport org.slf4j.Logger;\nimport org.slf4j.LoggerFactory;\nimport java.util.logging.ConsoleHandler;\nimport java.util.logging.Level;\nimport static org.slf4j.Logger.ROOT_LOGGER_NAME;\n")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.mark("hasREST", new String[0])).add((Token.Body)this.literal("import io.intino.konos.alexandria.rest.AlexandriaSpark;"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("import io.intino.konos.alexandria.ui.displays.Soul;"))).add((Token.Body)this.literal("\n\npublic abstract class AbstractBox extends ")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[]{"uiBox"})).or(this.expression().add((Token.Body)this.literal("io.intino.konos.alexandria.Box")))).add((Token.Body)this.literal(" {\n\tprivate static Logger logger = LoggerFactory.getLogger(ROOT_LOGGER_NAME);\n\tprotected ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Configuration configuration;")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("service", new String[]{"field"}).multiple("\n"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("dataLake", new String[]{"field"}).multiple("\n"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("task", new String[]{"field"}))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("    ")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("protected Map<String, Soul> uiSouls = new java.util.HashMap<>();"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("    ")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("private java.util.List<io.intino.konos.alexandria.ui.UIBox.SoulsClosed> soulsClosedListeners = new java.util.ArrayList<>();"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("private io.intino.konos.alexandria.ui.services.AuthService authService;"))).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t")).add((Token.Body)this.mark("hasUi", new String[]{"hide"})).add((Token.Body)this.literal("private io.intino.konos.alexandria.ui.services.EditorService editorService;"))).add((Token.Body)this.literal("\n\n\tpublic AbstractBox(String[] args) {\n\t\tthis(new ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Configuration(args));\n\t}\n\t\n\tpublic AbstractBox(")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Configuration configuration) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("owner = new ")).add((Token.Body)this.mark("parent", new String[0])).add((Token.Body)this.literal("Box(configuration);"))).add((Token.Body)this.literal("\n\t\tthis.configuration = configuration;")).add((Token.Body)this.expression().add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\tinitLogger();")).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t\t")).add((Token.Body)this.mark("service", new String[]{"setup"}).multiple("\n"))).add((Token.Body)this.literal("\n\t}\n\n\tpublic ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Configuration configuration() {\n\t\treturn (")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Configuration) configuration;\n\t}\n\n\t@Override\n\tpublic io.intino.konos.alexandria.Box put(Object o) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasParent", new String[0])).add((Token.Body)this.literal("owner.put(o);"))).add((Token.Body)this.literal("\n\t\treturn this;\n\t}\n\n\tpublic io.intino.konos.alexandria.Box open() {\n\t\tif(owner != null) owner.open();\n\t\tinitLogger();\n\t\tinitUI();\n\t\tinitRESTServices();\n\t\tinitJMXServices();\n\t\tinitJMSServices();\n\t\tinitDataLake();\n\t\tinitTasks();\n\t\tinitSlackBots();\n\t\treturn this;\n\t}\n\n\tpublic void close() {\n\t\tif(owner != null) owner.close();\n\t\t")).add((Token.Body)this.mark("spark", new String[0]).multiple("\n")).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.mark("service", new String[]{"quit"}).multiple("\n")).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.mark("dataLake", new String[]{"quit"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[]{"registerSoul"})).add((Token.Body)this.literal("\n")).add((Token.Body)this.literal("\t"))).add((Token.Body)this.expression().add((Token.Body)this.mark("service", new String[]{"getter"}).multiple("\n\n"))).add((Token.Body)this.literal("\n\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[]{"authService"}))).add((Token.Body)this.literal("\n\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("hasUi", new String[]{"editorService"}))).add((Token.Body)this.literal("\n\t")).add((Token.Body)this.mark("dataLake", new String[]{"getter"}).multiple("\n\n")).add((Token.Body)this.literal("\n\n\t")).add((Token.Body)this.mark("task", new String[]{"getter"}).multiple("\n\n")).add((Token.Body)this.literal("\n\n\tprivate void initRESTServices() {\n\t\t")).add((Token.Body)this.mark("service", new String[]{"rest"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initJMSServices() {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.mark("jms", new String[0])).add((Token.Body)this.literal("javax.jms.Connection connection;"))).add((Token.Body)this.literal("\n\t\t")).add((Token.Body)this.mark("service", new String[]{"jms"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initJMXServices() {\n\t\t")).add((Token.Body)this.mark("service", new String[]{"jmx"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initSlackBots() {\n\t\t")).add((Token.Body)this.mark("service", new String[]{"slack"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initUI() {\n\t\t")).add((Token.Body)this.mark("service", new String[]{"ui"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initDataLake() {\n\t\t")).add((Token.Body)this.mark("dataLake", new String[]{"init"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initTasks() {\n\t\t")).add((Token.Body)this.mark("task", new String[]{"init"}).multiple("\n")).add((Token.Body)this.literal("\n\t}\n\n\tprivate void initLogger() {\n\t\tfinal java.util.logging.Logger logger = java.util.logging.Logger.getGlobal();\n\t\tfinal ConsoleHandler handler = new ConsoleHandler();\n\t\thandler.setLevel(Level.INFO);\n\t\thandler.setFormatter(new io.intino.konos.alexandria.LogFormatter(\"log\"));\n\t\tlogger.setUseParentHandlers(false);\n\t\tlogger.addHandler(handler);\n\t}\n\n\tprivate static java.net.URL url(String url) {\n\t\ttry {\n\t\treturn new java.net.URL(url);\n\t\t} catch (java.net.MalformedURLException e) {\n\t\t\treturn null;\n\t\t}\n\t}\n}")), this.rule().add(new Condition[]{this.condition("trigger", "uiBox")}).add((Token.Body)this.literal("io.intino.konos.alexandria.ui.UIBox")), this.rule().add(new Condition[]{this.condition("type", "service & ui"), this.condition("trigger", "setup")}).add((Token.Body)this.literal("this.authService = ")).add((Token.Body)this.expression().add((Token.Body)this.literal("this.authService(")).add((Token.Body)this.mark("authentication", new String[0])).add((Token.Body)this.literal(")")).or(this.expression().add((Token.Body)this.literal("null")))).add((Token.Body)this.literal(";\nthis.editorService = ")).add((Token.Body)this.expression().add((Token.Body)this.literal("this.editorService(")).add((Token.Body)this.mark("edition", new String[0])).add((Token.Body)this.literal(")")).or(this.expression().add((Token.Body)this.literal("null")))).add((Token.Body)this.literal(";\nio.intino.konos.alexandria.ui.UIAlexandriaSpark.setup(Integer.parseInt(")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal("), \"www/\", this.authService, this.editorService);")), this.rule().add(new Condition[]{this.condition("type", "service & rest"), this.condition("trigger", "setup")}).add((Token.Body)this.literal("io.intino.konos.alexandria.ui.UIAlexandriaSpark.setup(Integer.parseInt(")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal("), \"www/\", null, null);")), this.rule().add(new Condition[]{this.condition("type", "service & jmx"), this.condition("trigger", "jmx")}).add((Token.Body)this.literal("this.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstLowerCase"})).add((Token.Body)this.literal(" = new JMX")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("().init(((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this));\nlogger.info(\"JMX service ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");")), this.rule().add(new Condition[]{this.condition("type", "service & slack"), this.condition("trigger", "slack")}).add((Token.Body)this.literal("this.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstLowerCase"})).add((Token.Body)this.literal(" = new ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("SlackBot((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this, ")).add((Token.Body)this.mark("parameter", new String[0])).add((Token.Body)this.literal(");\nlogger.info(\"Slack service ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");\n")), this.rule().add(new Condition[]{this.condition("type", "service & rest"), this.condition("trigger", "rest")}).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Resources.setup(io.intino.konos.alexandria.ui.UIAlexandriaSpark.instance(), (")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this).start();\nlogger.info(\"REST service ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");")), this.rule().add(new Condition[]{this.condition("type", "service & ui"), this.condition("trigger", "ui")}).add((Token.Body)this.literal("io.intino.konos.alexandria.ui.UIAlexandriaSpark sparkInstance = io.intino.konos.alexandria.ui.UIAlexandriaSpark.instance();\n")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal(".init(sparkInstance, (")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);\nio.intino.konos.alexandria.ui.UiElements.initDisplays(sparkInstance);\nsparkInstance.start();\nlogger.info(\"UI ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");")), this.rule().add(new Condition[]{this.condition("type", "service & jms"), this.condition("trigger", "jms")}).add((Token.Body)this.literal("try {\n\tconnection = new org.apache.activemq.ActiveMQConnectionFactory(")).add((Token.Body)this.mark("parameter", new String[0]).multiple(", ")).add((Token.Body)this.literal(").createConnection();\n\tjava.lang.Thread thread = new java.lang.Thread(() -> {\n\t\ttry {\n\t\t\tconnection.start();\n\t\t\tthis.")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})).add((Token.Body)this.literal(" = new ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Service(connection, (")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);\n\t\t\tlogger.info(\"JMS service ")).add((Token.Body)this.mark("name", new String[0])).add((Token.Body)this.literal(": started!\");\n\t\t} catch (javax.jms.JMSException e) {\n\t\t\tlogger.error(e.getMessage());\n\t\t}\n\t}, \"jms init\");\n\tthread.start();\n\tthread.join(10000);\n} catch (javax.jms.JMSException | InterruptedException e) {\n\tlogger.error(e.getMessage());\n}")), this.rule().add(new Condition[]{this.condition("type", "dataLake"), this.condition("trigger", "init")}).add((Token.Body)this.literal("this.ness = new io.intino.konos.datalake.Ness(")).add((Token.Body)this.mark("parameter", new String[0]).multiple(", ")).add((Token.Body)this.literal(");\njava.lang.Thread thread = new java.lang.Thread(() -> {\n\tthis.ness.connect(\"")).add((Token.Body)this.mark("mode", new String[0])).add((Token.Body)this.literal("\");\n\t")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".ness.TanksConnectors.registerTanks((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);\n\t")).add((Token.Body)this.mark("package", new String[0])).add((Token.Body)this.literal(".ness.NessOperations.init((")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);\n\tlogger.info(\"Ness connection: started!\");\n}, \"ness init\");\ntry {\n\tthread.start();\n\tthread.join(10000);\n} catch (InterruptedException e) {\n\tlogger.error(e.getMessage());\n}")), this.rule().add(new Condition[]{this.condition("type", "custom"), this.condition("trigger", "parameter")}).add((Token.Body)this.literal("configuration().get(\"")).add((Token.Body)this.mark("value", new String[]{"customParameter"})).add((Token.Body)this.literal("\")")), this.rule().add(new Condition[]{this.condition("type", "custom"), this.condition("trigger", "authentication")}).add((Token.Body)this.literal("url(configuration().get(\"")).add((Token.Body)this.mark("value", new String[]{"customParameter"})).add((Token.Body)this.literal("\"))")), this.rule().add(new Condition[]{this.condition("type", "custom"), this.condition("trigger", "edition")}).add((Token.Body)this.literal("url(configuration().get(\"")).add((Token.Body)this.mark("value", new String[]{"customParameter"})).add((Token.Body)this.literal("\"))")), this.rule().add(new Condition[]{this.condition("trigger", "parameter")}).add((Token.Body)this.literal("\"")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("\"")), this.rule().add(new Condition[]{this.condition("trigger", "authentication")}).add((Token.Body)this.literal("url(\"")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("\")")), this.rule().add(new Condition[]{this.condition("trigger", "edition")}).add((Token.Body)this.literal("url(\"")).add((Token.Body)this.mark("value", new String[0])).add((Token.Body)this.literal("\")")), this.rule().add(new Condition[]{this.condition("attribute", "Transacted"), this.condition("trigger", "mode")}).add((Token.Body)this.literal("Transacted")), this.rule().add(new Condition[]{this.condition("trigger", "mode")}), this.rule().add(new Condition[]{this.condition("type", "service & jmx"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private io.intino.konos.jmx.JMXServer ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.condition("type", "service & slack"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private io.intino.konos.slack.Bot ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.condition("type", "service & jms"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Service ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";")), this.rule().add(new Condition[]{this.condition("type", "task"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private io.intino.konos.scheduling.KonosTasker tasker = new io.intino.konos.scheduling.KonosTasker();")), this.rule().add(new Condition[]{this.condition("type", "dataLake"), this.condition("trigger", "field")}).add((Token.Body)this.literal("private io.intino.konos.datalake.Ness ness;")), this.rule().add(new Condition[]{this.condition("type", "service & jms"), this.condition("trigger", "getter")}).add((Token.Body)this.literal("public ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("Service ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal("() {\n\treturn ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";\n}")), this.rule().add(new Condition[]{this.condition("type", "dataLake"), this.condition("trigger", "getter")}).add((Token.Body)this.literal("public io.intino.konos.datalake.Ness datalake() {\n\treturn this.ness;\n}")), this.rule().add(new Condition[]{this.condition("type", "service & slack"), this.condition("trigger", "getter")}).add((Token.Body)this.literal("public ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("SlackBot ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal("() {\n\treturn (")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstUpperCase"})).add((Token.Body)this.literal("SlackBot) ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(";\n}")), this.rule().add(new Condition[]{this.condition("type", "service"), this.condition("trigger", "getter")}), this.rule().add(new Condition[]{this.condition("trigger", "spark")}).add((Token.Body)this.literal("io.intino.konos.alexandria.ui.UIAlexandriaSpark.instance().stop();")), this.rule().add(new Condition[]{this.condition("type", "service"), this.condition("type", "jms"), this.condition("trigger", "quit")}).add((Token.Body)this.literal("if (")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(" != null) ")).add((Token.Body)this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstlowerCase"})).add((Token.Body)this.literal(".closeSession();")), this.rule().add(new Condition[]{this.condition("type", "dataLake"), this.condition("trigger", "quit")}).add((Token.Body)this.literal("if (ness != null) ness.disconnect();")), this.rule().add(new Condition[]{this.condition("type", "service"), this.condition("trigger", "quit")}), this.rule().add(new Condition[]{this.condition("type", "service")}), this.rule().add(new Condition[]{this.condition("type", "task"), this.condition("trigger", "init")}).add((Token.Body)this.literal("Tasks.init(this.tasker, (")).add((Token.Body)this.mark("configuration", new String[]{"SnakeCaseToCamelCase", "FirstUpperCase"})).add((Token.Body)this.literal("Box) this);")), this.rule().add(new Condition[]{this.condition("type", "task"), this.condition("trigger", "getter")}).add((Token.Body)this.literal("public io.intino.konos.scheduling.KonosTasker tasker() {\n\treturn this.tasker;\n}")), this.rule().add(new Condition[]{this.condition("trigger", "authservice")}).add((Token.Body)this.literal("protected abstract io.intino.konos.alexandria.ui.services.AuthService authService(java.net.URL authServiceUrl);")), this.rule().add(new Condition[]{this.condition("trigger", "editorService")}).add((Token.Body)this.literal("protected abstract io.intino.konos.alexandria.ui.services.EditorService editorService(java.net.URL editorServiceUrl);\n\npublic io.intino.konos.alexandria.ui.services.EditorService editorService() {\n\treturn this.editorService;\n}")), this.rule().add(new Condition[]{this.condition("trigger", "registerSoul")}).add((Token.Body)this.literal("public java.util.List<Soul> souls() {\n\treturn new java.util.ArrayList<>(uiSouls.values());\n}\n\n\tpublic java.util.Optional<Soul> soul(String clientId) {\n\t\treturn java.util.Optional.ofNullable(uiSouls.get(clientId));\n\t}\n\n\tpublic void registerSoul(String clientId, Soul soul) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("if (owner != null) ((")).add((Token.Body)this.mark("parent", new String[0])).add((Token.Body)this.literal("Box) owner).registerSoul(clientId, soul);"))).add((Token.Body)this.literal("\n\t\tuiSouls.put(clientId, soul);\n\t}\n\n\tpublic void unRegisterSoul(String clientId) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("if (owner != null) ((")).add((Token.Body)this.mark("parent", new String[0])).add((Token.Body)this.literal("Box) owner).unRegisterSoul(clientId);"))).add((Token.Body)this.literal("\n\t\tuiSouls.remove(clientId);\n\t\tif (uiSouls.size() <= 0) notifySoulsClosed();\n\t}\n\n\tpublic void onSoulsClosed(io.intino.konos.alexandria.ui.UIBox.SoulsClosed listener) {\n\t\t")).add((Token.Body)this.expression().add((Token.Body)this.literal("if (owner != null) ((")).add((Token.Body)this.mark("parent", new String[0])).add((Token.Body)this.literal("Box) owner).onSoulsClosed(listener);"))).add((Token.Body)this.literal("\n\t\tthis.soulsClosedListeners.add(listener);\n\t}\n\n\tprivate void notifySoulsClosed() {\n\t\tsoulsClosedListeners.forEach(l -> l.accept());\n\t}")), this.rule().add(new Condition[]{this.condition("trigger", "import")}), this.rule().add(new Condition[]{this.condition("trigger", "parentInit")}), this.rule().add(new Condition[]{this.condition("trigger", "hide")})});
        return this;
    }
}

