/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake.mounter;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.mounter.MounterTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHandler;
import io.intino.konos.model.graph.Mounter;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class MounterRenderer {
    private final List<Mounter> mounters;
    private final File src;
    private final String packageName;
    private final String boxName;

    public MounterRenderer(KonosGraph graph, File src, String packageName, String boxName) {
        this.mounters = graph.nessClient(0).messageHandlerList().stream().filter(h -> h.i$(Mounter.class)).map(h -> (Mounter)h.a$(Mounter.class)).collect(Collectors.toList());
        this.src = src;
        this.packageName = packageName;
        this.boxName = boxName;
    }

    public void execute() {
        for (Mounter mounter : this.mounters) {
            String handlerName;
            File destination;
            String name = this.composedName(mounter);
            Frame frame = new Frame(new String[0]).addTypes(new String[]{"mounter"}).addSlot("box", new String[]{this.boxName}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{name});
            if (mounter.schema() != null) {
                frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
                frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{mounter.schema().name$()})});
            } else {
                frame.addSlot("type", new String[]{"message"});
            }
            if (this.alreadyRendered(destination = new File(this.src, "ness/mounters"), handlerName = name + "Mounter")) continue;
            Commons.writeFrame(destination, handlerName, Formatters.customize(MounterTemplate.create()).format((Object)frame));
        }
    }

    private String composedName(MessageHandler handler) {
        return Commons.firstUpperCase((handler.subdomain().isEmpty() ? "" : Formatters.snakeCaseToCamelCase().format((Object)handler.subdomain().replace(".", "_"))) + Commons.firstUpperCase(this.name(handler)));
    }

    private String name(MessageHandler handler) {
        return handler.schema() == null ? handler.name$() : handler.schema().name$();
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

