/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datalake;

import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.datalake.TanksConnectorsTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Feeder;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHandler;
import io.intino.konos.model.graph.Mounter;
import io.intino.konos.model.graph.ness.NessClient;
import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.siani.itrules.Template;
import org.siani.itrules.model.AbstractFrame;
import org.siani.itrules.model.Frame;

public class TanksConnectorsRenderer {
    private final NessClient datalake;
    private final File gen;
    private final String packageName;
    private final String boxName;
    private final Set<MessageHandler> handlers;

    public TanksConnectorsRenderer(KonosGraph graph, File gen, String packageName, String boxName) {
        this.gen = gen;
        this.packageName = packageName;
        this.boxName = boxName;
        this.datalake = graph.nessClient(0);
        this.handlers = new TreeSet<MessageHandler>((o1, o2) -> this.namesake((MessageHandler)((Object)o1), (MessageHandler)((Object)o2)) ? 0 : -1);
        this.handlers.addAll(this.datalake.messageHandlerList().stream().filter(h -> h.i$(Mounter.class) || h.i$(Feeder.class)).collect(Collectors.toList()));
    }

    private boolean namesake(MessageHandler o1, MessageHandler o2) {
        return this.fullName(o1).equalsIgnoreCase(this.fullName(o2));
    }

    public void execute() {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tanks"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{this.datalake.name$()}).addSlot("box", new String[]{this.boxName}).addSlot("tank", (AbstractFrame[])this.handlers.stream().map(this::frameOf).toArray(Frame[]::new));
        frame.addSlot("clientId", new AbstractFrame[]{new Frame(new String[]{this.isCustom(this.datalake.clientID()) ? "custom" : "standard"}).addSlot("value", new String[]{this.datalake.clientID()})});
        if (!this.handlers.isEmpty()) {
            frame.addSlot("tankImport", new String[]{this.packageName});
        }
        if (!this.datalake.graph().schemaList().isEmpty()) {
            frame.addSlot("schemaImport", new AbstractFrame[]{new Frame(new String[0]).addTypes(new String[]{"schemaImport"}).addSlot("package", new String[]{this.packageName})});
        }
        Commons.writeFrame(new File(this.gen, "ness"), "TanksConnectors", this.template().format((Object)frame));
    }

    private Frame frameOf(MessageHandler handler) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"tank", ((Object)((Object)handler)).getClass().getSimpleName().toLowerCase()}).addSlot("name", new String[]{this.composedName(handler)}).addSlot("box", new String[]{this.boxName}).addSlot("messageType", new String[]{this.fullName(handler)});
        if (handler.schema() != null) {
            frame.addSlot("type", new AbstractFrame[]{new Frame(new String[]{"schema"}).addSlot("package", new String[]{this.packageName}).addSlot("name", new String[]{handler.schema().name$()})});
        } else {
            frame.addSlot("type", new String[]{"message"});
        }
        return frame;
    }

    private String fullName(MessageHandler handler) {
        return this.domain() + this.subdomain(handler) + this.name(handler);
    }

    private String domain() {
        return this.datalake.domain().isEmpty() ? "" : this.datalake.domain() + ".";
    }

    private String composedName(MessageHandler handler) {
        return Commons.firstUpperCase((handler.subdomain().isEmpty() ? "" : Formatters.snakeCaseToCamelCase().format((Object)handler.subdomain().replace(".", "_"))) + Commons.firstUpperCase(this.name(handler)));
    }

    private String subdomain(MessageHandler handler) {
        return handler.subdomain().isEmpty() ? "" : handler.subdomain() + ".";
    }

    private String name(MessageHandler handler) {
        return handler.schema() == null ? handler.name$() : handler.schema().name$();
    }

    private Frame customize(String name, String topic) {
        Frame frame = new Frame(new String[0]).addTypes(new String[]{"messageType"});
        frame.addSlot("name", new String[]{topic});
        for (String parameter : Commons.extractParameters(topic)) {
            frame.addSlot("custom", new AbstractFrame[]{this.custom(name, parameter)});
        }
        return frame;
    }

    private boolean isCustom(String value) {
        return value != null && value.startsWith("{");
    }

    private Frame custom(String name, String parameter) {
        return new Frame(new String[0]).addSlot("value", new String[]{parameter}).addSlot("conf", new String[]{name});
    }

    private Template template() {
        return Formatters.customize(TanksConnectorsTemplate.create()).add("shortPath", value -> {
            String[] names = value.toString().split("\\.");
            return names[names.length - 1];
        });
    }
}

